#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/netadmin_dir_owner.pl /main/4 2012/01/03 10:24:56 hpalitan Exp $
#
# netadmin_dir_owner.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      netadmin_dir_owner.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hpalitan    12/28/11 - Only raise violation when Group or World has write
#                           access
#    hpalitan    02/17/11 - Use get_osType()
#    mperugu     05/06/10 - Creation
#

use strict;
use warnings;
use vars qw($S);

use File::stat;
use File::Find;

require "db/esaUtils.pl";
require "db/db_common.pl";
require "find_os.pl";

my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
my $fpath = $oracleHome.$S."network".$S."admin".$S;
my $oracleGName;
my $OSNAME = get_osType();

#Owner#
my $property="netadmin_owner";

#my $oracleOwner= file_owner($oracleHome);#works for both mswin32, and linux
my  $oracleOwner =getOracleSoftwareOwner($oracleHome);#works for mswin32, GI, and linux

my $retOwner=file_owner($fpath);

  EMD_PERL_DEBUG("netadmin_dir_owner: OS          = $OSNAME");
  EMD_PERL_DEBUG("netadmin_dir_owner: oracleHome  = $oracleHome");
  EMD_PERL_DEBUG("netadmin_dir_owner: oracleOwner = $oracleOwner");
  EMD_PERL_DEBUG("netadmin_dir_owner: property    = $property");
  EMD_PERL_DEBUG("netadmin_dir_owner: retOwner    = $retOwner");
  
if(uc($retOwner) ne uc($oracleOwner))
{
   my $fpath_t = check_512char($fpath);
   print "em_result=$property|$retOwner|$fpath_t\n";
}

#Permissions#
my $count1;
my $count2;
$property="netadmin_perm";

if ($OSNAME ne "WIN")
{
   $count1=0;
   $count2=0;

   $oracleGName=file_gname($oracleHome);
   find(\&viol_check,$fpath);
   if($count1>0 || $count2>0)
   {
      print "em_result=$property|$count1|$count2\n";
   }   

}
elsif($OSNAME eq "WIN")
{
  $count1=0;
  $count2=0;
  find(\&viol_check_win,$fpath);
  if($count1>0 || $count2>0)
   {
      print "em_result=nt_$property|$count1|$count2\n";
   }

}
sub file_gname #for linux
{
   my $fileName = shift;
   
   if(!(defined $fileName) || $fileName eq "")
   {
     return ""; 
   }
   
   my $info=stat($fileName);
   my $gid;
   my $name;

   if($info)
   {
      $gid =$info->gid;
      $name=getgrgid($gid);
   }
   else
   {
      return "";
   }

   return $name;
   
}
sub viol_check
{
  my $cur_path=$File::Find::name;
  my $cur_owner;
  my $cur_group;
  my $perm;

  $cur_owner=file_owner($cur_path);
  $cur_group=file_gname($cur_path);
  $perm     =file_perm($cur_path);   
  if(uc($cur_owner) ne uc($oracleOwner))
  {
     $count1++;
  } 

  if(uc($cur_group) ne uc($oracleGName))
  {
     $count2++;
  }
  
  if($perm >0)
  {
     if($perm & 0022)
     {
       $count2++; 
     }    
  } 

}

sub viol_check_win
{
   my $cur_path=$File::Find::name;
   my $cur_owner;
   my $users;

   $cur_path =~ s/\//\\/g;#perl find will always attach forward slash as directory separator
                              #converting it into backslash for mswin32, for want of a better alternative  
   $cur_owner=file_owner($cur_path);
   $users     =file_perm($cur_path);

   if(uc($cur_owner) ne uc($oracleOwner))
  {
     $count1++;
  }
  if($users !=-1)
  {
      if($users ne "0()")
      {
        $count2++;
      }
  }
}

