#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/ob/ob_devices.pl /main/3 2010/07/18 00:53:21 prapatil Exp $
#
# ob_devices.pl
# 
# Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ob_devices.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pfgavin     01/22/10 - fix error
#    pfgavin     12/29/09 - fix 9246217
#    pfgavin     05/13/08 - 
#    swbalasu    10/30/07 - Creation
#
require "db/ob/ob_common.pl";
init();

$ob_command="$OBTOOL --gui --user $ob_username lsdev --long --reservations --description";
OBrunOb();
if (checkErrorsAndWarnings() == 1)
{
  # Sometimes errors are embedded in the lsdev output. We only want to exit if we get no device output.
  if (rindex($rbug, "Device type:") == -1 && rindex($rbug, "In service:") == -1)
  {
    exit 0;
  }
}

# Parse the output of the obtool command in $rbug and generate multiple print statements one each for a single device in the form
# print "em_result=<devicename>|<devicetype>|<Library>|<Slot Number>|<Status>|<State>|<Maintenance/Cleaning required>|<Media Server>|<Vendor>|<Firmware>\n";

my @matrix = parseObOutput($rbug);
my $length = @matrix;
my $output;
my $dev_name, $dev_type, $dev_slot, $dev_status, $dev_active, $dev_clean, $dev_mediaserver, $dev_vendor, $dev_firmware, $dev_lib;
my $res_component, $res_host, $res_process;
for ($count = 0; $count <= $length; $count++) 
{
  my $name = "$matrix[$count]->[0]";
  my $value = "$matrix[$count]->[1]";
  next if (!$name && !$value);
  next if (length $name == 0 && length $value == 0);
  
  if ( length $value == 0 && 
       rindex ($matrix[$count +1]->[0], "Device type") > -1
     )
  {
    #start of next device;
    print "em_result=$dev_name|$dev_type|$dev_lib|$dev_slot|$dev_status|$dev_active|$dev_clean|$dev_mediaserver|$dev_vendor|$dev_firmware|$res_component|$res_process|$res_host" if length $dev_name > 0;
    $dev_name = "$name"; #reinitialize the rest
    $dev_type = "";
    $dev_slot = "";
    $dev_status = "";
    $dev_active = 0;
    $dev_clean = "";
    $dev_mediaserver = "";
    $dev_vendor = "";
    $dev_firmware = "";
    $dev_lib = "";
    $res_component = "";
    $res_host = "";
    $res_process = "";
  }
  elsif ( rindex ($name, "Device type") > -1 )
  {
    $dev_type = "$value";
  }
  elsif ( rindex ($name, "In service") > -1 )
  {
    $dev_status = "$value";
  }
  elsif ( rindex ($name, "Reservation") > -1 )
  {
    $dev_active = 1;
  }
  elsif ( rindex ($name, "Component") > -1 )
  {
    $res_component = "$value";
  }
  elsif ( rindex ($name, "Process") > -1 )
  {
    $res_process = "$value";
  }
  elsif ( rindex ($name, "Host") > -1 )
  {
    if (rindex($matrix[$count -1]->[0], "Attachment") > -1)
    {
      $dev_mediaserver .= "," if length $dev_mediaserver > 0;
      $dev_mediaserver .= "$value";
    }
    else
    {
      $res_host = "$value";
    }
  }
  elsif ( rindex ($name, "Vendor") > -1 )
  {
    $dev_vendor = "$value";
  }
  elsif ( rindex ($name, "Product") > -1 )
  {
    $dev_vendor .= " $value";
  }
  elsif ( rindex ($name, "Firmware") > -1 )
  {
    $dev_firmware = "$value";
  }
  elsif ( rindex ($name, "Library") > -1 )
  {
    $dev_lib = "$value";
  }
  elsif ( rindex ($name, "DTE") > -1 )
  {
    $dev_slot = "$value";
  }
  elsif ( rindex ($name, "Cleaning required") > -1 )
  {
    $dev_clean = "$value";
  }
}

#print the last device details
print "em_result=$dev_name|$dev_type|$dev_lib|$dev_slot|$dev_status|$dev_active|$dev_clean|$dev_mediaserver|$dev_vendor|$dev_firmware|$res_component|$res_process|$res_host" if length $dev_name > 0;

exit 0;
