#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/ob/ob_jobs.pl /main/6 2011/01/17 05:55:28 pfgavin Exp $
#
# ob_jobs.pl
# 
# Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ob_jobs.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pfgavin     01/06/10 - readd ; to command
#    pfgavin     11/02/10 - fix hang
#    pfgavin     02/05/10 - include media movement and duplication jobs
#    swbalasu    09/18/08 - bug 7654377
#    pfgavin     09/23/08 - completed jobs in last 24 hours
#    swbalasu    09/18/08 - performance fix
#    swbalasu    02/06/08 - new metric - failed in last 24 hours
#    swbalasu    01/28/08 - fixing job type in query
#    swbalasu    10/30/07 - Creation
#
use Time::Local;
require "db/ob/ob_common.pl";
#hash map to hold ids of jobs printed to stdout. used to avoid duplicate key error
my %hashJobIds = ();

# Parse the output of the obtool command and generate multiple print statements one each for a single job in the form
# print "em_result=<JobId>|<Type>|<State>|<RunOnHost>|<Information>\n";
sub handleJobOutput
{
  my @matrix = parseObOutput($rbug);
  my $length = @matrix;
  my $output;
  my $job_id, $job_type1, $job_type2, $job_state, $job_host, $job_info;
  #include only jobs having include_status1 pattern in their status.
  my $include_status1, $include_status2;
  for ($count = 0; $count <= $length; $count++) 
  {
    my $name = "$matrix[$count]->[0]";
    my $value = "$matrix[$count]->[1]";
    next if (!$name && !$value);
    next if (length $name == 0 && length $value == 0);
  
    if ( length $value == 0 && 
         rindex ($matrix[$count +1]->[0], "Type") > -1
       )
    {
      #start of next job;
      if (!$hashJobIds {$job_id})
      {
        print "em_result=$job_id|$job_type1|$job_state|$job_host|$job_info" if length $job_id > 0 && ( !$include_status1 || rindex($job_state, $include_status1) > -1);
        $hashJobIds {$job_id} = $job_id if length $job_id > 0  && ( !$include_status1 || rindex($job_state, $include_status1) > -1);
        #additional status checks within same state 
        print "em_result=$job_id|$job_type2|$job_state|$job_host|$job_info" if length $job_id > 0 && ( length $include_status2 > 0 && rindex($job_state, $include_status2) > -1);
        $hashJobIds {$job_id} = $job_id if length $job_id > 0  && ( length $include_status2 > 0 && rindex($job_state, $include_status2) > -1);
      }
      $job_id = "$name"; #reinitialize the rest
      $job_state = "";
      $job_host = "";
      $job_info = "";
    }
    elsif (rindex ($name, "Output of command") > -1)
    {
      #start of next set of output
      #first print the previous collected entry
      if (!$hashJobIds {$job_id})
      {
        print "em_result=$job_id|$job_type1|$job_state|$job_host|$job_info" if length $job_id > 0 && ( !$include_status1 || rindex($job_state, $include_status1) > -1);
        $hashJobIds {$job_id} = $job_id if length $job_id > 0  && ( !$include_status1 || rindex($job_state, $include_status1) > -1);
        #additional status checks within same state 
        print "em_result=$job_id|$job_type2|$job_state|$job_host|$job_info" if length $job_id > 0 && ( length $include_status2 > 0 && rindex($job_state, $include_status2) > -1);
        $hashJobIds {$job_id} = $job_id if length $job_id > 0  && ( length $include_status2 > 0 && rindex($job_state, $include_status2) > -1);
      }

      $job_id = ""; #reinitialize the rest
      $job_state = "";
      $job_host = "";
      $job_info = "";

       # switch the job_type1 for this set of output
       if (rindex($value, "--pending") > -1)
       {
          $job_type1 = "pending_resources";
          $include_status1 = "";
          $job_type2 = "";
          $include_status2 = "";
       }
       elsif (rindex($value, "--inputrequest") > -1)
       {
          $job_type1 = "pending_user_input";
          $include_status1 = "";
          $job_type2 = "";
          $include_status2 = "";
       }
       elsif (rindex($value, "--complete") > -1)
       {
          $job_type1 = "failed24";
          $include_status1 = "failed";
          $job_type2 = "completed24";
          $include_status2 = "completed";
       }
       elsif (rindex($value, "--active") > -1)
       {
          $job_type1 = "active";
          $include_status1 = "";
          $job_type2 = "";
          $include_status2 = "";
       }
    }
    elsif ( rindex ($name, "Type") > -1 )
    {
      $job_info = "$value";
    }
    elsif ( rindex ($name, "State") > -1 )
    {
      $job_state = "$value";
    }
    elsif ( rindex ($name, "Run on host") > -1 )
    {
      $job_host = "$value";
    }
    elsif ( rindex ($name, "Deferred because") > -1 )
    {
      $job_info .= ". $name $value";
    }
  }

  #print the last device details
  if (!$hashJobIds {$job_id})
  {
     print "em_result=$job_id|$job_type1|$job_state|$job_host|$job_info" if length $job_id > 0  && ( !$include_status1 || rindex($job_state, $include_status1) > -1);
     $hashJobIds {$job_id} = $job_id if length $job_id > 0  && ( !$include_status1 || rindex($job_state, $include_status1) > -1);
  }

}

init();
my $COMMAND_SEP = " ';' " ;
if ($NT)
{
   $COMMAND_SEP = " ; ";
}

#pending jobs
$ob_command="$OBTOOL --gui --user $ob_username lsjob --long  --type mediamovement,duplication,backup,restore --pending";
#handleJobOutput("pending_resources") if (length $rbug > 0);

#append command for jobs waiting for user input
$ob_command .= $COMMAND_SEP;
$ob_command .= "lsjob --long --type mediamovement,duplication,backup,restore --inputrequest";

#active jobs
$ob_command .= $COMMAND_SEP;
$ob_command .= "lsjob --long  --type mediamovement,duplication,backup,restore --active";

#running as 2 sets of obtool executions due to command length restriction in windows
OBrunOb();
EMD_PERL_DEBUG("ob_jobs.pl: OBrunOb returned");
exit 0 if (checkErrorsAndWarnings() == 1);
my $rbug_copy = $rbug;  #store the output to use later

#failed jobs in last 24 hours
#there is no direct filter to get failed jobs, so the workaround is to get completed jobs which include failed as well, then manually extract only the failed jobs from the result set.
#include only those jobs that have the string "failed" in their status
EMD_PERL_DEBUG("ob_jobs.pl: using epoch time to calculate from and to timestamp");
$to = time;
($sec1,$min1,$hour1,$mday1,$mon1,$year1,$wday1,$yday1,$isdst1) = localtime($to);
my $todate = sprintf "%4d/%02d/%02d.%02d:%02d:%02d",$year1+1900,$mon1+1,$mday1,$hour1,$min1,$sec1;

$from = $to - 24*60*60; #current time - 24 hours
($sec2,$min2,$hour2,$mday2,$mon2,$year2,$wday2,$yday2,$isdst2) = localtime($from);
my $fromdate = sprintf "%4d/%02d/%02d.%02d:%02d:%02d",$year2+1900,$mon2+1,$mday2,$hour2,$min2,$sec2;

EMD_PERL_DEBUG("ob_jobs.pl: from date is $fromdate and");
EMD_PERL_DEBUG("ob_jobs.pl: to date is $todate");
$ob_command="$OBTOOL --gui --user $ob_username lsjob --long  --type mediamovement,duplication,backup,restore --complete --from $fromdate --to $todate";
$ob_command .= $COMMAND_SEP; #needed to get the string "Output of command:..." in the output.

OBrunOb();
EMD_PERL_DEBUG("ob_jobs.pl: OBrunOb returned");
exit 0 if (checkErrorsAndWarnings() == 1);
$rbug .= $rbug_copy;  #combine the output from the 2 commands.
handleJobOutput() if (length $rbug > 0);
EMD_PERL_DEBUG("ob_jobs.pl: handleJobOutput returned");

if(keys  %hashJobIds == 0)
{
  #print dummy row to clear out the contents on the oms side
  print "em_result=n/a|n/a|n/a|n/a|No operations pending resources, pending user input, failed in last 24 hours or currently active.";
}
EMD_PERL_DEBUG("ob_jobs.pl: ready to  exit");

exit 0;
