#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/ohBinFilesOwner.pl /st_emgc_pt-12.1.0.4pg/1 2012/11/21 05:36:30 rkpandey Exp $
#
# ohBinFilesOwner.pl
# 
# Copyright (c) 2004, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ohBinFilesOwner.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rkpandey    11/12/12 - 15860724:exclude nmhs jssu
#    hpalitan    12/27/11 - Support Grid Infrastructure
#    hpalitan    02/17/11 - Use get_osType()
#    mkiran      09/15/10 - 10111787: Use "eq" instead of "==". And, 
#                           exclude files nm[ob][0], extjob[0], oradism[0]
#    hpalitan    05/10/10 - Collect ORACLE_HOME owner
#    ssalunke    12/11/06 - Adding support for other unix operating systems
#    dsukhwal    05/12/05 - limit number of rows pushed 
#    dsukhwal    05/05/05 - handle win32 cases 
#    dkjain      04/12/05 - modified check condition 
#    dkjain      03/27/05 - Filtering out the files owned by root 
#    dkjain      02/28/05 - Fixed bug-4191040 
#    dkjain      12/30/04 - Adding check_512char,check_64char is removed
#    dkjain      10/31/04 - Bug-3977629
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
  
   use strict ;
   require "db/esaDbUtils.pl";
   require "db/esaUtils.pl";
   require "find_os.pl";
   
   my $maxRows = $ENV{'OHBINOWN'};
   my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
   my $property = "oh_bin_files_owner" ;
   my $oracleOwner ;
   my $limit = 0;
   my $OSNAME = get_osType();
   
   my $oh_owner =file_owner($oracleHome);#works for both mswin32, and linux
   $oracleOwner =getOracleSoftwareOwner($oracleHome);#works for mswin32, GI, and linux

  EMD_PERL_DEBUG("ohExeBinPerm: OS          = $OSNAME");
  EMD_PERL_DEBUG("ohExeBinPerm: oracleHome  = $oracleHome");
  EMD_PERL_DEBUG("ohExeBinPerm: oracleOwner = $oracleOwner");
  EMD_PERL_DEBUG("ohExeBinPerm: property    = $property");
  
   print "em_result=oh_owner|$oh_owner|NA\n";
   print "em_result=software_owner|$oracleOwner|NA\n";

   if($OSNAME ne "WIN"){
     my %h=(wanted=>\&verify_files_owner, follow=>1, follow_skip=>2);
     find(\%h, qq($oracleHome/bin)); 
   }
   elsif($OSNAME eq 'WIN'){
     find(\&verify_files_owner, qq($oracleHome/bin)); 
   }
  #else { code for systems neither mswin32, nor linux}



  #This is to collect owner of a given pathname 
 sub verify_files_owner{
    my $fpath=$File::Find::name;
    if($OSNAME eq "WIN"){#perl find will always attach forward slash as directory separator
        $fpath =~ s/\//\\/g;#converting it into backslash for mswin32, for want of a better alternative
    }
    my $retOwner =  file_owner($fpath);

    # 10111787: Metric result would include binaries that violated 
    #           "Oracle Home Executable Files Owner" Policy. 
    #           Let's exclude following binaries :
    #           <a> Any binary owned by Oracle Home Owner.
    #           <b> extjob/extjob0 owned by user 'root' or 'nobody'
    #           <c> nmo/nmo0/nmb/nmb0 owned by user 'root' 
    #           <d> oradism/oradism0 owned by user 'root' 
    if ( (uc($retOwner) ne uc($oracleOwner)) && ($retOwner ne "") && ($retOwner != -1)
        && !( ($retOwner =~ m/(nobody|root)/) && ($fpath =~ m/[\/\\]EXTJOB0?$/i) )
        && !( ($retOwner eq 'root') && ($fpath =~ m/[\/\\]NM[OB]0?$/i) )
        && !( ($retOwner eq 'root') && ($fpath =~ m/[\/\\]ORADISM0?$/i) ) 
        && !( ($retOwner eq 'root') && ($fpath =~ m/[\/\\]JSSU?$/i) ) 
        && !( ($retOwner eq 'root') && ($fpath =~ m/[\/\\]NMHS?$/i) ) )
    { 
        $fpath = check_512char($fpath);  
        print "em_result=$property|$retOwner|$fpath\n";
        $limit++ ;   #limiting the uploaded rows to $maxRows
        if( ($limit > $maxRows-1)  &&  ($maxRows != -1) ){
    	  exit(0);
	}
    }
 }

