#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/ohExeBinPerm.pl /main/20 2012/01/03 10:24:56 hpalitan Exp $
#
# ohExeBinPerm.pl
# 
# Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ohExeBinPerm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hpalitan    12/28/11 - Only raise violation when Group or World has write
#                           access
#    hpalitan    02/17/11 - Use get_osType()
#    kganapat    12/03/07 - XbranchMerge kganapat_filter_ora_errs from main
#    manosing    12/28/06 - flood control for windows policy
#    manosing    12/21/06 - adding check for  "0()"
#    ssalunke    12/11/06 - Adding support for other unix operating systems
#    dkjain      07/03/05 - Fixed the em_error with print 
#    dsukhwal    05/12/05 - limit number of rows pushed 
#    dsukhwal    05/05/05 - handle win32 cases 
#    dkjain      03/22/05 - perm mask filter for the group. 
#    dkjain      02/28/05 - Fixed bug-4191040 
#    dsukhwal    02/15/05 - exceptional cases in file_perm usage 
#    dkjain      12/28/04 - 
#    dkjain      10/31/04 - Bug-3977629
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
  use strict ;
  require "db/esaDbUtils.pl";
  require "db/esaUtils.pl";
  require "emd_common.pl";
  require "semd_common.pl";
  require "find_os.pl";
  
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $property = "oh_exebin_files_perm";
  my $dsn = "dbi:Oracle:" ;
  my $ed9i = 0 ; 
  my $limit = 0 ;
  my $maxCount;
  my %stdinArgs = get_stdinvars();
  my $username = $stdinArgs{"EM_TARGET_USERNAME"};
  my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
  my $address = $ENV{EM_TARGET_ADDRESS};
  my $role = $ENV{EM_TARGET_ROLE};
  my $mode = 0;
  my $OSNAME = get_osType();

  if($OSNAME eq 'WIN'){
    $maxCount = $ENV{'NOHEXEPERM'};
  }else{
    $maxCount = $ENV{'OHEXEPERM'};
  }
  
  if($role =~ /SYSDBA/i)
  {
    $mode = 2;
  }
  elsif($role =~ /SYSOPER/i)
  {
    $mode = 4;
  }

  EMD_PERL_DEBUG("ohExeBinPerm: OS         = $OSNAME");
  EMD_PERL_DEBUG("ohExeBinPerm: oracleHome = $oracleHome");
  EMD_PERL_DEBUG("ohExeBinPerm: maxRows    = $maxCount");
  EMD_PERL_DEBUG("ohExeBinPerm: property   = $property");
  EMD_PERL_DEBUG("ohExeBinPerm: role       = $role");
  EMD_PERL_DEBUG("ohExeBinPerm: mode       = $mode");

  
  my $dbh; 
  my $table;
  my $banner;
  my $sth;

  $dbh = open_db_connection("dbi:Oracle:", "$username@".$address,$password,$mode); 
  $table = "v\$version" ;
  $banner = "banner" ;
  $sth = $dbh->prepare_cached("SELECT $banner FROM $table where $banner like '%Oracle%' ")
	or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
  $sth->execute()
    or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));

  close_db_connection($dbh) ;

  my @edition = $sth->fetchrow_array();
  #if($edition[0]=~ "9i")
  #{
  #   $ed9i = 1 ;
  #}
  if($OSNAME ne "WIN") {
      #find(\&verify_files_perm,qq($oracleHome/bin) );
      my %h=(wanted=>\&verify_files_perm, follow=>1, follow_skip=>2);
      find(\%h, qq($oracleHome/bin)); 
  }
  elsif($OSNAME eq "WIN"){
      find(\&verify_files_perm_win32, qq($oracleHome/bin)); 
  }
    
 #This is to verify perm of a given pathname recursively.
 sub verify_files_perm{
    my $fpath=$File::Find::name;
    my $retModeCrude  =  file_perm($fpath);
    my $retMode = $retModeCrude & 0777;
    if( ($retModeCrude >=0 ) && ($retMode & 022) ){
       $fpath = check_512char($fpath);
       printf "em_result=$property|%03o|$fpath\n",$retMode;
       $limit++ ;
       if(  ($limit > $maxCount-1)  &&  ($maxCount != -1)  ){
           exit(0);
       }   
    }
 }

 sub verify_files_perm_win32{
    my $fpath=$File::Find::name;
        $fpath =~ s/\//\\/g;#perl find will always attach forward slash as directory separator
                    #converting it into backslash for mswin32, for want of a better alternative
    if(!compareNegInf($limit, $maxCount)){
        exit(0);
    }
    my $users = win32_file_perm($fpath);
    if($users != -1){
        if($users ne "0()"){
            print "em_result=nt_$property|$users|$fpath\n";
        $limit++;
    }
    }
 }

