#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/ohFilesPerm.pl /st_emgc_pt-12.1.0.4pg/1 2012/11/21 05:36:30 rkpandey Exp $
#
# ohFilesPerm.pl
# 
# Copyright (c) 2004, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ohFilesPerm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rkpandey    11/13/12 - report only world writable files
#    hpalitan    12/27/11 - Check for 755
#    hpalitan    02/17/11 - Use get_osType()
#    hpalitan    09/24/10 - Bug #10073887
#    manosing    01/12/07 - XbranchMerge manosing_lastpols from main
#    dsukhwal    01/06/07 - XbranchMerge manosing_ntpol from main
#    manosing    04/18/07 - bug 6002889
#    manosing    12/04/06 - bug 5443094
#    ssalunke    12/11/06 - Adding support for other unix operating systems
#    dsukhwal    05/12/05 - limit number of rows pushed 
#    dkjain      03/28/05 - Limiting number of rows to be uploaded to 200
#    dsukhwal    02/15/05 - exceptional cases in file_perm usage 
#    dkjain      12/30/04 - check_permission is removed 
#    dkjain      10/31/04 - Bug-3977629
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
 #As this is it to be collected for unix env only.
  use strict ;

  # get $ORACLE_HOME from environment
  require "db/esaDbUtils.pl";
  require "db/esaUtils.pl";
  require "find_os.pl";

  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $maxRows    = $ENV{'OHPERM'};
  my $maxRows1   = $ENV{'OHPERM1'};
  my $property   = "oh_files_perm";
  my $limit      = 0;
  my $OSNAME = get_osType();

  EMD_PERL_DEBUG("ohFilesPerl: OS         = $OSNAME");
  EMD_PERL_DEBUG("ohFilesPerl: oracleHome = $oracleHome");
  EMD_PERL_DEBUG("ohFilesPerl: maxRows    = $maxRows");
  EMD_PERL_DEBUG("ohFilesPerl: maxRow1    = $maxRows1");
  EMD_PERL_DEBUG("ohFilesPerl: property   = $property");
  
##find command will invoke the verify_files_perm on each file under the given point
#Which is ORACLE_HOME for this policy

  eval{

    if($OSNAME ne "WIN") {
     find(\&verify_files_perm,$oracleHome);
    }
    elsif($OSNAME eq 'WIN'){
     find(\&verify_files_perm_win32, $oracleHome); 
    }

  };

  if($@)
  {
    # log the message to the log file
    EMD_PERL_ERROR("ERROR: $@->getErrorMessage()");

    # send the warning message to emagent
    print "em_error = $@->getErrorMessage()\n";
  }

##############################################################################################

  #This is to verify owner of a given pathname recursively.
  sub verify_files_perm{

    my $fpath=$File::Find::name;
    my $permString ;
    my $flag = 0 ; 

    EMD_PERL_DEBUG("ohFilesPerl.verify_files_perm: IN ");

    if(!($fpath=~ qq($oracleHome/bin) ))
    {   
     my $retMode  =  file_perm($fpath);
     if($retMode >= 0){
       $retMode = $retMode & 0777 ;
       if(($retMode & 002)){ 
          $fpath = check_512char($fpath);
          if(  ($limit >= $maxRows-1)  &&  ($maxRows != -1)  ){
            exit(0);
          }
          #$permString = rwx_string($retMode);
          printf "em_result=$property|%03o|$fpath\n",$retMode;
          $limit++ ;   #limiting the uploaded rows to 200
       }
     }
   } 

   EMD_PERL_DEBUG("ohFilesPerl.verify_files_perm: OUT");   
}



 sub verify_files_perm_win32{
    my $fpath=$File::Find::name;
    $fpath =~ s/\//\\/g;#perl find will always attach forward slash as directory separator
                    #converting it into backslash for mswin32, for want of a better alternative
		    

    if(!compareNegInf($limit, $maxRows1)){
        exit(0);
    }

    EMD_PERL_DEBUG("ohFilesPerl.verify_files_perm_win32: IN");

    my $users = win32_file_perm($fpath);
    if($users != -1){
        if($users ne "0()"){
	    print "em_result=nt_$property|$users|$fpath\n";
            $limit++;
        }
    }

    EMD_PERL_DEBUG("ohFilesPerl.verify_files_perm_win32: OUT");    

 }



