# $Header: emll/plugins/extensions/oracle.sysman.db/OCMMetrics/agent/scripts/db/oracle_database_assoc.pl /main/3 2012/10/03 15:57:41 fmorshed Exp $
#
# Package : oracle_database_assoc.pl
#
# Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       oracle_database_assoc.pl
#
#   DESCRIPTION
#       Returns information on targets associated with this iAS instance
#
#   List of standard assocation types are in
#   ecmAssoc.pm
#
#   returns potentially multiple 
# em_result=association_type|target_name|target_type|target_properties
#
# association_type: one of the types listed in ecmAssoc.pm
# target_name: the target_name of the associated target
# target_type: the target_type of the associated target
# target_properties: related information that may help determine true target name given the target_type
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      fmorshed   10/02/12 - Remove / as first character to query targets.xml
#      fmorshed   01/19/12 - In advent of central collector, change query of
#                 targets.xml to account for the new hierarchy of tags.
#      glavash    05/04/11 - remove full path on requires
#      glavash    03/28/11 - ocm file
#      glavash    07/06/09 - remove target_name from assoc to cell targets
#      aghanti    05/26/09 - Open the LL file in proper encoding
#      ysun       04/27/09 - add test for oracle_cell type
#      ysun       04/07/09 - add exadata association
#      pparida    10/17/07 - XbranchMerge pparida_bug-6492554 from
#                            st_emll_10.2.7
#      pparida    10/15/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                            state and config dirs.
#      dkapoor    01/31/07 - XbranchMerge dkapoor_bug-5857460 from
#                            st_emll_10.2.5
#      dkapoor    01/31/07 - don't return with -1
#      ndutko     08/03/05 - ndutko_code_checkin
#      dkapoor    06/22/05 - Created
##*************************************************************

use strict;
#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;
use ias::simpleXPath;

require "semd_common.pl";
require "ccr/ccr_common.pl";

my ($configFile) = @ARGV;

#******************************************
#     Global Variables
#*****************************************
      my $result = ();
#
# as new relationships are exposed, add them here
#
my @racdb_assoc_results;

my $targetName = $ENV{TARGET_NAME};
my $discoveredTargetsFile = $ENV{CCR_CONFIG_HOME} . "/config/default/targets.xml";
my $oracleHome = $ENV{ORACLE_HOME};
my $ohQueryPrefix = 'TargetHomes/TargetHome[@LOCATION="' . $ENV{ORACLE_HOME} . '"]';

# read thru discovered targets file and pull out associated rac instance targets

if (-e $discoveredTargetsFile)
{
      my @assocTargets = simpleXPathQuery($discoveredTargetsFile, $ohQueryPrefix.'/Targets/Target[@NAME="'.$targetName.'"]/CompositeMembership/MemberOf'); 
      for my $assocTarget (@assocTargets)
      {
      		print ("em_result=".$ecmAssoc::MEMBER_OF."|". $$assocTarget{'NAME'}."|".$$assocTarget{'TYPE'}."|\n");
      }
      # get the associated cell targets
      my @cellTargets = simpleXPathQuery($discoveredTargetsFile, $ohQueryPrefix.'/Targets/Target[@NAME="'.$targetName.'"]/AssocTargetInstance'); 
      foreach my $cellTarget (@cellTargets)
      {
          if ($$cellTarget{'ASSOC_TARGET_TYPE'} eq 'oracle_cell') 
          {
              print ("em_result=".$ecmAssoc::DEPENDS_ON."||".
                 $$cellTarget{'ASSOC_TARGET_TYPE'}."|".
                 $$cellTarget{'ASSOC_TARGET_PROPERTY'}."|\n");
          }
      }
}

if (!defined $configFile )
{
    EMD_PERL_ERROR("em_error=The livelink configuration file not passed.");
    print STDERR "em_error=The livelink configuration file not passed.\n";
    exit (-1);
}
if( !(-f $configFile))
{
    print STDERR "em_error=The livelink configuration file \"$configFile\" not found.\n";
    exit ;
}

#Get the db charset and map it to corresponding perl encoding
my $llOpenMode = getLLFileOpenMode($configFile);

my $CONFIG_FILE_READER;
if(open(CONFIG_FILE_READER, $llOpenMode, $configFile))
{
    my $line;
    while($line = <CONFIG_FILE_READER>)
    {
        chomp($line);
        if ($line =~ /^OSMInstance\s*=\s*(.*)\s*$/)
	{
      		print ("em_result=".$ecmAssoc::DEPENDS_ON."||". $ecmAssoc::ASM_INSTANCE_TYPE."|".$1."\n");
		exit 0;
	}
    }
}
close(CONFIG_FILE_READER);
