# $Header: emdb/sysman/admin/scripts/db/oracle_pdb_assoc.pl /st_emgc_pt-12.1.0.4pg/2 2012/08/27 14:28:55 jsutton Exp $
#
# Package : oracle_pdb_assoc.pl
#
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#   NAME
#       oracle_pdb_assoc.pl
#
#   DESCRIPTION
#       Returns information on targets associated with this pdb instance
#
#   List of standard assocation types are in ecmAssoc.pm
#
#   returns potentially multiple 
# em_result=association_type|target_name|target_type|target_properties
#
# association_type: one of the types listed in ecmAssoc.pm
# target_name: the target_name of the associated target
# target_type: the target_type of the associated target
# target_properties: related information that may help determine true target name given the target_type
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      jsutton    05/22/12 - Created
##*************************************************************

use strict;
#
# relationship types are defined in ecmassoc.pm
#
use ecmAssoc;
use ias::simpleXPath;

require "semd_common.pl";

#******************************************
#     Global Variables
#*****************************************
my $result = ();
#
# as new relationships are exposed, add them here
#
my @pdb_assoc_results;

my $targetName = $ENV{TARGET_NAME};
my $discoveredTargetsFile = $ENV{CCR_CONFIG_HOME} . "/config/default/targets.xml";

# read thru discovered targets file and pull out targets this oracle_pdb relates to
if (-e $discoveredTargetsFile)
{
  my @assocTargets = simpleXPathQuery($discoveredTargetsFile, 'Targets/Target[@NAME="'.$targetName.'"]/AssocTargetInstance'); 
  for my $assocTarget (@assocTargets)
  {
    print ("em_result=".$$assocTarget{'ASSOCIATION_NAME'}."|". $$assocTarget{'ASSOC_TARGET_NAME'}."|".$$assocTarget{'ASSOC_TARGET_TYPE'}."|\n");
  }
}

