#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/osmFlexEnabled.pl /st_emgc_pt-12.1.0.4pg/3 2012/11/28 06:19:47 rrarajag Exp $
#
# osmRemoteEnabled.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      osmRemoteEnabled.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rrarajag    10/23/12 - Fix to get correct ASM instance count
#    rajverma    09/10/12 - Creation
#

# Get $ORACLE_HOME
 my ($oh) = @ARGV;

#Find ASM Version 
  my $asm_ver = $oh."/bin/srvctl -version";
  my $ver_supported = "12.1.0.0.0";
  my $ver_out = `$asm_ver`;
  $ver_out =~ s/version://;
  $ver_out =~ s/srvctl//;
  $ver_out = trim($ver_out);

#Find if Remote enabled.
  my $rasm_cmd = $oh."/bin/srvctl config asm -S 1";
  my @rasm_out = `$rasm_cmd`;

   if($ver_out ge $ver_supported )
   {
    foreach $line (@rasm_out)
     {
        chop($line);
        if( $line  =~ /.*?count\s*=\s*\{(.*?)\}/i)
        {
            if($1 =~ /\d+/i)
            {
                print "em_result=true\n";
            }
            else
            {
                print "em_result=false\n";
            }
        }
        else
        {
             print "em_result=false\n";
        }
     }
    }

sub trim {
   my($string)=@_;
   for ($string) {
       s/^\s+//;
       s/\s+$//;
   }
   return $string;
}


