#!/usr/local/bin/perl
# 
# $Header: osmresp.pl 11-dec-2007.03:42:10 kganapat Exp $
#
# osmresp.pl
# 
# Copyright (c) 2004, 2007, Oracle. All rights reserved.  
#
#    NAME
#      osmresp.pl - ASM response metric
#
#    DESCRIPTION
#      ASM response metric
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    kganapat    11/29/07 - XbranchMerge kganapat_filter_ora_errs from main
#    jochen      07/29/04 - jochen_bug-3445521
#    jochen      07/26/04 - Creation
# 

use strict;
use Oraperl;
use DBI;
use DBI qw(:sql_types);

require "emd_common.pl";

my %stdinArgs = get_stdinvars();

my $username = $stdinArgs{"EM_TARGET_USERNAME"};
my $password = $stdinArgs{"EM_TARGET_PASSWORD"};

my $address = $ENV{EM_TARGET_ADDRESS};
my $role = $ENV{EM_TARGET_ROLE};

my $mode = 0;
if($role =~ /SYSDBA/i)
{
  $mode = 2;
}
elsif($role =~ /SYSOPER/i)
{
  $mode = 4;
}

my $lda;
unless ( $lda = DBI->connect('dbi:Oracle:', "$username@".$address, "$password", 
                            {ora_session_mode => $mode,
                             PrintError => 0,
                             RaiseError => 0}) ) 
{ 
  if( index($ora_errstr, "01017",0)!=-1)
  {
    die (filterOraError("$ora_errstr\n", $ora_errno));
  }
  else
  {
      print "em_result=0|$ora_errstr\n";
  }
  exit 0;
}
  
print "em_result=1|\n";
  
exit 0; 

