#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/otrace.pl /main/9 2011/07/29 23:36:01 hpalitan Exp $
#
# otrace.pl
# 
# Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      otrace.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <collects otrace data files>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hpalitan    07/20/11 - Bug #12764760
#    hpalitan    02/17/11 - Use get_osType()
#    manosing    10/10/06 - Creation
# 

use strict ;

  require "emd_common.pl"; 
  require "db/esaDbUtils.pl";
  require "db/esaUtils.pl";
  require "find_os.pl";
  
   my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
   my $maxRows = $ENV{'OTRACE'};
   my $limit = 0 ;
   my $OSNAME = get_osType();
   
  EMD_PERL_DEBUG("otrace: OS         = $OSNAME");
  EMD_PERL_DEBUG("otrace:oracleHome  = $oracleHome");
  EMD_PERL_DEBUG("otrace: maxRows    = $maxRows");
   
  my $path = qq($oracleHome/otrace/admin);
  if($OSNAME eq "WIN"){
    $path =~s /\//\\/g;
  }

  opendir(DIRHANDLE,$path)||exit(0);
  my @content = grep /^.*\.dat$/,readdir(DIRHANDLE);

  if($maxRows == 0 ){
      exit(0);
  }
  foreach(@content){

      if($maxRows!=-1 && $limit == $maxRows)
      {
          exit(0);
      }
      print "em_result=otrace|$_|NA\n";
      $limit++;

  }
   
  
  
      
  
 
