#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/rconfig/rconfig.pl /main/4 2010/07/18 00:53:21 prapatil Exp $
#
# rconfig.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      rconfig.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vmaddali    08/05/04 - vmaddali_rconvert1
#    vmaddali    08/04/04 - Creation
# 

use FileHandle;
use IPC::Open2;
use DBI;
use vars qw/ $OS $NT $S $TEMP $CP $MV $PS $DF $DELIMITER/;

require "db/db_common.pl";


$DEBUG_CODE = 8;

sub save_agent_env()
{
  EMD_PERL_DEBUG("rconfig.save_agent_env()");
  $AGENT_ORACLE_HOME = $ENV{ORACLE_HOME};
  $AGENT_LD_LIBRARY_PATH = $ENV{LD_LIBRARY_PATH};
  $AGENT_SHLIB_PATH = $ENV{SHLIB_PATH};
  $AGENT_LIBPATH = $ENV{LIBPATH};
  $AGENT_PATH = $ENV{PATH};
  $AGENT_JAVA_HOME = $ENV{JAVA_HOME};
  $AGENT_ORA_NLS = $ENV{ORA_NLS};
  $AGENT_ORA_NLS32 = $ENV{ORA_NLS32};
  $AGENT_ORA_NLS33 = $ENV{ORA_NLS33};
}

sub set_agent_env()
{
  EMD_PERL_DEBUG("rconfig.set_agent_env()");
  $ENV{ORACLE_HOME} = $AGENT_ORACLE_HOME;
  $ENV{LD_LIBRARY_PATH} = $AGENT_LD_LIBRARY_PATH;
  $ENV{SHLIB_PATH} = $AGENT_SHLIB_PATH;
  $ENV{LIBPATH} = $AGENT_LIBPATH;
  $ENV{PATH} = $AGENT_PATH;
  $ENV{JAVA_HOME} = $AGENT_JAVA_HOME;
  $ENV{ORA_NLS} = $AGENT_ORA_NLS;
  $ENV{ORA_NLS32} = $AGENT_ORA_NLS32;
  $ENV{ORA_NLS33} = $AGENT_ORA_NLS33;

  EMD_PERL_DEBUG("rconfig.set_agent_env() ORACLE_HOME = $ENV{ORACLE_HOME}");
  EMD_PERL_DEBUG("rconfig.set_agent_env() LD_LIBRARY_PATH = $ENV{LD_LIBRARY_PATH}");
  EMD_PERL_DEBUG("rconfig.set_agent_env() SHLIB_PATH = $ENV{SHLIB_PATH}");
  EMD_PERL_DEBUG("rconfig.set_agent_env() LIBPATH = $ENV{LIBPATH}");
  EMD_PERL_DEBUG("rconfig.set_agent_env() PATH = $ENV{PATH}");
  EMD_PERL_DEBUG("rconfig.set_agent_env() JAVA_HOME = $ENV{JAVA_HOME}");
  EMD_PERL_DEBUG("rconfig.set_agent_env() ORA_NLS = $ENV{ORA_NLS}");
  EMD_PERL_DEBUG("rconfig.set_agent_env() ORA_NLS32 = $ENV{ORA_NLS32}");
  EMD_PERL_DEBUG("rconfig.set_agent_env() ORA_NLS33 = $ENV{ORA_NLS33}");
}

sub set_target_env()
{
  EMD_PERL_DEBUG("rconfig.set_target_env()");
  if ('YES' eq '%db_10_or_higher%')
  {
    set_env_var($target_home, $target_sid, "TRUE");
  }
  else
  {
    set_env_var($target_home, $target_sid, "FALSE");
  }
  # Trace the following items even though they are not handled by this subroutine.
  EMD_PERL_DEBUG("rconfig.set_target_env() JAVA_HOME = $ENV{JAVA_HOME}");
}

sub get_temp_file_name()
{
  my ($fh, $filename);

  if($NT)
  {
    my $TEMP;
    #if ($ENV{TEMP} ne "")
    #{
    #    $TEMP = $ENV{TEMP};
    #}
	#elsif ($ENV{TMP} ne "")
	#{
	#    $TEMP = $ENV{TMP};    
	#}
	#else
	#{
	    $TEMP = "\\temp";
	#}    

    &mkDir($TEMP);
	
	my $mytime = time();
	my $sid = ($target_sid ne "")? $target_sid : $ENV{ORACLE_SID};
	
    $filename = "$TEMP\\rconfig${sid}.$mytime";
  }
  else
  {
    my $dir = tempdir(CLEANUP => 1);
    ($fh, $filename) = tempfile( DIR => $dir );  
  }  
  
  $filename;
}

sub run_rconfig()
{
  EMD_PERL_DEBUG("rconfig.run_rconfig()");
  set_target_env();
  EMD_PERL_DEBUG("rconfig.run_rconfig() env NLS_LANG: $ENV{NLS_LANG}");
  
  $? = 0;
  EMD_PERL_DEBUG("rconfig.run_rconfig() XML script : {$xml_input}");
  print $xml_input;
  return(0);
}

1;

