
# $Header: emdb/sysman/admin/scripts/db/remoteBrowser/remoteBrowser.pl /main/11 2010/07/18 00:53:21 prapatil Exp $
#
# remoteBrowser.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      remoteBrowser.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sxzhu       02/04/05 - Do not get uid and gid on Windows 
#    ngade       08/19/04 - fix syntax 
#    rreilly     08/03/04 - accept % as wildcard 
#    rreilly     05/29/04 - esc special chars. 
#    rreilly     05/28/04 - Set MAX_ITEMS to 2000
#    rreilly     05/25/04 - add search support
#    rreilly     05/20/04 - rreilly_enh_rb3
#    rreilly     05/13/04 - get the dir list using ls 
#    rreilly     05/12/04 - Creation
# 
require "emd_common.pl";
require "db/db_common.pl";

use strict;
use vars qw/ $userID $S $NT /;

my $MAX_ITEMS = 2000;

# #######################################################
# getHostOS()
#
# get the OS running on the host machine string: 
# linux, solaris, MSWin32, aix, hpux
# #######################################################
sub getHostOS()
{
  return $^O;
}

# #######################################################
# directoryListing(directory,     col_delimiter,
#                  row_delimiter, item_match)
#
# Params
#   directory - the full path of the directory 
#   col_delimiter - used to seperate data in a row
#   row_delimiter - used to identify a complete row
#   item_match - a string in the form '*.txt' or 
#                '*.*' or 'MyFile.txt'.
#                '' or '*' will return all items.
#                NOTE: * or % can be used as a wildcard
#
# Description  
#   Returns the items in the directory that is passed in.
#   This will never return more than max_items.
#   If a search_criteria is specified, then only entries 
#   matching the search_criteria will be returned.
#   This function will never return more than MAX_ITEMS
#   items.
#
# Returns
#   a string with each column seperated by the 
#   col_delimiter and each directory is seperated by the
#   row_delimiter. If the col_delimiter is ':::' and 
#   row_delimiter is '###', this function will return 
#   something like:
#   name:::type:::owner:::group:::date:::###
#
#   If the string is tokenized, here's the results:
#   [0] - name
#   [1] - type ('FILE','DIR')
#   [2] - owner
#   [3] - group (UNIX only)
#   [4] - size (bytes)
#   [5] - last modified date
# #######################################################
sub directoryListing
{
  EMD_PERL_DEBUG("remoteBrowser.directoryListing(): *** START ***");

  # params
  # (my $directory, my $col_delimiter, my $row_delimiter, my $item_match) = @_;
  my($directory)     = $ARGV[0];
  my($col_delimiter) = $ARGV[1];
  my($row_delimiter) = $ARGV[2];
  my($item_match)    = $ARGV[3];

  EMD_PERL_DEBUG("remoteBrowser.directoryListing(): directory: $directory");
  EMD_PERL_DEBUG("remoteBrowser.directoryListing(): col_delim: $col_delimiter");
  EMD_PERL_DEBUG("remoteBrowser.directoryListing(): row_delim: $row_delimiter");
  EMD_PERL_DEBUG("remoteBrowser.directoryListing(): item_match: $item_match");

  # returns
  my $itemTable = "";

  # variables
  my $dir_handle;
  my $dir_delimiter = '/';
  my $dir_item_count = 0;
  my @allItems;
  my @itemInfo;

  # row/column variables
  my $name = "";
  my $full_name = "";
  my $type = "";
  my $owner = "";
  my $group = "";
  my $size = "";
  my $modDate = "";
  my $itemRow = "";

  # trim white space 
  $directory =~ s/\s*$//;
  $directory =~ s/^\s*//;  

  # if the directory delimiter is missing, add it
  if ($^O eq "MSWin32")
  {
    $dir_delimiter = '\\';
  }
  if ($directory !~ /$dir_delimiter$/)
  {
    $directory .= $dir_delimiter;
  }

  # open the directory
  if (! opendir(dir_handle, $directory) )
  {
    EMD_PERL_DEBUG("remoteBrowser.directoryListing(): can't open $directory \n");
    exit 1;
  }

  # Get Contents of the directory
  if ($item_match ne '*' && $item_match ne '%' && $item_match ne '')
  {
    # change every * or % to .* and protect against metadata symbols
    $item_match = quotemeta($item_match);
    $item_match =~ s/\\\*/\.*/g;
    $item_match =~ s/\\\%/\.*/g;

    # only return matching files
    EMD_PERL_DEBUG("remoteBrowser.directoryListing(): adjusted item_match: $item_match");
    @allItems = grep(/^$item_match$/, readdir(dir_handle));
  }
  else
  {
    @allItems = readdir(dir_handle);
  }

  # Add each item with col/row delimiters
  for $name (@allItems)
  {
     # Get all the info associated with this item
     $full_name = $directory.$name;
     @itemInfo = stat($full_name);

     # NAME: retrieved from @allItems

     # TYPE: use stat to get item type
     if (-d $full_name)
     {
       $type = 'DIR';
     }
     else
     {
       $type = 'FILE';
     }

     # OWNER
     if(!$NT)
     {
       $owner = getpwuid($itemInfo[4]);
     }

     # GROUP
     if(!$NT)
     {
       $group = getgrgid($itemInfo[5]);
     }

     # SIZE
     $size = $itemInfo[7];

     # LAST MODIFIED DATE
     $modDate = localtime($itemInfo[9]);

     $itemRow = join($col_delimiter,($name,  $type, 
                                     $owner, $group, 
                                     $size,  $modDate)); 
     $itemTable .= $itemRow.$col_delimiter.$row_delimiter;
     # EMD_PERL_DEBUG("remoteBrowser.directoryListing(): $itemRow$col_delimiter$row_delimiter");


     # Exit when we hit the max number of items
     $dir_item_count++;
     last if $dir_item_count >= $MAX_ITEMS;
  }

  closedir(dir_handle);

  EMD_PERL_DEBUG("remoteBrowser.directoryListing(): $itemTable");
  EMD_PERL_DEBUG("remoteBrowser.directoryListing(): Item Count: $dir_item_count");
  EMD_PERL_DEBUG("remoteBrowser.directoryListing(): *** END ***");

  return $itemTable;
}

# 1;

#Tests:
sub rbmain
{
   # $ENV{EMAGENT_PERL_TRACE_LEVEL} = 0; 
   # my $test = directoryListing ("/home/rreilly/temp/rfb",":::","###","* *");
}

# rbmain();
