# $Header: emdb/sysman/admin/scripts/db/reorg/reorganize.pl /st_emgc_pt-12.1.0.4pg/1 2012/09/04 09:35:30 pkaliren Exp $
#
# reorganize.pl
# 
# Copyright (c) 2002, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      reorganize.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pkaliren    08/13/12 - Spatial Index error in the last page without
#                           failing the masking job
#    vgoli       03/24/11 - reorg: role usage in CONNECT
#    vgoli       02/25/11 - bug 8869554: run masking script from its current
#                           directory
#    vgoli       02/22/11 - XbranchMerge vgoli_bug-11727882 from
#                           st_emgc_12gcbeta2
#    pkaliren    02/15/11 - Adding report_dir and setting it to null
#    vgoli       10/15/10 - role usage in CONNECT string
#    pkaliren    12/07/10 - Changing the bufferlength
#    pkaliren    08/06/10 - sts owner for spa trial
#    rasundar    05/20/10 - pass dir_obj parameter for masking script execution
#    rasundar    12/29/09 - Fix for bug 9232990, comment out call to
#                           removeFile()
#    shmahaja    12/03/09 - Fix : spool file getting deleted after dm job
#    kmckeen     04/02/09 - Implement seed field for Substitute format
#    rasundar    03/18/09 - remove hardcoded password in test code
#    vgoli       11/21/08 - fix bug 7569063: extra check for ORA errors
#    mahessub    05/20/08 - Merge 11GC CM Functionality
#    rpattabh    01/03/08 - Project 25671: Masking integration with Clone
#    xshen       08/07/07 - bug 6326606
#    pkaliren    06/26/07 - Adding runSynchScriptFile
#    szhu        10/10/03 - Turn off tracing 
#    szhu        11/08/02 - Handle spool file
#    szhu        10/06/02 - szhu_reorg_job
#    szhu        10/06/02 - filter DB credentials
#    szhu        10/04/02 - Creation
# 

require "emd_common.pl";
require "db/db_common.pl";

use strict;
use File::Basename;
use vars qw/ $userID $role $dbLinkUser $dbLinkPwd /;

# Global variables
$userID = "";
$role = "";
$dbLinkUser = "";
$dbLinkPwd = "";

#A temporary solution and will be removed after EMD supports this setting
#in logging.xml.
#$ENV{EMAGENT_PERL_TRACE_LEVEL} = 0;  #DEBUG level.

# Set the source DB credential
# setSrcDBCredential(userName, password)
sub setSrcDBCredential
{
  EMD_PERL_DEBUG("reorganize.setSrcDBCredential(): *** START ***");
  my ($userName, $password, $my_role, $tns) = @_;
	if(!$tns){
			$userID = $userName."/".$password;
	}
	else{
			$userID = $userName."/".$password."\@${tns}";
	}

  EMD_PERL_DEBUG("reorganize.setSrcDBCredential(): User Name: $userName");

  if($my_role)
  {
    $role = $my_role;
    EMD_PERL_DEBUG("reorganize.setSrcDBCredential(): role: $role");
  }
  
  EMD_PERL_DEBUG("reorganize.setSrcDBCredential(): *** END ***");
}


# Set the dblink user and pwd
# setDBLinkCredential(userName, password)
sub setDBLinkCredential
{
  EMD_PERL_DEBUG("reorganize.setDBLinkCredential(): *** START ***");
  my ($userName, $password) = @_;
  $dbLinkUser = $userName;
  $dbLinkPwd = $password;
  EMD_PERL_DEBUG("reorganize.setDBLinkCredential(): User Name: $userName");
  EMD_PERL_DEBUG("reorganize.setDBLinkCredential(): *** END ***");
}

# Filter out DB credential from sql script, which is written to emd_perl.trc
# filterDBCredential(sqlScript)
sub filterDBCredential
{
  my ($sqlScript) = @_;

  my $position1 = index($sqlScript, "CONNECT");
  my $position2 = index($sqlScript, "AS");
  if($position2 == -1)
  {
     $position2 = index($sqlScript, "\@");
  }
  my $replacedLength = $position2 - $position1 - 9;
  substr($sqlScript, $position1 + 8, $replacedLength) = "username/password(Hiden intentionally)";

  return $sqlScript;
}

# Parse the output string to detect ORA- errors
# parseOutput(output)
sub parseOutput
{
  EMD_PERL_DEBUG("reorganize.parseOutput(): *** START ***");

  my ($output) = @_;
  
  if ($output eq "")
  {
    EMD_PERL_ERROR("reorganize.parseOutput(): Output file is empty!");
  }

  # reorg backend error
  if ($output =~ /errorExitOraError!/)
  {
    EMD_PERL_ERROR("reorganize.parseOutput(): errorExitOraError! See output log.");
    exit(1);
  }
  
  elsif ($output =~ /errorExit!/)
  {
    EMD_PERL_ERROR("reorganize.parseOutput(): errorExit! See output log.");
    exit(1);
  }

  # sqlplus errors
  elsif ($output =~ /SP2-[0-9]+/)
  {
    EMD_PERL_DEBUG("reorganize.parseOutput(): SP2- ERROR! Exit! See output log.");
    exit(1);
  }

  # ORA errors
  elsif ($output =~ /ORA-[0-9]+/)
  {
    EMD_PERL_DEBUG("reorganize.parseOutput(): ORA- ERROR! Exit! See output log.");
    exit(1);
  }

  # successful
  else
  {
    EMD_PERL_DEBUG("reorganize.parseOutput(): No Error found.");        
  }  
  
  EMD_PERL_DEBUG("reorganize.parseOutput(): *** END ***");
}

# Parse the output string to detect ORA- errors.We need the errors to get appended at the end 
# parseMaskingOutput(output)
sub parseMaskingOutput
{
  EMD_PERL_DEBUG("reorganize.parseOutput(): *** START ***");

  my (@record) = @_;

  foreach my $output (@record) {

  # reorg backend error
  if ($output =~ /errorExitOraError!/)
  {
    EMD_PERL_ERROR("reorganize.parseOutput(): errorExitOraError! See output log.");
    print "Error found : $output";
    exit(1);
  }
  
  elsif ($output =~ /errorExit!/)
  {
    EMD_PERL_ERROR("reorganize.parseOutput(): errorExit! See output log.");
    print "Error found : $output";
    exit(1);
  }

  # sqlplus errors
  elsif ($output =~ /SP2-[0-9]+/)
  {
    EMD_PERL_DEBUG("reorganize.parseOutput(): SP2- ERROR! Exit! See output log.");
    print "Error found : $output";
    exit(1);
  }

  # ORA errors
  elsif ($output =~ /ORA-[0-9]+/)
  {
    EMD_PERL_DEBUG("reorganize.parseOutput(): ORA- ERROR! Exit! See output log.");
    print "Error found : $output";
    # print all ORA errors. But dont fail the job for Doamin index error and warnings
    if ($output !~ /ORA-29855+/ && $output !~ /ORA-29874+/)
    {
     print "Masking job Failed";
     exit(1);
    } 
  }

  # successful
  else
  {
    EMD_PERL_DEBUG("reorganize.parseOutput(): No Error found."); 
  }  

  EMD_PERL_DEBUG("reorganize.parseOutput(): *** END ***");
 
 }

 

}

# Run given sql script on target DB
# runSqlScript(sqlScript)
sub runSqlScript
{
  EMD_PERL_DEBUG("reorganize.runSqlScript(): *** START ***");
  
  my ($sqlScript) = @_[0];
  
  my $sqlScript_debug = &filterDBCredential($sqlScript);
  EMD_PERL_DEBUG("reorganize.runSqlScript(): SQL:\n$sqlScript_debug");

  open(SQL_SCRIPT, "|$ENV{ORACLE_HOME}/bin/sqlplus /nolog")
    || die "Cannot open pipe for SQL_SCRIPT";
  print SQL_SCRIPT $sqlScript;
  close SQL_SCRIPT || die "Bad SQL_SCRIPT";
  
  EMD_PERL_DEBUG("reorganize.runSqlScript(): *** END ***");
}

# Run reorganize sql script file
# Call &set_env(oracleHome, oracleSid) before calling this method.
# runReOrgScriptFile(oracle_home, oracle_sid, sqlScriptFileName, spoolFileName)
sub runReOrgScriptFile
{
  EMD_PERL_DEBUG("reorganize.runReOrgScriptFile(): *** START ***");

  &set_env_var(@_[0], @_[1]);

  my ($sqlScriptFileName) = @_[2];
  my ($spoolFileName) = @_[3];
  
  EMD_PERL_DEBUG("reorganize.runReOrgScriptFile(): sql script file: $sqlScriptFileName");
  EMD_PERL_DEBUG("reorganize.runReOrgScriptFile(): spool file: $spoolFileName");
  
  my $sql_string = "";
  # no need to specify role when it is NORMAL
  if($role eq "" || ($role =~ /NORMAL/i))
  {
    $sql_string .= "CONNECT $userID;\n";
  }
  else
  {
    $sql_string .= "CONNECT $userID AS $role;\n";
  }
  $sql_string .= "\@$sqlScriptFileName;\n";
  $sql_string .= "EXIT;\n";

  &runSqlScript($sql_string);

  #Open the spool file to parse execution error
  #A temp solution
  #my $lastDatIndex = rindex($sqlScriptFileName, ".");
  #my $spoolFileName = substr($sqlScriptFileName, 0, $lastDatIndex + 1);
  #$spoolFileName .= "log";
  #EMD_PERL_DEBUG("reorganize.runReOrgScriptFile(): spool file:\n$spoolFileName");
  
  open (OUT_PUT, "$spoolFileName") || die "Unable to open spool file for OUT_PUT\n";
  my @output_content = <OUT_PUT>;
  my $output_string = "@output_content";
  close OUT_PUT;
  
  EMD_PERL_DEBUG("reorganize.runReOrgScriptFile(): OUT_PUT:\n$output_string");

  &removeFile($spoolFileName);
  
  &parseOutput($output_string);
  
  EMD_PERL_DEBUG("reorganize.runReOrgScriptFile(): *** END ***");
}
1;

# Run data masking sql script file
# Call &set_env(oracleHome, oracleSid) before calling this method.
# runDataMaskingScriptFile(oracle_home, oracle_sid, sqlScriptFileName, spoolFileName, seed, dir_obj)
sub runDataMaskingScriptFile
{
  EMD_PERL_DEBUG("reorganize.runDataMaskingScriptFile(): *** START ***");

  &set_env_var(@_[0], @_[1]);

  my ($sqlScriptFileName) = @_[2];
  my ($spoolFileName) = @_[3];
  my ($seed) = @_[4];
  my ($dir_obj) = @_[5];
  my ($sts_mask) = @_[6];
  my ($spa_trial) = @_[7];
  my ($task_name) = @_[8];
  my ($sts_name) = @_[9];
  my ($script_file, $script_dir) = fileparse($sqlScriptFileName);

  EMD_PERL_DEBUG("reorganize.runDataMaskingScriptFile(): sql script file: $sqlScriptFileName");
  EMD_PERL_DEBUG("reorganize.runDataMaskingScriptFile(): spool file: $spoolFileName");

  my $sql_string = "";

  # no need to specify role when it is NORMAL
  if($role eq "" || ($role =~ /NORMAL/i))
  {
    $sql_string .= "CONNECT $userID;\n";
  }
  else
  {
    $sql_string .= "CONNECT $userID AS $role;\n";
  }
  if($seed ne "")
  {
    $sql_string .= "var seed number;\n";
    $sql_string .= "exec :seed := $seed;\n";
  }

  $sql_string .= "var dir_obj varchar2(30);\n";
  $sql_string .= "exec :dir_obj := '$dir_obj';\n";
  $sql_string .= "var sts_mask varchar2(3);\n";
  $sql_string .= "exec :sts_mask := '$sts_mask';\n";
  $sql_string .= "var spa_trial varchar2(3);\n";
  $sql_string .= "exec :spa_trial := '$spa_trial';\n";
  $sql_string .= "var task_name varchar2(30);\n";
  $sql_string .= "exec :task_name := '$task_name';\n";
  $sql_string .= "var sts_name varchar2(70);\n";
  $sql_string .= "exec :sts_name := '$sts_name';\n";
  #STS owner will be null but it will be parsed from sts_name in the script
  $sql_string .= "var sts_owner varchar2(30);\n";
  $sql_string .= "exec :sts_owner := null;\n";
  #SPA Report directory is not needed for UI.But we need this declaration
  $sql_string .= "var report_dir varchar2(30);\n";
  $sql_string .= "exec :report_dir := null;\n";
  $sql_string .= "\@$script_file;\n";
  $sql_string .= "EXIT;\n";

  EMD_PERL_DEBUG("reorganize.runDataMaskingScriptFile(): sql_string: $sql_string");

  #
  # bug 8869554: change to script directory and run the script from there.
  # The generated script should have a spool filename without any directories.
  #
  chdir($script_dir);
  &runSqlScript($sql_string);

  #Open the spool file to parse execution error
  open (OUT_PUT, "$spoolFileName") || die "Unable to open spool file for OUT_PUT\n";
  my @output_content = <OUT_PUT>;
  my $output_string = "@output_content";
  close OUT_PUT;

  EMD_PERL_DEBUG("reorganize.runDataMaskingScriptFile(): OUT_PUT:\n$output_string");

  &parseMaskingOutput(@output_content);
  
  EMD_PERL_DEBUG("reorganize.runDataMaskingScriptFile(): *** END ***");
}
1;

# Run synchronize sql script file
# Call &set_env(oracleHome, oracleSid) before calling this method.
# runSynchScriptFile(oracle_home, oracle_sid, sqlScriptFileName, spoolFileName)
sub runSynchScriptFile
{
  EMD_PERL_DEBUG("reorganize.runSynchScriptFile(): *** START ***");

  &set_env_var(@_[0], @_[1]);

  my ($sqlScriptFileName) = @_[2];
  my ($spoolFileName) = @_[3];


  EMD_PERL_DEBUG("reorganize.runSynchScriptFile(): sql script file: $sqlScriptFileName");
  EMD_PERL_DEBUG("reorganize.runSynchScriptFile(): spool file: $spoolFileName");

  my $sql_string = "";

  if($role eq "")
  {
    $sql_string .= "CONNECT $userID;\n";
  }
  else
  {
    $sql_string .= "CONNECT $userID AS $role;\n";
  }
  if($dbLinkUser eq "")
  {
    $sql_string .= "\@$sqlScriptFileName;\n";
  }
  else
  {
    $sql_string .= "\@$sqlScriptFileName $dbLinkUser $dbLinkPwd ;\n";
  }
  $sql_string .= "EXIT;\n";
  &runSqlScript($sql_string);

  #Open the spool file to parse execution error
  #A temp solution
  #my $lastDatIndex = rindex($sqlScriptFileName, ".");
  #my $spoolFileName = substr($sqlScriptFileName, 0, $lastDatIndex + 1);
  #$spoolFileName .= "log";
  #EMD_PERL_DEBUG("reorganize.runSynchScriptFile(): spool file:\n$spoolFileName");

  open (OUT_PUT, "$spoolFileName") || die "Unable to open spool file for OUT_PUT\n";
  my @output_content = <OUT_PUT>;
  my $output_string = "@output_content";
  close OUT_PUT;

  EMD_PERL_DEBUG("reorganize.runSynchScriptFile(): OUT_PUT:\n$output_string");

  &removeFile($spoolFileName);

  &parseOutput($output_string);

  EMD_PERL_DEBUG("reorganize.runSynchScriptFile(): *** END ***");
}
1;

#Tests:
sub main_reorg
{
  $ENV{EMAGENT_PERL_TRACE_LEVEL} = 0;
  my $oracle_home = "/private1/oracle_kits/v901";
  my $oracle_sid = "v901";
  my $sqlScriptFileName = "/private2/backup/test.sql";
  my $spoolFileName = "/private2/backup/test.log";
  #### fill in db password as the second parameter below for testing purposes
  setSrcDBCredential("system", "", "0", "0");
  ### fill in sys password as the second parameter below for testing as sys user
  #setSrcDBCredential("sys", "", "sysdba", "0");
  runReOrgScriptFile($oracle_home, $oracle_sid, $sqlScriptFileName, $spoolFileName);
}

#main_reorg();
