#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/scnInfoCollector.pl /st_emgc_pt-12.1.0.4pg/1 2012/12/07 15:29:17 davili Exp $
#
# scnInfoCollector.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      scnInfoCollector.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    davili      11/28/12 - Creation
use strict;
use encoding 'utf8';

require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";

my ($configFile) = @ARGV;

my $metric = $ENV{Metric};
my $columnCount = $ENV{MetricColumnCount};
my $sid = $ENV{SID};

handleConfigMetricResult($configFile,$metric,$columnCount,$sid, \&getScnInfo);

sub getScnInfo
{
  my ($result) = @_;
  my $headRoom = 0;
  my $HEADROOM = 1;   # zero-based index
  my $THRESHOLD = 62; # 62 days headroom (see note 1393363.1)

  if ($result =~ /em_result=(.*)/)
  {
    my @columnData = split(/\|/, $1);
    $headRoom = int($columnData[$HEADROOM]);
    if ($headRoom < $THRESHOLD)
    {
      printResult($result);
    }
    EMD_PERL_DEBUG("SCN Info:\n $result");
  }
}
