#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/sessionDetails.pl /main/5 2011/06/29 00:45:50 pbhogara Exp $
#
# sessionDetails.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      sessionDetails.pl
#
#    DESCRIPTION
#      This script queries x$ksuse in prelim mode through direct_access
#      API to get the session details of required sessions.
#
#    NOTES
#
#
#    MODIFIED   (MM/DD/YY)
#    pbhogara    06/04/10 - Creation
# 

use strict;

require "emd_common.pl";
require "db/db_common.pl";

require "db/direct_access.pl";

package SessionDetails;


our $ERROR_CODE;

# Projection list used for querying x$ksuse
my @QUERY_KSUSE    = ("INDX",
                      "KSUSESER",
                      "INST_ID",
                      "KSUUDLNA",
                      "KSUUDLUI",
                      "KSUSEPNM",
                      "KSUSEAPP",
                      "KSUSEACT",
                      "KSUSESVC",
                      "KSUSESQI",
                      "KSUSEPID",);
# TODO: Add the field to identify the session status --
# decode(bitand(s.ksuseidl,11),1,'ACTIVE',0,"
#"decode(bitand(s.ksuseflg,4096),0,'INACTIVE','CACHED'),2,'SNIPED',3,'SNIPED', \
# 'KILLED')," /* status (char) */

my @OUTPUT_COLS    = ("ID", 
                      "USER_NAME",
                      "USER_ID",
                      "PROGRAM",
                      "MODULE",
                      "ACTION",
                      "SERVICE",
                      "SQL_ID",
                      "SPID");

my $target_version;
my $xml_result = "";

sub setContext
{
  my $oracle_home    = shift;
  my $oracle_sid     = shift;
  my $connect_string = shift;
  $target_version = shift;
  my $use_prelim     = shift;

  DirectAccess::setConnectionContext($oracle_home,
                                     $oracle_sid,
                                     $connect_string,
                                     $target_version,
                                     $use_prelim,
                                    );
}


sub get_session_details
{
  # list of sessions - SID_SERIAL#_INSTID
  my @sessions_arr = @_;
   
  $xml_result = "<session_details>";

  # check if the target version >= 11.2.0.2
  if(::compareVer($target_version,"11.2.0.2.0")>=0)
  {

    # Get the required columns from x$ksuse and add them to the session information
    # obtained from x$ksdhng_chains.
    for my $unique_id(@sessions_arr)
    {
      my @arr = split(/_/,$unique_id);

      my @result = get_session_details_ksuse($arr[0]);

      # There may be more than one session with the same sid.
      # Filter further based on serial number. 
      for my $sess_ref(@result)
      {
        if($sess_ref->{'KSUSESER'} eq $arr[1])
        {
          $xml_result .= "<session id='$unique_id' ";
          for(my $it1=3,my $it2=1;
              $it1 <= $#QUERY_KSUSE && $it2 <= $#OUTPUT_COLS;
              $it1++,$it2++)
          {
            $xml_result .= lc($OUTPUT_COLS[$it2]).
                             "='$sess_ref->{$QUERY_KSUSE[$it1]}' ";
          }
          $xml_result .= "/>";
        }
      }
    }
  }
  else
  {
    ::EMAGENT_PERL_ERROR(" Querying X\$KSUSE for database versions ".
                       "<11.2.0.2 is not allowed");
  }
 
  $xml_result .= "</session_details>";

  ::EMAGENT_PERL_DEBUG("Session details: $xml_result");
}

sub print_XML
{
  return $xml_result;
}


#
# Subroutine: get_session_details_ksuse
#
# $_[0] => serialno of the session
#  
# Get the session details for a given session from x$ksuse 
#
sub get_session_details_ksuse
{
  my $sid = shift;
  DirectAccess::setQueryContext($DirectAccess::UNSAFE_MODE,
                                $DirectAccess::DISABLE_TRACE,
                                $DirectAccess::OUTPUT_XML);
  my $pred= 'INDX=='.$sid;

  # Session attributes like program, action, module, service are obtained 
  # from x$ksuse.
  my @ksuse_sessions = DirectAccess::getFixedTable('X$KSUSE',
                                                   \@QUERY_KSUSE,
                                                   undef,
                                                   undef,
                                                   $pred);
  if ($DirectAccess::ERROR_CODE)
  {
    ::EMAGENT_PERL_ERROR("received error code $DirectAccess::ERROR_CODE while querying for x\$ksuse");
    $ERROR_CODE = $DirectAccess::ERROR_CODE;
    return;
  }

  return @ksuse_sessions;
}

1;
