#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/sqlnetParams.pl /st_emgc_pt-12.1.0.4pg/3 2012/11/21 05:36:30 rkpandey Exp $
# $Header: emdb/sysman/admin/scripts/db/sqlnetParams.pl /st_emgc_pt-12.1.0.4pg/3 2012/11/21 05:36:30 rkpandey Exp $
# sqlnetParams.pl
# 
# Copyright (c) 2004, 2012, Oracle and/or its affiliates. All rights reserved. 
# Copyright (c) 2004, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#     NAME
#       sqlnetParams.pl - <one-line expansion of the name>
#
#     DESCRIPTION
#       <short description of component this file declares/defines>
#
#     NOTES
#       <other useful comments, qualifications, etc.>
#
#     MODIFIED    (MM/DD/YY)
#     hpalitan  11/20/12  - Change sqlnet_encryption_types_server to
#                           encryption_types_server
#     hpalitan  12/23/11  - Pass default value for allowed logon version
#     hpalitan  09/12/11  - Pass string NULL when sqlnet.ora location is not
#                           found
#     hpalitan  09/12/11  - Collect all params for listener
#     hpalitan  03/29/11  - fix path of emdbAgent.jar
#     hpalitan  02/17/11  - User get_osType()
#     hpalitan  11/10/10  - Enable for DB Target
#     mperugu   04/23/10  - add more functionality for additional rules of 11ng
#     manosing  04/11/07  - bug 5975763
#	 manosing  07/22/08 - 
#	 dsukhwal  06/30/05 - support flood control for all policies 
#     ssalunke  12/11/06 - Adding support for other unix operating systems
#     manosing  02/24/07  - adding check for 0( )
#     manosing  12/28/06  - flood control for windows policy
#     manosing  10/09/06 -  add sqlnet.inbound_connect_timeout ssl_server_dn_match 
#     dsukhwal  06/30/05 - support flood control for all policies 
#     dsukhwal  06/06/05 - handle win32 cases 
#     dsukhwal  05/17/05 - moving to listener metadata 
#     dsukhwal  04/20/05 - use target TNS_ADMIN 
#     dsukhwal     02/15/05 - bug 4171687 : remove chdir 
#     dsukhwal     02/04/05 - change property values 
#     dsukhwal     02/03/05 - add sqlnet.allowed_logon_version 
#     dsukhwal     01/03/05 - support split policies 
#     dsukhwal     01/12/05 - permissions in octal 
#     dsukhwal     12/14/04 - Display permissions in rwx format(bug 4057002) 
#     dkjain         10/13/04 - More functionality added 
#     dkjain         10/08/04 - dkjain_esa_impl_init
#     dkjain         10/08/04 - Creation
# 
  use strict;  
  use vars qw($NT $S); #both come from db_common.pl
  require "db/esaUtils.pl";
  require "db/db_common.pl";
  require "find_os.pl";
  require "dbUtil.pl"; 

  my $db_version;
  my $db_sql;
  my $lda;	
  my @fetch_row;
  my $db_cur;

  
  my $targetType = trim ( $ARGV[$0] );
  my $TGT_ORACLE_HOME = "";
  my $SqlnetLocation = "";
  my $OSNAME = get_osType();

  my %stdinArgs = get_stdinvars();
  my $username = $stdinArgs{"EM_TARGET_USERNAME"};
  my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
  my $address = $ENV{EM_TARGET_ADDRESS};
  my $role = $ENV{EM_TARGET_ROLE};
  
  EMD_PERL_DEBUG("sqlnetParams: OS          = $OSNAME");
  
  if ( $targetType eq "DB" )
  {
    $TGT_ORACLE_HOME = $ENV{EM_TARGET_ORACLE_HOME};
    $SqlnetLocation = getSqlnetLocation($TGT_ORACLE_HOME);

    my $mode = 0;
    if($role =~ /SYSDBA/i)
    {
      $mode = 2;
    }
    elsif($role =~ /SYSOPER/i)
    {
      $mode = 4;
    }

    $lda = &get_tgt_db_connection("dbi:Oracle:","$username@".$address,$password,$mode);
    $db_sql = "SELECT version ".
                   "FROM v\$instance ";


    $db_cur = $lda->prepare($db_sql)
        or die (filterOraError("em_error=prepare($db_sql): $DBI::errstr\n", $DBI::err));
    $db_cur->execute()
        or die (filterOraError("em_error=db_cur->execute(): $DBI::errstr\n", $DBI::err));

    @fetch_row = $db_cur->fetchrow_array();
    $db_version = $fetch_row[0];
    EMD_PERL_DEBUG ("Database Version: $db_version");
    $lda->disconnect
              or warn "disconnect $DBI::errstr\n";

  }
  else
  {
    $TGT_ORACLE_HOME = $ENV{'LSNR_ORACLE_HOME'};
    $SqlnetLocation = $ENV{'LSNR_ORA_DIR'};
  }

  if( !defined($SqlnetLocation) || $SqlnetLocation eq "" )
  {
      $SqlnetLocation = "NULL";
  }
 
  my $OHuid = file_owner($TGT_ORACLE_HOME); #The owner of the target listener home

  my $jdkHome = "$ENV{JAVA_HOME}";  
  my $fp = $SqlnetLocation.$S."sqlnet.ora";
  my $allowedLoginFlag = 0; #0 if not defined in sqlnet.ora file, 1 if defined
  my $sslServerDnMatchFlag = 0; #0 if not defined in sqlnet.ora file, 1 if defined
  my $expireTime = 0; #0 if not defined in sqlnet.ora file, 1 if defined
  my $validNode = 0;
  my $encryptionServerFlag =0;
  my $encryptionTypesServer=0;
  my $cryptoChecksumServer =0;
  my $cryptoChecksumTypeServer =0;
  my $sslCipherSuites =0;
  my $sslClientAuthentication=0;
  my $sslVersion=0;
  my $sqlNetAuthServices=0;
  my $secUnauthorizedAccessBannerFlag=0;
  my $secAuditActionBannerFlag=0;
  my $sslCertRevocationFlag=0;

  my %validNodeParams;

  my $rowNum;

    EMD_PERL_DEBUG("sqlParams: Target Type - $targetType");
    EMD_PERL_DEBUG("sqlParams: Target Oracle Home - $TGT_ORACLE_HOME");
    EMD_PERL_DEBUG("sqlParams: Sqlnet File Location - $SqlnetLocation");


#        print "em_result=target_oh|$TGT_ORACLE_HOME|NA\n";
        print "em_result=sqlnet_location|$SqlnetLocation|NA\n";
 
  sqlnet_ora_perms();
  parse_sqlnet_ora();
  
sub parse_sqlnet_ora
{#information about trace_directory_server trace_directory_client log_directory_server log_directory_client
  my $pathSep;
  if($NT){
    $pathSep = "\";\"";
  }
  else{
    $pathSep = "\":\"";
  }

  my $emdbAgent = $ENV{'PLUGIN_ROOT'} . $S . "archives" . $S . "emdbAgent.jar";
  my $netcfg    = $TGT_ORACLE_HOME . $S . "jlib" . $S . "netcfg.jar";
  my $java      = $jdkHome . $S . "bin" . $S . "java" ;

  unless ( -e $emdbAgent )
  {
     print "em_error=emdbAgent.jar not found at $emdbAgent\n"; 
  }

  unless ( -e $netcfg )
  {
     print "em_error=netcfg.jar not found at $netcfg\n"; 
  }

  unless ( -e $java )
  {
     print "em_error=java not found at $java\n"; 
  }

  my $classPath = $emdbAgent . $pathSep . $netcfg;

#        print "em_result=class_path|$classPath|NA\n";
#        print "em_result=PLUGIN_ROOT|$ENV{'PLUGIN_ROOT'}|NA\n";

  my $params = "";

#  if ( $targetType eq "DB" )
  {
  $params = "trace_directory_server trace_directory_client log_directory_server log_directory_client ".
            "sqlnet.allowed_logon_version sqlnet.inbound_connect_timeout ssl_server_dn_match sqlnet.expire_time  tcp.validnode_checking ".
            "tcp.invited_nodes tcp.excluded_nodes ".
            "sqlnet.encryption_server sqlnet.encryption_types_server sqlnet.crypto_checksum_server sqlnet.crypto_checksum_type_server ".
            "ssl_cipher_suites ssl_client_authentication ssl_version sqlnet.authentication_services sec_user_unauthorized_access_banner ".
            "sec_user_audit_action_banner ssl_cert_revocation ";
  }
#  else
#  {
#  $params = "tcp.validnode_checking ".
#            "tcp.invited_nodes tcp.excluded_nodes ";
#  }
  
#        print "em_result=params|$params|NA\n";

my $systemCommand = 
      $java . " -cp $classPath ".
      "oracle.sysman.db.esa.SqlNetParams $SqlnetLocation".$S."sqlnet.ora $params|";
#        print "em_result=systemCommand|$systemCommand|NA\n";
 
    EMD_PERL_DEBUG("sqlParams.parse_sqlnet_ora():Executing system command: \n  $systemCommand");

    $! = 0;
    if (!open(CHECKER, "$systemCommand"))
    {
        exit(0);
    }
    my @allLines;
    while (my $line = <CHECKER>)
    {
        if($line){
        $line =~ s/^\s+//;
        $line =~ s/\s+$//;
        push(@allLines,$line);
        }
    }
    my @allUniqLines = uniq_array(@allLines);
    foreach  (@allUniqLines) {
        my @values = split('=', $_);
        EMD_PERL_DEBUG("sqlParams.parse_sqlnet_ora(): $values[0]: $values[1]");
#        print "em_result=$values[0]|$values[1]|NA\n";
        if ($values[0] eq "log_directory_client")
        {
            sqlnet_client_log_directory($values[1]);
        }
        elsif ($values[0] eq "log_directory_server")
        {
            sqlnet_server_log_directory($values[1]);
        }
        elsif ($values[0] eq "trace_directory_client")
        {
            sqlnet_client_trace_directory($values[1]);
        }
        elsif ($values[0] eq "trace_directory_server")
        {
            sqlnet_server_trace_directory($values[1]);
        }
        elsif ($values[0] eq "sqlnet.allowed_logon_version")
        {
            $allowedLoginFlag = 1;
            sqlnet_allowed_logon_version($values[1]);
        }     
        elsif ( $values[0] eq "sqlnet.inbound_connect_timeout")    
        {
            sqlnet_ora_inbound_connect_timeout($values[1]);
        }        
        elsif ( $values[0] eq "ssl_server_dn_match")    
        {
            $sslServerDnMatchFlag = 1;
            ssl_server_dn_match($values[1]);
        }
         elsif ($values[0] eq "sqlnet.expire_time")
       {
           sqlnet_expire_time($values[1]);
           $expireTime=1;
       }     
       elsif ($values[0] eq "tcp.validnode_checking")
       {
           $validNodeParams{"tcp.validnode_checking"}=$values[1];
       }
       elsif($values[0] eq "tcp.invited_nodes")
       {
          $validNodeParams{"tcp.invited_nodes"}=$values[1];
       }
       elsif($values[0] eq "tcp.excluded_nodes")
       {
          $validNodeParams{"tcp.excluded_nodes"}=$values[1];
       }
       elsif(lc($values[0]) eq "sqlnet.encryption_server")
       {
	   $encryptionServerFlag=1;
	   sqlnet_encryption_server($values[1]);
       }
       elsif(lc($values[0]) eq "sqlnet.encryption_types_server")
       {
           $encryptionTypesServer=1;
	   sqlnet_encryption_types_server($values[1]);
       }
       elsif(lc($values[0]) eq "sqlnet.crypto_checksum_server")
       {
	   $cryptoChecksumServer=1;
	   sqlnet_crypto_checksum_server($values[1]);
       }
       elsif(lc($values[0]) eq "sqlnet.crypto_checksum_type_server")
       {
           $cryptoChecksumTypeServer=1;
	   sqlnet_crypto_checksum_type_server($values[1]);
       }
       elsif(lc($values[0]) eq "ssl_cipher_suites")
       {
	   $sslCipherSuites=1;
	   ssl_cipher_suites($values[1]);
       }
       elsif(lc($values[0]) eq "ssl_client_authentication")
       {
	   $sslClientAuthentication=1;
	   ssl_client_authentication($values[1]);
       }
       elsif(lc($values[0]) eq "ssl_version")
       {
           $sslVersion=1;
	   ssl_version($values[1]);
       }
       elsif(lc($values[0]) eq "sqlnet.authentication_services")
       {
	   $sqlNetAuthServices=1;
	   sqlnet_authentication_services($values[1]);
       }
       elsif(lc($values[0]) eq "sec_user_unauthorized_access_banner")
       {
           $secUnauthorizedAccessBannerFlag=1;
           sec_user_unauthorized_access_banner_check($values[1]);
       }                      
       elsif(lc($values[0]) eq "sec_user_audit_action_banner")
       {
          $secAuditActionBannerFlag=1;
          sec_user_audit_action_banner_check($values[1]);
       }    
       elsif(lc($values[0]) eq "ssl_cert_revocation")
       {
          $sslCertRevocationFlag=1; 
          ssl_cert_revocation_check($values[1]);
       } 
    }
    #parameter is a reference to hash.
    valid_node(\%validNodeParams);

#    if ( $targetType eq "DB" )
    {

    if ($allowedLoginFlag == 0)
    {
        sqlnet_allowed_logon_version("8");
    }        
    if ($sslServerDnMatchFlag == 0)
    {
        ssl_server_dn_match("DEFAULT");
    }
    if($expireTime==0)
    {
        sqlnet_expire_time(0);
    }
	if($encryptionServerFlag==0)
	{
		#default value
		sqlnet_encryption_server("accepted","DEFAULT");
	}
	if($cryptoChecksumServer==0)
	{
		#default value
		sqlnet_crypto_checksum_server("accepted","DEFAULT");
	}
	if($cryptoChecksumTypeServer==0)
	{
		sqlnet_crypto_checksum_type_server("md5","DEFAULT");
	}
	if($sslCipherSuites ==0)
	{
		ssl_cipher_suites("none","DEFAULT");
	}
	if($sslClientAuthentication == 0)
	{
		ssl_client_authentication("true","DEFAULT");
	}
	if($sslVersion==0)
	{
		ssl_version("0","DEFAULT");
	}
	if($encryptionTypesServer==0)
	{
		#if not specified, all installed algorithms are used 
		sqlnet_encryption_types_server("(RC4_256,AES256,AES192,3DES168,RC4_128,AES128,3DES112,RC4_56,DES,RC4_40,DES40)","DEFAULT");
	}
	if($sqlNetAuthServices==0)
	{
		sqlnet_authentication_services("none","DEFAULT");
	}
        if($secUnauthorizedAccessBannerFlag==0)
        {
           sec_user_unauthorized_access_banner_check("none");    
        }
        if($secAuditActionBannerFlag==0)
        {
           sec_user_audit_action_banner_check("none"); 
        }
        if($sslCertRevocationFlag==0)
        {
           ssl_cert_revocation_check("none","DEFAULT");
        }
    }
	
}
sub ssl_server_dn_match
{
    my $value = shift;
     my $maxRows = $ENV{'SSLDN'};
     if ( $maxRows eq "" )
     {
       $maxRows = 1;
     }                
     if(!compareNegInf(0, $maxRows)){
         return;
     }
    my $res = check_512char($value);
    if($res != -1){                              
        print "em_result=ssl_server_dn_match|$res|NA\n";
    }
    
}
sub sqlnet_ora_inbound_connect_timeout
{
    my $value = shift;
    my $maxRows = $ENV{'SQLNETINBOUND'};
     if ( $maxRows eq "" )
     {
       $maxRows = 1;
     }                
    if(!compareNegInf(0, $maxRows)){
        return;
    }
    # this is doubtful everywhere else check_512char is used only with windows
    my $res = check_512char($value);
    if($res != -1){
     print "em_result=inbound_connect_timeout|$res|NA\n";   
    }
}
sub sqlnet_ora_perms
{
    my $maxCount;
   if($OSNAME eq "WIN"){
    $maxCount = $ENV{'NSQLNETPERMSMAX'};
   }else{
    $maxCount = $ENV{'SQLNETPERMSMAX'};
   } 

    if ( $maxCount eq "" )
    {
      $maxCount = 1;
    }

    $rowNum = 0;
    my $err="" ;
    if($OSNAME ne "WIN") #check if platform is not Windows
    {
        my $fperms = file_perm($fp);
        if(($fperms >= 0) && (compareNegInf(0,$maxCount)))
        {
            $fperms = $fperms & 0777;
            printf("em_result=sqlnetora_permission|%03o|NA\n",$fperms);
        }
        else
        {
            #file_perm failed to get the permissions for some reason
        }
    }
    elsif($OSNAME eq "WIN"){
        if(!compareNegInf($rowNum, $maxCount)){
            return;
        }       
        my $win_perm = check_512char(win32_file_perm($fp));
        if($win_perm != -1) {
            if($win_perm ne "0()"){
                print "em_result=nt_sqlnetora_permission|$win_perm|$fp\n";
                $rowNum++;
            }
        }
    }
    #else
    #{
    #non-linux and non-NT stuff;
    #}
}

sub sqlnet_client_log_directory
{
    my $maxPermCount;#for this subroutine, do not print more than $maxPermCount(applies to only the 
    #permission rows, not the owner row)
    my $maxOwnCount = $ENV{'CLDOWN'};

    if($OSNAME eq "WIN"){
        $maxPermCount = $ENV{'NCLDPERM'};
    }else{
        $maxPermCount = $ENV{'CLDPERM'};
    }

    if ( $maxPermCount eq "" )
    {
      $maxPermCount = 1;
    }

    if ( $maxOwnCount eq "" )
    {
      $maxOwnCount = 1;
    }

    $rowNum = 0;
    my $perms;
    my $owner;
    my $correctFile = shift;
    if($OSNAME ne "WIN") #check if platform is not Windows
    {
        $perms=file_perm($correctFile);
        if( ($perms >= 0) && compareNegInf($rowNum, $maxPermCount)) {
            $perms = $perms & 0777;
            printf("em_result=client_log_directory_perm|%03o|$correctFile\n",$perms);
            $rowNum++;
        }
        #else{}  #file_perm failed to get the permissions for some reason
    }
    elsif($OSNAME eq "WIN"){
        my $win_perm = check_512char(win32_file_perm($correctFile));
        if( ($win_perm != -1) && (compareNegInf($rowNum, $maxPermCount)) ) {
            if($win_perm ne "0()"){
                print "em_result=nt_client_log_directory_perm|$correctFile|$win_perm\n";
                $rowNum++;
            }
        }
    }
    compareOwner("client_log_directory_own", $maxOwnCount, $correctFile, $TGT_ORACLE_HOME);
}

sub sqlnet_server_log_directory
{
    my $maxPermCount;#for this subroutine, do not print more than $maxPermCount(applies to only the
    #permission rows, not the owner row)
    my $maxOwnCount = $ENV{'SLDOWN'};

    if($OSNAME eq "WIN"){
        $maxPermCount = $ENV{'NSLDPERM'};
    }else{
        $maxPermCount = $ENV{'SLDPERM'};
    }

    if ( $maxPermCount eq "" )
    {
      $maxPermCount = 1;
    }

    if ( $maxOwnCount eq "" )
    {
      $maxOwnCount = 1;
    }

    $rowNum = 0;
    my $perms;
    my $owner;
    my $correctFile = shift;
    if($OSNAME ne "WIN") #check if platform is not Windows
    {
        $perms=file_perm($correctFile);
        if( ($perms >= 0) && compareNegInf($rowNum, $maxPermCount) ){
            $perms = $perms & 0777;
            printf("em_result=server_log_directory_perm|%03o|$correctFile\n",$perms); #was %04o
            $rowNum++;
        }
        #else{}  #file_perm failed to get the permissions for some reason
    }
    elsif($OSNAME eq "WIN"){
        my $win_perm = check_512char(win32_file_perm($correctFile));
        if( ($win_perm != -1) && (compareNegInf($rowNum, $maxPermCount)) ){
            if($win_perm ne "0()"){
                print "em_result=nt_server_log_directory_perm|$correctFile|$win_perm\n";
                $rowNum++;
            }
        }
    }
    compareOwner("server_log_directory_own", $maxOwnCount, $correctFile, $TGT_ORACLE_HOME);
}

sub sqlnet_client_trace_directory
{
    my $maxPermCount;#for this subroutine, do not print more than $maxPermCount(applies to only the
    #permission rows, not the owner row)
    my $maxOwnCount = $ENV{'CTDOWN'};

    if($OSNAME eq "WIN"){
        $maxPermCount = $ENV{'NCTDPERM'}
    }else{
        $maxPermCount = $ENV{'CTDPERM'}
    }
    if ( $maxPermCount eq "" )
    {
      $maxPermCount = 1;
    }

    if ( $maxOwnCount eq "" )
    {
      $maxOwnCount = 1;
    }
    $rowNum = 0;
    my $correctFile = shift;
    my $owner;
    if($OSNAME ne "WIN") #check if platform is not Windows
    {
        my $perms=file_perm($correctFile);
        if( ($perms >= 0) && compareNegInf($rowNum, $maxPermCount) ){
            $perms = $perms & 0777;
            printf("em_result=client_trace_directory_perm|%03o|$correctFile\n",$perms); #was %04o
            $rowNum++;
        }
        #else{}  #file_perm failed to get the permissions for some reason
    }
    elsif($OSNAME eq "WIN"){
        if(!compareNegInf($rowNum, $maxPermCount)){
            return;
        }       
        my $win_perm = check_512char(win32_file_perm($correctFile));
        if( ($win_perm != -1) && (compareNegInf($rowNum, $maxPermCount)) ){
            if($win_perm ne "0()"){
                print "em_result=nt_client_trace_directory_perm|$correctFile|$win_perm\n";
                $rowNum++;
            }
        }
    }
    compareOwner("client_trace_directory_own", $maxOwnCount, $correctFile, $TGT_ORACLE_HOME);
}

sub sqlnet_server_trace_directory
{
    my $maxPermCount;#for this subroutine, do not print more than $maxPermCount(applies to only the
    #permission rows, not the owner row)
    my $maxOwnCount = $ENV{'STDOWN'};#for this subroutine, do not print more than $maxPermCount(applies to only the

    if($OSNAME eq "WIN"){
        $maxPermCount = $ENV{'NSTDPERM'};
    }else{
        $maxPermCount = $ENV{'STDPERM'};
    }
    if ( $maxPermCount eq "" )
    {
      $maxPermCount = 1;
    }

    if ( $maxOwnCount eq "" )
    {
      $maxOwnCount = 1;
    }
    $rowNum = 0;
    my $perms;
    my $owner;
    my $correctFile = shift;
    if($OSNAME ne "WIN") #check if platform is not Windows
    {
        my $perms=file_perm($correctFile);
        if( ($perms >= 0) && compareNegInf($rowNum, $maxPermCount) ){
            $perms = $perms & 0777;
            printf("em_result=server_trace_directory_perm|%03o|$correctFile\n",$perms); #was %04o
            $rowNum++;
        }
    }
    elsif($OSNAME eq "WIN"){
        my $win_perm = check_512char(win32_file_perm($correctFile));
        if( ($win_perm != -1) && (compareNegInf($rowNum, $maxPermCount)) ){
            if($win_perm ne "0()"){
                print "em_result=nt_server_trace_directory_perm|$correctFile|$win_perm\n";
                $rowNum++;
            }
        }
    }
    compareOwner("server_trace_directory_own", $maxOwnCount, $correctFile, $TGT_ORACLE_HOME);
}

sub sqlnet_allowed_logon_version
{
    my $value = shift;
    my $maxRows = $ENV{'ALLLOG'};
    if ( $maxRows eq "" )
    {
      $maxRows = 1;
    }
    if(compareNegInf(0, $maxRows)){
        print "em_result=allowed_logon_version|$value|$db_version\n";
    }
}



sub sqlnet_expire_time
{
    my $value = shift;
    print "em_result=expire_time|$value|NA\n";
}

sub valid_node
{
    my $valuesHasRef = shift;
    my %valuesHash= %$valuesHasRef;
    
    if(defined $validNodeParams{"tcp.validnode_checking"})
    {
      if(lc($validNodeParams{"tcp.validnode_checking"}) eq "yes")
      {
          if(!(defined $validNodeParams{"tcp.invited_nodes"}))
          {
             print "em_result=invited_nodes|none|NA\n";

             if(!(defined $validNodeParams{"tcp.excluded_nodes"}))
             {
               print "em_result=excluded_nodes|none|NA\n";
             }
          }                   
      }
      else
      {
          my $value=$validNodeParams{"tcp.validnode_checking"};
          print "em_result=validnode|$value|NA\n";
      }
      
    }
    else
    {
       print "em_result=validnode|no|DEFAULT\n";
    } 
}
sub sqlnet_encryption_server
{
	my $value = shift;
        my $value2 = shift;
        $value2=(defined $value2)?$value2:"NA";
#	if(lc($value) ne "required")
#	{
		print "em_result=encryption_server|$value|$value2\n";
#	}
}
sub sqlnet_encryption_types_server
{
	my $value =shift;
	$value=lc($value);
        my $value2 = shift;
       $value2=(defined $value2)?$value2:"NA";
    #may need to add a validation agaist a condition 
	print "em_result=encryption_types_server|$value|$value2\n";
}
sub sqlnet_crypto_checksum_server
{
	my $value = shift;
        my $value2 = shift;
        $value2=(defined $value2)?$value2:"NA";
#	if(lc($value) ne "required")
#	{
		print "em_result=crypto_checksum_server|$value|$value2\n";
#	}

}
sub sqlnet_crypto_checksum_type_server
{
    my $value = shift;
    my $value2 = shift;
    $value2=(defined $value2)?$value2:"NA";
	#the order in the server takes precedence. so it is a violation even if SQLNET.CRYPTO_CHECKSUM_TYPE_SERVER = (MD5,SHA1)
#	if(lc($value) ne "sha1")
#	{
		print "em_result=crypto_checksum_type_server|$value|$value2\n"; 
#	}
}
sub ssl_cipher_suites
{
	my $value=shift;
        my $value2 = shift;
        $value2=(defined $value2)?$value2:"NA";
         
#	if(lc($value) ne "ssl_rsa_with_3des_ede_cbc_sha" && lc($value) ne "ssl_rsa_with_des_cbc_sha")
#	{
		print "em_result=ssl_cipher_suites|$value|$value2\n"; 
#	}
}
sub ssl_client_authentication
{
	my $value=shift;
        my $value2 = shift;
        $value2=(defined $value2)?$value2:"NA";
#	if(lc($value) ne "true")
#	{
		print "em_result=ssl_client_authentication|$value|$value2\n";
#	}
}
sub ssl_version
{
	my $value=shift;
        my $value2 = shift;
        $value2=(defined $value2)?$value2:"NA";
#	if($value ne "3.0")
#	{
        print "em_result=ssl_version|$value|$value2\n";
#	}
}
sub sqlnet_authentication_services
{
	my $value=shift;
        my $value2 = shift;
        $value2=(defined $value2)?$value2:"NA";
	$value=lc($value);
	print "em_result=sqlnet_authentication_services|$value|$value2\n";
}
sub sec_user_unauthorized_access_banner_check
{
        my $value=shift;
        if($value eq "none")
        {
            print "em_result=sec_user_unauthorized_access_banner|none|DEFAULT\n";
        }
        elsif(! -e $value)
        {
            my $value_t=check_512char($value); 
            print "em_result=sec_user_unauthorized_access_banner|none|$value_t\n";
        }
}
sub sec_user_audit_action_banner_check
{
       my $value=shift;
       if($value eq "none")
       {
          print "em_result=sec_user_audit_action_banner|none|DEFAULT\n";
       }
       elsif(!(-e $value))
       {
           my $value_t=check_512char($value);
           print "em_result=sec_user_audit_action_banner|none|$value_t\n";
       }
}
sub ssl_cert_revocation_check
{
      my $value=shift;
      my $value2 = shift;
      $value2=(defined $value2)?$value2:"NA";
     # if(lc($value) ne "required")
     # {
          print "em_result=ssl_cert_revocation|$value|$value2\n";
     #}
}
