#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/utlFileDir.pl /main/17 2011/07/29 23:36:01 hpalitan Exp $
#
# utlFileDir.pl
# 
# Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      utlFileDir.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hpalitan    07/20/11 - Bug #12764760
#    hpalitan    02/17/11 - Use get_osType()
#    denath      09/02/08 - Backport denath_bug-5453944 from main
#    kganapat    12/03/07 - XbranchMerge kganapat_filter_ora_errs from main
#    manosing    09/17/07 - bug 6411390
#    ssalunke    12/11/06 - Adding support for other unix operating systems
#    dkjain      07/03/05 - Fixed the em_error with print 
#    dsukhwal    05/13/05 - limit number of rows pushed 
#    dsukhwal    05/05/05 - handle win32 cases 
#    dsukhwal    02/15/05 - exceptional cases in file_perm usage 
#    dkjain      12/25/04 - check_permission() removed 
#    dkjain      12/14/04 - Changed mask used to extract the permissions of others 
#    dkjain      10/31/04 - Fixed unable to connect
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
  require "emd_common.pl";
  require "semd_common.pl";
  require "db/esaDbUtils.pl";
  require "db/esaUtils.pl";
  require "find_os.pl";
  
  my $dsn = "dbi:Oracle:" ;
  my %stdinArgs = get_stdinvars();
  my $username = $stdinArgs{"EM_TARGET_USERNAME"};
  my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $address = $ENV{EM_TARGET_ADDRESS};
  my $role = $ENV{EM_TARGET_ROLE};
  my $mode = 0;
  my $rowNum = 0;
  my $OSNAME = get_osType();
  
  if($role =~ /SYSDBA/i)
  {
    $mode = 2;
  }
  elsif($role =~ /SYSOPER/i)
  {
    $mode = 4;
  }


   my $property1 = "utl_file_dir" ;
   my $property2 ="utl_file_dir_9i+";  
   my $utlFileDirMax = $ENV{'UTLFILEDIRMAX'};
   my $utlFileDir9Max = $ENV{'UTLFILEDIR9MAX'};
   my $table = "v\$parameter";  
   my $value = "value";
   my $name = "name";

  EMD_PERL_DEBUG("ohExeBinPerm: OS         = $OSNAME");
  EMD_PERL_DEBUG("ohExeBinPerm: oracleHome = $oracleHome");
  EMD_PERL_DEBUG("ohExeBinPerm: utlFileDirMax    = $utlFileDirMax");
  EMD_PERL_DEBUG("ohExeBinPerm: utlFileDir9Max    = $utlFileDir9Max");
  EMD_PERL_DEBUG("ohExeBinPerm: role       = $role");
  EMD_PERL_DEBUG("ohExeBinPerm: mode       = $mode");
  
   my $dbh = open_db_connection("dbi:Oracle:", "$username@".$address,$password,$mode); 
   my @utlFileDir = getValue($dbh,$value,$name, "utl_file_dir",$table);
  
   $table = "v\$version" ;
   my $banner = "banner" ;
   my $sth = $dbh->prepare_cached("SELECT $banner FROM $table where $banner like '%Oracle%' ")
	    or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr",  $dbh->err)); 

        $sth->execute()
        or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr",  $sth->err)) ;
   

   my @edition = $sth->fetchrow_array();
   if(!($edition[0]=~ "8i")&&($utlFileDir[0] ne ""))
   {
       ##Policy 2 if the editions is 9i and the utl_file_dir is nonempty this part
       ##will cause a violation.
       $globalProperty = $property2 ;
       split_utl_file_dir($utlFileDir[0], $utlFileDir9Max) ; 
       exit(0);
   }
   elsif(!($edition[0]=~ "8i")&&($utlFileDir[0] eq ""))
   {
      #if editions is 9i and utl_file_dir empty then no need to continue 
      exit(0); 
   }
 
   # here $table should be v$parameter.
  $table = "v\$parameter"; 
  
  
  my @userDumpDest = getValue($dbh,$value,$name, "user_dump_dest",$table);
  close_db_connection($dbh);

  if(($edition[0]=~ "8i") &&($utlFileDir[0] ne "")){
    utl_file_check($utlFileDir[0],$userDumpDest[0],$utlFileDirMax) ; 
  }

  sub utl_file_check() {
   my ($utlFileDir,$userDumpDest,$maxRows) = @_;
   $userDumpDest=~ s/^\?/$oracleHome/g; 
   my @utlFileDirList = split(/, /,$utlFileDir); 
   #Remove the duplicates in array. This is definied in esaUtil.pl
   @utlFileDirList = uniq_array(@utlFileDirList);
   my $dir ;
   #my @dNameList ;
   my $retMode ;
   if(defined($maxRows) && ($maxRows >= 0)){
    splice(@utlFileDirList, $maxRows);
   }
   for $dir (@utlFileDirList){  
    if($dir eq $userDumpDest)
    {
     print "em_result=$property1|$dir|NA\n";
    }
    elsif($dir eq ".")
    {
     print "em_result=$property1|$dir|NA\n" ;
    }
    elsif($dir eq "*")
    {
     print "em_result=$property1|$dir|NA\n" ;
    }
    else {
     if($OSNAME ne "WIN"){
         $retMode = file_perm($dir);
         if(($retMode & 007) > 0) {
           #$retMode = ($retMode & 0777) & 007 ;
           $dir = check_512char($dir); 
           #$globalProperty = $property1 ; 
           #@dNameList = util_print(@dNameList,$dir); 
           print "em_result=$property1|$dir|NA\n";
         }
     }
     elsif($OSNAME eq "WIN"){
        if(!compareNegInf($rowNum, $maxRows)){
            exit(0);
        }
        $dir = check_512char($dir); 
        print "em_result=$property1|$dir|NA\n" ;
     }
    }
   }
 }
 sub split_utl_file_dir() {
   my $utlFileDir = shift ; 	
   my $maxRows = shift;
   my @utlFileDirList = split(/, /,$utlFileDir); 
   #Remove the duplicates in array. This is definied in esaUtil.pl
   @utlFileDirList = uniq_array(@utlFileDirList); 
   my $dir ;
   if(defined($maxRows) && ($maxRows >= 0)){
    splice(@utlFileDirList, $maxRows);
   }
   #my @dNameList ;
   for $dir (@utlFileDirList){  
       $dir = check_512char($dir); 
       print "em_result=$globalProperty|$dir|NA\n" ; 
       #util_print($dir); 
       #@dNameList = util_print(@dNameList,$dir);
   }
 }
