#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/wintools.pl /main/7 2011/07/29 23:36:01 hpalitan Exp $
#
# wintools.pl
# 
# Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      wintools.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hpalitan    07/19/11 - Bug #12764760
#    hpalitan    02/17/11 - Use get_osType()
#    manosing    11/28/06 - Creation
#
#
#
#

require "emd_common.pl";
require "db/esaUtils.pl";
require "find_os.pl";
   
my $OSNAME = get_osType();

#EMD_PERL_DEBUG("wintools: OS          = $OSNAME");
   
if($OSNAME ne "WIN"){
    exit(0);
}

my $maxRow=$ENV{"WINTOOL"};

EMD_PERL_DEBUG("wintools: maxRow  = $maxRow");

if($maxRow==0){
   exit(0);
}
  
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};

EMD_PERL_DEBUG("wintools: oracleHome  = $oracleHome");
  
  my $limit=0;

  my $p="$ENV{'systemroot'}"."\\system32";
  my $arrRef;
  my %hash;

  opendir(DIRHANDLE,$p)||exit(1);
  @cont = grep /^.*\.exe$/,readdir(DIRHANDLE);
  close DIRHANDLE; 

  my $owner = win32_file_owner($oracleHome);
  
  EMD_PERL_DEBUG("wintools: owner  = $owner");
  
  if($owner ==-1){
      exit(0);
  }
  foreach $ele ( @cont){
      my $t = "$p\\$ele";
      my ($res, $numRows) =  getACLs($t,9000); #we want all entries. Hoping 9000 is enough.
      
      if($res == -1){
          exit(0);
      }
      %hash = %$res;      
      $arrRef = $hash{$owner};
      if($arrRef ne ""){
          print "em_result=win_tools|$ele|NA\n";
          $limit++;
          if($limit>=$maxRow && $maxRow!=-1){
              exit(0);
          }
      }
  }
  
 
