# $Header: emdb/sysman/admin/scripts/dbGetAdrHome.pl /st_emdbgc_10.2.0.1.0/1 2008/10/14 08:44:49 loliu Exp $
#
# dbGetAdrHome.pl
#
# Copyright (c) 2006, 2008, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      dbGetAdrHome.pl
#
#    DESCRIPTION
#      Given the db_name and instance_name, determine
#      the complete path to ADR home. Note that this script should never
#      "die". It should always return some value for the ADR home.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       loliu    09/19/08 - Backported from EMDBSA 11.2 to EMDBGC 10.2.0.5
#       loliu    02/19/07 - Creation
#

use strict;
use DBI;

require "emd_common.pl";
require "dbAdrUtil.pl";

my $adr_home = get_diag_info_from_db("ADR Home");

EMAGENT_PERL_DEBUG("dbGetAdrHome: read from database adr_home=$adr_home");

$adr_home = read_or_save_state($adr_home, "adr.home");

if (!$adr_home)
{
    $adr_home = "";
}

EMAGENT_PERL_DEBUG("dbGetAdrHome: adr_home=$adr_home");

print "em_result=$adr_home\n";

exit 0;

