#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/dbGetOsmInstance.pl /st_emdbgc_10.2.0.1.0/1 2008/10/14 08:44:49 loliu Exp $
#
# dbGetOsmInstance.pl
# 
# Copyright (c) 2007, 2008, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      dbGetOsmInstance.pl - Get the OSMInstance property.
#
#    DESCRIPTION
#      This will get the value of the associated ASM instance for this
#      RDBMS instance.  If the database is unavailable, it will use the
#      last successful read from state files on disk.
#
#    NOTES
#      
#
#    MODIFIED   (MM/DD/YY)
#    loliu       09/19/08 - Backported from EMDBSA 11.2 to EMDBGC 10.2.0.5
#    loliu       09/19/08 - 
#    fagonzal    11/08/07 - 
#    jsoule      09/28/07 - Creation
# 

use strict;
use DBI;

require "emd_common.pl";
require "dbAdrUtil.pl";

my $asm_sid = get_asm_sid_from_db();

EMAGENT_PERL_DEBUG("read OSMInstance $asm_sid from database");

$asm_sid = read_or_save_state($asm_sid, "OSMInstance", 1);

if (!$asm_sid)
{
  $asm_sid = "";
}

EMAGENT_PERL_DEBUG("OSMInstance=$asm_sid");

print "em_result=$asm_sid\n";

exit 0;

