#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/dbUtil.pl /st_emgc_pt-12.1.0.4pg/1 2012/06/26 20:13:16 mperugu Exp $
#
# dbUtil.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      dbUtil.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    mperugu     06/01/12 - add isDBVersion121OrHigher
#    hpalitan    07/11/11 - Creation
# 

use strict;
use Oraperl;
use DBI;

require "emd_common.pl";
require "semd_common.pl";


sub handle_error_and_exit {
	my $message = shift;
	EMD_PERL_ERROR ($message);
	exit 0; #stop the program
}

sub is_tgt_dv_enabled {

	my $username_1 = $_[0];
	my $password_1 = $_[1];
	my $address_1  = $_[2];
	my $mode_1     = $_[3];
	
	my $is_dv_enabled_1 = "-1";

	my $is_dv_enabled_lda_1 = DBI->connect('dbi:Oracle:', "$username_1@".$address_1, "$password_1",
		{ora_session_mode => $mode_1, PrintError => 0, RaiseError => 1,HandleError => \&handle_error_and_exit})
		or handle_error_and_exit("Could not connect to $username_1/$address_1: $DBI::errstr\n");
	 
	register_metric_call($is_dv_enabled_lda_1);

	my $is_dv_enabled_sql_1 = "select count(*) from dba_users where username ='DVSYS' and user_id = 1279990"; 

	my $is_dv_enabled_cur_1 = $is_dv_enabled_lda_1->prepare($is_dv_enabled_sql_1)
	   or handle_error_and_exit("prepare($is_dv_enabled_sql_1): $DBI::errstr\n");
	$is_dv_enabled_cur_1->execute()
	   or handle_error_and_exit("is_dv_enabled_cur_1->execute(): $DBI::errstr\n");
	   


	while (my ($is_dv_enabled1_1) = $is_dv_enabled_cur_1->fetchrow_array())  # keep fetching until there's nothing left
	{
		$is_dv_enabled_1 = trim($is_dv_enabled1_1);
	}

	$is_dv_enabled_lda_1->disconnect
		or warn "disconnect $DBI::errstr\n";

	return $is_dv_enabled_1;		
}

sub get_tgt_db_connection {
    my ($dsn_1, $user_1, $passwd_1,$mode_1) = @_;
    my $dbh = DBI->connect($dsn_1, $user_1, $passwd_1,
      {ora_session_mode => $mode_1, PrintError => 0, RaiseError => 0, AutoCommit => 0})
      or handle_error_and_exit("Could not connect to $user_1: $DBI::errstr\n");
	register_metric_call($dbh);
    return $dbh ;
}

sub isDBVersion121OrHigher {
    my ($dsn_1, $user_1, $passwd_1,$mode_1) = @_;
    my $returnValue = 0;
    my $db_version;
    my @fetch_row;
    my @versionNumbers;

    my $dbh = get_tgt_db_connection ($dsn_1, $user_1, $passwd_1,$mode_1);

    my  $db_sql = "SELECT version ".
                   "FROM v\$instance ";

    my $db_cur = $dbh->prepare($db_sql)
                 or handle_error_and_exit("prepare($db_sql): $DBI::errstr\n");

    $db_cur -> execute()
        or handle_error_and_exit("db_cur -> execute():$DBI::errstr\n");

    @fetch_row = $db_cur->fetchrow_array();
    $db_version = $fetch_row[0];
    EMD_PERL_DEBUG ("Database Version: $db_version");
    $dbh->disconnect
              or warn "disconnect $DBI::errstr\n";
    @versionNumbers = ( $db_version =~ m/(\d+)\.(\d+)\.(\d+)\.(\d+)\.(\d+)/g);

    if($versionNumbers[0] >= 12 )
    {
       $returnValue = 1;
    }
    return $returnValue;
}
