#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db_lsnrconfig_ecm.pl /st_emgc_pt-12.1.0.4pg/1 2012/02/19 22:46:05 prjaiswa Exp $
#
# db_lsnrconfig_ecm.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      db_lsnrconfig_ecm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    prjaiswa    02/16/12 - bug 13714177
#    prjaiswa    09/22/11 - changing parsing logic of tnsnames.ora
#    prjaiswa    06/24/11 - Bug 12642407
#    ajdsouza    05/05/11 - change metric error messages to debug
#    ajdsouza    04/06/11 - fixed sub trim clash
#    prjaiswa    10/08/10 - Bug 10176086
#    prjaiswa    04/02/10 - database listener configuration ecm collection
#    prjaiswa    04/02/10 - Creation
# 

use strict;
use warnings;

use FileHandle;
use vars qw/ $OS $NT $S $TEMP $CP $MV $PS $DF $DELIMITER/;
require "db/esaUtils.pl";

require "db/db_common.pl";
require "db/net/listenerUtil.pl";
require "dbUtil.pl";

sub find_tns_admin;
sub discover_lsnr_host_port;
sub get_db_param_value;

sub handle_error 
{
  my ( $msg ) = @_;
  chomp $msg if $msg;
  $msg =~ s/^\s+|\s+$// if $msg;
  $msg =~ s/^\n//g if $msg;
  $msg =~ s/^em_error=// if $msg;
  print "em_error=$msg\n";
  exit (1);
}


# handle die message by printing me_error
$SIG{'__DIE__'} = sub { handle_error_and_exit(@_); };

my %stdinArgs = get_stdinvars();
my @output_list;
# pupulate the credentials hash
my %credentials;
$credentials{username} = $stdinArgs{EM_TARGET_USERNAME} if $stdinArgs{EM_TARGET_USERNAME};
$credentials{password} = $stdinArgs{EM_TARGET_PASSWORD} if $stdinArgs{EM_TARGET_PASSWORD};
$credentials{address} = $ENV{EM_TARGET_ADDRESS} if $ENV{EM_TARGET_ADDRESS};
$credentials{role} = $ENV{EM_TARGET_ROLE} if $ENV{EM_TARGET_ROLE};
$credentials{ORACLE_HOME} = $ENV{EM_TARGET_ORACLE_HOME} if $ENV{EM_TARGET_ORACLE_HOME};


my $local_machine = $ENV{EM_TARGET_MACHINE};
EMD_PERL_DEBUG("########  db_lsnrconfig_ecm :: called for EM Target $ENV{EM_TARGET_NAME} #########") if $ENV{EM_TARGET_NAME};
EMD_PERL_DEBUG("########  db_lsnrconfig_ecm :: called for EM Target undefined #########") unless $ENV{EM_TARGET_NAME};

# getting tnsAdmin and storing it
$credentials{TNS_ADMIN} = find_tns_admin($credentials{ORACLE_HOME}) ;

my $local_lsnr=get_db_param_value('LOCAL_LISTENER');
$local_lsnr=~ s/^\s+|\s+$// if $local_lsnr;
EMD_PERL_DEBUG("  local listener :: -$local_lsnr-") if $local_lsnr;
EMD_PERL_DEBUG("  local listener :: is undefined ") unless $local_lsnr;
discover_lsnr_host_port($local_lsnr);


my $remote_lsnr=get_db_param_value('REMOTE_LISTENER');
$remote_lsnr=~ s/^\s+|\s+$// if $remote_lsnr;
EMD_PERL_DEBUG("  remote listener :: -$remote_lsnr-") if $remote_lsnr;
EMD_PERL_DEBUG("  remote listener :: is undefined ") unless $remote_lsnr;
discover_lsnr_host_port($remote_lsnr) if $remote_lsnr;

# Removing duplicates from the output list and uploading
my %hash = map { $_, 1 } @output_list;
@output_list = keys %hash;

foreach my $i (@output_list)
{
   chomp($i);
   if ($i  ne "")  {
     print "em_result=$i\n";
   }
}

#### End of Main Script #######################################



sub discover_lsnr_host_port
{

    my ($lsnr_string) = @_;
    my @hostsarray =  "";
    my @portsarray = "";



    if (!($lsnr_string)) {
    EMD_PERL_DEBUG("Could not fetch value for local_listener parameter using default port 1521");
    # Handling : when local listener parameter is unknown default host-port is uploaded
    push (@output_list,"$local_machine|1521");
    return;
    }

    # handling following inline format for specifying local listener value directly 
    #(ADDRESS=(PROTOCOL=tcp)(HOST=abc.cd.efg.com)(PORT=5555)(PROTOCOL=tcp)(HOST=abc.cd.efg.com)(PORT=6666)(PROTOCOL=tcp)(HOST=abc.cd.efg.com)(PORT=7687))
    #(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=abc.cd.efg.com)(PORT=5555)(PROTOCOL=tcp)(HOST=abc.cd.efg.com)(PORT=6666)(PROTOCOL=tcp)(HOST=abc.cd.efg.com)(PORT=7687)))

    # INLINE handling of  host port parameter value 

    # if host , port , address present in local listener string , treat it as inline specification
    if  (
          ($lsnr_string =~ /host\s*=\s*/i)    &&
          ($lsnr_string =~ /port\s*=\s*/i)    &&
          ($lsnr_string =~ /address\s*=\s*/i) 
        ) 
    {
        # filter out host and port values
        EMD_PERL_DEBUG(" inline value  : $lsnr_string ");

        # All hosts necessarily be on same line   
        @hostsarray = $lsnr_string =~ /host\s*=\s*([a-zA-Z\.\d\-\_]*)/ig;
        EMD_PERL_DEBUG(" multiple match @hostsarray ". scalar(@hostsarray) );

        # All ports necessarily be on same line .
        @portsarray = $lsnr_string =~ /port\s*=\s*(\d*)/ig;      
        EMD_PERL_DEBUG(" multiple match @portsarray ".scalar(@portsarray) );
       
        # if host /port pairs are not equal then must be erroreneous parsing
        if ( ( scalar(@portsarray) ==  scalar(@hostsarray)) && 
             (scalar(@portsarray) >= 1) && 
             ( scalar(@hostsarray) >= 1 ) 
           )
        {
          
            for( my $i=0;$i < @portsarray ; ++$i)
            {

                EMD_PERL_DEBUG(" em_result=".$hostsarray[$i]."|".$portsarray[$i]);
                # when host is empty it is treated as local host 
                # Handling format (ADDRESS = (PROTOCOL=TCP)(HOST=)(PORT=1521))
                if ($hostsarray[$i]) 
                {
                   push(@output_list,$hostsarray[$i]."|".$portsarray[$i]);
                }
                else
                {
                   push(@output_list,$local_machine."|".$portsarray[$i]);
                }
              
            }
            return;
        }
        else
        {
             EMD_PERL_DEBUG(" inline host and port pairs are unequal . Parsing error... ");
             handle_error_and_exit("Error parsing inline String value  $lsnr_string  \n");

        }
    }

    # Handling inline format Host:port eg abc.cd.efg.com:1521
    # Assuming that multiple entries with this format is not supported and
    # both host /port are essential parameters
     if( $lsnr_string =~ /:\d*/ )
     {
        my @host_port_info = split(/:/, $lsnr_string);
        push(@output_list,$host_port_info[0]."|".$host_port_info[1]);
        return;
     }
     
    EMD_PERL_DEBUG("  lsnr_string  = $lsnr_string  \n");

    # if none of the above formats , it would be tnsstring to look for now  
    # Handling : single / Multiple tns String  if any
    my @tns_string = getCharsSeparatedWords($lsnr_string,",");
	
    EMD_PERL_DEBUG("  tns_string  = @tns_string  \n");

    my @addresses = resolveAddressesFromNames($credentials{TNS_ADMIN},\@tns_string);
 
    # fetching element from array one by one ....which is an array of hashes representing address
    foreach my $i (@addresses)
    {
        #traversing array of hashes for an alias
        foreach my $addDetailRef (@$i)
        {
           # getting host and port values from hashMap
           EMD_PERL_DEBUG("  addDetailRef  = $addDetailRef->{HOST},$addDetailRef->{PORT} \n");
	   if(defined $addDetailRef)
	   {
	      push (@output_list,$addDetailRef->{HOST}."|".$addDetailRef->{PORT});
	   }
         }
     }

}


sub find_tns_admin
{
    my ($oracle_home) = @_;

    # Code to determine TNSADMIN 

    my $SLASH = "/";
    if($NT)
    {
        $SLASH = "\\";
    }

    my $isDefault = 0;
    my $tnsadmin = $ENV{TNS_ADMIN};
    if ($tnsadmin) 
    {
         # do nothing only debug : got simply from Env
         EMD_PERL_DEBUG("  Env-tnsadmin = $tnsadmin \n"); 
          
    }else
    {
      # get TNSADMIN from registry on NT
        if($NT)
        {
          $tnsadmin=getTNS_ADMINOnNT($oracle_home);
          if (!($tnsadmin))
          {
              $isDefault = 1;
          }
        }
        else
        {$isDefault = 1;}
    }

    if($isDefault == 1)
    {
        # set it to default network/admin directory
        $tnsadmin=$credentials{ORACLE_HOME}.${SLASH}."network".${SLASH}."admin";
    }


    EMD_PERL_DEBUG("  tnsadmin = $tnsadmin \n");
      
    return $tnsadmin;

}



sub get_db_param_value
{

my ($param_name) = @_;

# --------------------------------------------------------------------
# +++ Establish Target DB Connection
# --------------------------------------------------------------------
my $mode = 0;
my $role = $credentials{role};
# To handle usecase when role property is not defined in targets.xml
if($role)
{
	if($role =~ /SYSDBA/i)
	{
	  $mode = 2;
	}
	elsif($role =~ /SYSOPER/i)
	{
	  $mode = 4;
	}
}
my $dbconn;

 $dbconn = &get_tgt_db_connection("dbi:Oracle:","$credentials{username}@".$credentials{address},$credentials{password},$mode);

  EMD_PERL_DEBUG(" Connected...\n");


	my $bufsql = "select VALUE from v\$parameter where upper(name) = '$param_name' ";
        my $stmt;

	if (defined $dbconn)
	{
		$stmt = $dbconn->prepare( $bufsql );
	}
	else
	{
   		 handle_error_and_exit("Could not prepare stmt $DBI::errstr\n");
	}

	if(defined $stmt)
	{	
		$stmt->execute();
	}
	else
	{	
    	 handle_error_and_exit("Could not execute stmt  $DBI::errstr\n"); 
	}
  my $value;
  $stmt->bind_columns(\($value));
  $stmt->fetch();
  EMD_PERL_DEBUG(" fetch   $value ...\n");
  $stmt->finish();
  $dbconn->disconnect();
  return $value;


}

      



