# insert the commands you wish to execute when eml fails to stay running. 
#
#
# Mail to specified user
#
#  The message text is passed in as the first parameter. 
#  The subject is passed in as the optional second parameter. 
#

use strict;
use Oraperl;
use Net::SMTP;

require "emd_common.pl";
require "semd_common.pl";

# Sends e-mail
# 1st arg: gateway
# 2nd arg: to address
# 3rd arg: from address
# 4th arg: subject
# 5th arg: body
sub sendMail
{
  my $smtp;
  my $gateway = $_[0];
  my $toEmail = $_[1];
  my $fromEmail = $_[2];
  my $subject = $_[3];
  my $body = $_[4];
  $smtp = Net::SMTP->new($gateway);
  $smtp->mail($fromEmail);
  $smtp->to($toEmail);
  $smtp->data();
  $smtp->datasend("Subject: $subject\n");
  $smtp->datasend("$body");
  $smtp->dataend();
  $smtp->quit();

  EMD_PERL_DEBUG("dbdown: Message Sent");
}

my $toEmail = "$ENV{emd_email_address}";
my $fromEmail ="$ENV{emd_from_email_address}";
my $gateway = "$ENV{emd_email_gateway}";
my $siteUrl ="$ENV{REPOSITORY_URL}";
my $emdVersion = "$ENV{agentVersion}";
my $rest;
my $sid = "$ENV{ORACLE_SID}";
my $oracle_home = "$ENV{ORACLE_HOME}";

#
$_ = $siteUrl;
s/upload\///;
($siteUrl, $rest) = split(' ', $_, 2);

if(!defined $toEmail || $toEmail eq "")
{
  EMD_PERL_ERROR("dbdown: emd_email_address is not correctly defined");
  exit(-1);
}
if(!defined $emdVersion || $emdVersion eq "")
{
  EMD_PERL_ERROR("dbdown: agentVersion is not correctly defined");
  exit(-1);
}
if($emdVersion !~ /10\.2.*/)
{
  EMD_PERL_ERROR("dbdown: This script should only run with agent version = 10.2 (11g dbcontrol)");
  exit(-1);
}

chomp($fromEmail);
chomp($toEmail);

if(!defined $gateway || $gateway eq "")
{
  EMD_PERL_WARN("dbdown: emd_email_gateway is not correctly defined");
  EMD_PERL_WARN("dbdown: using mailhost as default");
  $gateway = 'mailhost';
}

if(!defined $fromEmail || $fromEmail eq "")
{
  EMD_PERL_WARN("dbdown: emd_from_email_address is not correctly defined");
  EMD_PERL_WARN("dbdown: using nobody as default");
  $fromEmail = 'dbcontrol@example.com';
}
if(!defined  $sid ||  $sid eq "")
{ 
   EMD_PERL_WARN("dbdown: sid is not correctly defined");
   $sid= 'sid is not defined';
} 
if(!defined  $oracle_home ||  $oracle_home eq "")
{
   EMD_PERL_WARN("dbdown: oracle_home is not correctly defined");
   $oracle_home = 'oracle_home is not defined';
}

my $subject="Severe Enterprise Manager DB Control problem";
my $errorMsg="The database has gone down.\nThe URL is $siteUrl\n  SID : $sid \n ORACLE_HOME : $oracle_home\n";

EMD_PERL_DEBUG("dbdown: subject=$subject");
EMD_PERL_DEBUG("dbdown: $errorMsg");
EMD_PERL_DEBUG("dbdown: toemail=$toEmail");
EMD_PERL_DEBUG("dbdown: fromEmail=$fromEmail");
EMD_PERL_DEBUG("dbdown: siteUrl=$siteUrl");
EMD_PERL_DEBUG("dbdown: gateway=$gateway");
EMD_PERL_DEBUG("dbdown: SID :$sid");
EMD_PERL_DEBUG("dbdown: ORACLE_HOME :$oracle_home");


my $body = scalar localtime . "\n$subject\n$errorMsg";

sendMail($gateway, $toEmail, $fromEmail, $subject, $body);
