#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/has/appqos_config.pl /main/2 2011/04/12 02:29:50 gapadman Exp $
#
# appqos_config.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      appqos_config.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gapadman    03/15/11 - appqos config
#    gapadman    03/15/11 - Creation
# 
use strict;
use DBI qw(:sql_types);
use Cwd;

require "emd_common.pl";

BEGIN
{
 # temporarly setting environment only in dev view env
 # this code is not active in production
 if ( $ENV{ADE_VIEW_ROOT} and not $ENV{HAS_USE_SHIPHOME} )
 {

  if ( $ENV{EM_CRS_TEST_CRS_HOME}  )
  {
    $ENV{ORA_CRS_HOME} =  $ENV{EM_CRS_TEST_CRS_HOME};
  }
  else
  {
    my $advrt;
   $advrt =  $ENV{ADE_VIEW_ROOT};
   $advrt  =~ s/_ag$//;
   $advrt  = $advrt."t";
   $ENV{ORA_CRS_HOME}="$advrt/oracle";
  }

  if ( $ENV{EM_CRS_TEST_CLUSTER_NAME}  )
  {
    $ENV{CSS_CLUSTERNAME}=$ENV{EM_CRS_TEST_CLUSTER_NAME};
  }
  else
  {
    $ENV{CSS_CLUSTERNAME}='newdb_cluster';
  }

  $ENV{EM_CRS_HOME}="$ENV{ORA_CRS_HOME}";
  $ENV{CRS_HOME}="$ENV{ORA_CRS_HOME}";
  $ENV{CV_HOME}="$ENV{CRS_HOME}";
  $ENV{OCR_ROOT}="$ENV{CRS_HOME}/has_work/ocr.dat";
  $ENV{OCR_LOC}="$ENV{CRS_HOME}/has_work/ocr.loc";
  $ENV{CV_JDKHOME}="$ENV{CRS_HOME}/jdk15";
  $ENV{OCR_DEVELOPER_ENV}='TRUE';
  $ENV{ORA_ENVIRON_OPTS}='true';
  $ENV{ORA_CSS_VARS}='true';
  my $libs = "$ENV{CRS_HOME}/lib:$ENV{CRS_HOME}/has/lib:$ENV{CRS_HOME}/opsm/lib";
  $ENV{LD_LIBRARY_PATH}="$libs:$ENV{LD_LIBRARY_PATH}" if $ENV{LD_LIBRARY_PATH};
  $ENV{LD_LIBRARY_PATH}="$libs" unless $ENV{LD_LIBRARY_PATH};
  $ENV{PATH}="$ENV{CRS_HOME}/bin:$ENV{CRS_HOME}/has/bin:$ENV{PATH}" if $ENV{PATH};
  $ENV{PATH}="$ENV{CRS_HOME}/bin:$ENV{CRS_HOME}/has/bin" unless $ENV{PATH};

  my $clusternm = "newdb_cluster";
 }
}

my $crsHome = $ENV{EM_CRS_HOME};
EMD_PERL_DEBUG( "EM_CRS_HOME returned $crsHome \n");

$crsHome = $ENV{CRS_HOME} if ($crsHome eq "");
print( "CRS_HOME returned $crsHome \n");

#comment following for testing in view
my %stdinArgs = get_stdinvars();
my $clusternm = $stdinArgs{"EM_TARGET_CLUSTER_NAME"};

EMD_PERL_DEBUG( "EM_TARGET_CLUSTER_NAME = $clusternm \n");

if ($crsHome eq "" || $crsHome eq "#CRS_HOME#" || $clusternm eq "")
{
    EMD_PERL_DEBUG("Ignoring cluster Services metric: either no CRS_HOME or cluster name is not found \n");
}
else
{
    my $appqos_server_name = getAppQosServerName();
    my $appqos_port_num = getAppQosPortNum();
    
    my $em_result = "em_result=$appqos_server_name|$appqos_port_num\n";
    
    print "$em_result";
}

sub getAppQosServerName()
{
        my $result;
        my $cmd = "$crsHome/bin/srvctl status oc4j -S 1";
        chomp ($result = `$cmd`);
        
        my $stIdx = index($result,"up={") + 4;
        my $endIdx = index($result,"}",$stIdx);
        
        my $length = $endIdx - $stIdx ;
        my $serverName = substr($result,$stIdx,$length);
        
        return $serverName;
}

sub getAppQosPortNum()
{
        my $result;
        my $cmd = "$crsHome/bin/srvctl config oc4j -S 1";
        chomp ($result = `$cmd`);

        my $stIdx =  index($result,"port={") +6;
        my $endIdx = index($result,"}",$stIdx);

        my $length = $endIdx - $stIdx;
        my $portNum = substr($result,$stIdx,$length);

        return $portNum;
}
  
