#!/usr/local/bin/perl
#
# $Header: emdb/sysman/admin/scripts/has/clusterUtil.pl /st_emgc_pt-12.1.0.4pg/1 2012/08/05 22:23:58 prjaiswa Exp $
#
# clusterUtil.pl
#
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      clusterUtil.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    prjaiswa    07/15/12 - perl utility for cluster target.
#    prjaiswa    07/15/12 - Creation
#
use strict;
require "semd_common.pl";
my $LOG_CATEGORY     = "clusterUtil.pl: ";
my $DEFAULT_TIME_OUT = "3600";

# execute the supplied command
sub executeCommand
{
 my ( $cmd, $oh ) = @_;

 unset_lib_path_env();

 $ENV{ORACLE_HOME} = $oh;

 my $err    = "";
 my $output = "";
 if ( open( CMDOUTPUT, "$cmd 2>&1 |" ) )
 {
  my @outputs = <CMDOUTPUT>;
  $output = join "", @outputs;
  if ( !close(CMDOUTPUT) )
  {

   # close error
   if ( $output ne "" )
   {
    $err    = "\"${cmd}\" returned: \"" . $output . "\"";
    $output = "";
   }
   else
   {
    $err = "bad \"$cmd\": $! $?";
   }
  }
 }
 else
 {

  # open error
  $err = "cannot execute \"$cmd\": $!";
 }

 EMD_PERL_ERROR("executeCommand: $cmd: $err") if ( $err ne "" );
 ( $err, $output );
}

# execute the supplied command with timeout
sub executeCommandWithTimeout
{
 my ( $cmd, $oh, $tmo ) = @_;

 unset_lib_path_env();

 $ENV{ORACLE_HOME} = $oh;

 my $err    = "";
 my $output = "";

 eval {

  local $SIG{ALRM} = sub { die "alarm\n" };

  # we are expecting scan check to be over in 45 seconds
  # in case it hangs , this method will time out and execution
  # resumes ....
  alarm $tmo;

  # To test time out use case : uncomment below line
  #my $sleep = `sleep 60`;

  if ( open( CMDOUTPUT, "$cmd 2>&1 |" ) )
  {
   my @outputs = <CMDOUTPUT>;
   $output = join "", @outputs;
   if ( !close(CMDOUTPUT) )
   {

    # close error
    $err = "$?";

   }
  }
  else
  {

   # open error
   $err = "cannot execute \"$cmd\": $!";
  }

  alarm 0;
 };
 if ($@)
 {

  if ( $@ eq "alarm\n" )
  {
   EMD_PERL_INFO(
" $LOG_CATEGORY : executeCommandWithTimeout : timed out occured with command $cmd in $tmo seconds "
   );

   $err = 1;
   print "Command : $cmd took more than timeout value $tmo \n";
  }

  # log the message to the log file
  EMD_PERL_ERROR(
"$LOG_CATEGORY Exception in executeCommandWithTimeout: WARN: $@->getErrorMessage()"
  );

 }

 EMD_PERL_ERROR("executeCommand: $cmd: $err") if ( $err ne "" );
 ( $err, $output );
}

# unset the *LD_* env variable for proper function of srvctl
sub unset_lib_path_env
{
 delete $ENV{LD_LIBRARY_PATH};
 delete $ENV{SHLIB_PATH};
 delete $ENV{LIBPATH};
 delete $ENV{DYLD_LIBRARY_PATH};
}

sub get_err_msg
{
 my ( $err, $output ) = @_;

 my $err_msg = "";

 if ( $err ne "" )
 {
  $err_msg = $err;
 }
 elsif (    $output =~ /PRKP-/
         || $output =~ /PRKH-/
         || $output =~ /PRKO-/
         || $output =~ /CRS-/
         || $output =~ /ORA-/ )
 {
  $err_msg = $output;
 }

 ($err_msg);
}

# function to switch policy : called from  crs policy switch job
sub switchCrsPolicy
{

 my ( $oh, $version, $policyName, $evaluateFlag, $timeout ) = @_;
 my $cmd =
"$oh/bin/crsctl modify policyset -attr \"LAST_ACTIVATED_POLICY=$policyName\"";

 my $evalcmd = "$oh/bin/crsctl eval activate policy $policyName";

 # print "timeout = $timeout \n Command = $cmd \n";
 # print "Eval Command = $evalcmd  \n evaluateFlag = $evaluateFlag\n";

 if ( $evaluateFlag and $evaluateFlag eq "Yes" )
 {
  my ( $err_eval, $output_eval );
  if ($timeout)
  {

   ( $err_eval, $output_eval ) =
     executeCommandWithTimeout( $evalcmd, $oh, $timeout );

  }
  else
  {

   ( $err_eval, $output_eval ) =
     executeCommandWithTimeout( $evalcmd, $oh, $DEFAULT_TIME_OUT );

  }

  print
"******************** Evaluate result :start ****************************\n";

  print "$output_eval \n";

  print
"******************** Evaluate result : end ****************************\n";
 }
 my ( $err, $output );
 if ($timeout)
 {

  ( $err, $output ) = executeCommandWithTimeout( $cmd, $oh, $timeout );

 }
 else
 {
  ( $err, $output ) = executeCommandWithTimeout( $cmd, $oh, $DEFAULT_TIME_OUT );
 }

 EMD_PERL_DEBUG(
    "$LOG_CATEGORY switchCrsPolicy-> $cmd returned (err=$err, output=$output)");

 print "******************** Result :start ****************************\n";

 print "$output \n";

 print "******************** Result : end ****************************\n";

# if there is any error during command execution , error code will have some return
# value , if no error then it would be empty
# eg error code 256 if policy do not exist
#  error code 1 , if time out occured
# in case error code has some value , we will pass 1 (problem) to job system
# marking the execution as problematic .
 if ($err)
 {

  $err = "1";
 }
 else
 {
  $err = "0";
 }
 return $err;

}
