#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/has/has_os.pl /st_emgc_pt-12.1.0.4pg/1 2012/09/24 12:26:57 ajdsouza Exp $
#
# has_os.pl
# 
# Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      has_os.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajdsouza    09/16/12 - bug#14297228 
#    rsamaved    03/27/09 - fix linux OS
#    ajdsouza    12/10/08 - Creation
# 
use strict;
use warnings;

use locale;
use FindBin;
use Config;
use File::Spec::Functions;
use File::Path;
use Data::Dumper;


BEGIN
{

 use POSIX qw(locale_h);

 my $clocale='C';

 for ( qw ( LC_ALL LC_COLLATE LC_CTYPE LC_TIME LC_NUMERIC LC_MESSAGES LC_MONETARY LANG LANGUAGE ) )
 {
   $ENV{$_}=$clocale;
 }

 setlocale(LC_ALL,$clocale) or EMD_PERL_ERROR("WARN:Failed to set locale to $clocale \n ");

}

require "semd_common.pl";

EMD_PERL_DEBUG("in scripts/has/has_os.pl");

my $os;
my $osType = get_osType();


my $scriptsDir;
my $perlexe;

my $perlBin = $ENV{EM_PERLBIN_DIR} if $ENV{EM_PERLBIN_DIR};

if ( $perlBin )
{
   $perlexe = catfile($perlBin,'perl');
}


if ( not $perlexe ) 
{
  $perlexe = $Config{perlpath} if $Config{perlpath};
}

if ( $ENV{EMDROOT} )
{
  $scriptsDir=catfile($ENV{EMDROOT},'sysman');
  $scriptsDir=catfile($scriptsDir,'admin');
  $scriptsDir=catfile($scriptsDir,'scripts');
}
else
{
  EMD_PERL_ERROR("EMDROOT is not passed to script scripts/has_os.pl from EM Agent, failing to get os ");
}

stat $perlexe if $perlexe;
unless ( $perlexe and -f $perlexe )
{
  EMD_PERL_ERROR("Failed to get the perl bin directory in scripts/has_os.pl, failing to get os");
  exit 1;
}

my $osconfig_script;
if ( $scriptsDir )
{
  $osconfig_script =  catfile($scriptsDir,'osconfig.pl');
}

stat $osconfig_script if $osconfig_script;

unless ( $osconfig_script and -f $osconfig_script )
{
  EMD_PERL_ERROR("Failed to get the osconfig.pl script dir in scripts/has_os.pl, failing to get os");
  exit 1;
}

my $osresults = `$perlexe $osconfig_script`;

chomp $osresults if $osresults;

#  output from osconfig of format "em_result=$os|$os_release_level|$patchlevel|$platform|$uptime|$ip|$targetversion|$distribution\n";
if ( $osresults and $osresults =~ /em_result=/)
{
   ($os) = ( $osresults =~ /em_result=([^|]+)/);
   $os =~ s/^\s+|\s+$// if $os;
}

unless ( $os )
{
  EMD_PERL_ERROR("Failed to get the OS in script dir in scripts/has_os.pl");
  exit 1;
}

$osType = '' unless $osType;

print "em_result=$os|$osType\n";

exit 0;
