use strict;
use warnings;
use Data::Dumper;
use has::Common;

$Data::Dumper::Indent = 2;
$Data::Dumper::Deepcopy = 1;
$Data::Dumper::Purity = 1;
$Data::Dumper::Sortkeys = 1;

 #install signal handlers for warn and die
 $SIG{'__DIE__'} = sub {  has::Common::has_handle_error( @_ );
                         has_exitfail() };
 $SIG{'__WARN__'} = sub { has::Common::has_handle_error( @_)};

  # capture and store the env to be used for regressions
  my $envref;

  if ( $ENV{NDE_PRODUCT} and $ENV{NDE_PRODUCT} =~ /emdbgc/i )
  {
   $ENV{EMDROOT}="$ENV{ADE_VIEW_ROOT}_ag/oracle";
   # set path of libskgxn library if olsnodes/lsnodes is picked from the current directory
   $ENV{LD_LIBRARY_PATH}="$ENV{LD_LIBRARY_PATH}:$ENV{EMDROOT}/lib" if $ENV{LD_LIBRARY_PATH};
   $ENV{LD_LIBRARY_PATH}="$ENV{EMDROOT}/lib" unless $ENV{LD_LIBRARY_PATH};
  }

  $ENV{EMDROOT}="$ENV{ADE_VIEW_ROOT}/oracle" if $ENV{NDE_PRODUCT} =~ /emagent/i;
  $ENV{EM_TARGET_TYPE}='UNKNOWN';

  my $has_run_mode = $ENV{HAS_TEST_MODE} if $ENV{HAS_TEST_MODE};
  $envref = has::Common::hasGetEnv();

  for my $k ( keys %{$envref} )
  {
    $ENV{$k}=$envref->{$k};
  }

  # restore HAS_TEST_MODE back to regression if running in regression mode
  $ENV{HAS_TEST_MODE}='REGRESSION' if $has_run_mode and $has_run_mode =~ /regression/i;

# TBD : handle em_error, em_warn and stdout stderr issues
#--------------------------------------------------------------
# Begin Test Code - will be deleted
#--------------------------------------------------------------

# Test function to test all calls 

  my %rsh;
  my $ref;
  my $crsHome;
  my $dmpStrg;
  my $val;
  my $nodes;
  
  print "****************  Cluster Discover\n";
  $ref = has::Common::hasDiscoverCluster();
  $dmpStrg = Dumper($ref);
  print "$dmpStrg\n";

  print "****************  Node Name\n";
  $val = has::Common::hasGetNodeName();
  print "nodename = $val\n" if $val;

  print "****************  Cluster Name\n";
  $val = has::Common::hasGetClusterName();
  print "Cluster Name = $val\n" if $val;

  print "****************  Cluster Version \n";
  $val = has::Common::hasGetClusterVersion();
  print "Cluster Version = $val\n" if $val;

  print "****************  Host Name\n";
  $val = has::Common::hasGetLocalHostName();
  print "Host Name = $val\n" if $val;

  print "****************  Get OCR Type\n";
  $val = has::Common::hasGetOcrType();
  print "OCR Type = $val\n" if $val;

  print "****************  Check for emcrsp\n";
  $val = has::Common::hasCheckForEmcrsp();
  print "Check for emcrsp = $val\n" if $val;

  print "****************  Node List Pre 11g\n";
  $ref = has::Common::hasGetClusterNodeListPre11g();
  $dmpStrg = Dumper($ref);
  print "$dmpStrg\n";

  print "****************  Node List hasGetClusterNodes\n";
  $ref = has::Common::hasGetClusterNodes();
  $dmpStrg = Dumper($ref);
  print "$dmpStrg\n";

  print "****************  Cluster Config hasGetClusterConfig\n";
  $ref = has::Common::hasGetClusterConfig();
  $dmpStrg = Dumper($ref);
  print "$dmpStrg\n";

  print "****************  Cluster hasGetClusterStatus\n";
  $ref = has::Common::hasGetClusterStatus($nodes);
  # skip printing the verbose text
  delete $ref->{status}{o} if $ref and $ref->{status} and $ref->{status}{o};
  $dmpStrg = Dumper($ref);
  print " Buffer returned  = \n $dmpStrg\n";

  print "**************** hasGetSQLResults execute an sql and get results \n";
  my $sql = 'select sysdate dt, ROWNUM rn from dual';
  my %cred = ( 'username'=>'dbsnmp', 
               'password'=>'dbsnmp', 
               'address' =>'(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=stbdq17)(Port=25056))(CONNECT_DATA=(SID=scq1713)))',
               'role'    =>'any',
               'sql'     => [( $sql )] );
  my %fld;
  $fld{$sql} = { dt => 1, rn => 2};
  my $array_ref = has::Common::hasGetSQLResults(\%cred);
  print Dumper $array_ref;
  $array_ref = has::Common::hasGetSQLResults(\%cred,\%fld);
  print Dumper $array_ref;

  print "****************   warnings and erros for has_test_library_calls\n";
  # print error/warnings as em_warnings to stdout
  has::Common::has_printerrors()  or die "ERROR:Failed to print processing errors/warnings \n";


  exit 0;
