
use strict;
use warnings;
use Data::Dumper;
use has::Common;


$Data::Dumper::Indent = 2;
$Data::Dumper::Deepcopy = 1;
$Data::Dumper::Purity = 1;
$Data::Dumper::Sortkeys = 1;


#install signal handlers for warn and die
$SIG{'__DIE__'} = sub {  has::Common::has_handle_error( @_ );
                         has_exitfail() };
$SIG{'__WARN__'} = sub { has::Common::has_handle_error( @_)};

$ENV{ORA_CRS_HOME}='/ade/ajdsouza_has/oracle';
$ENV{CSS_CLUSTERNAME}='ajdsouzahas';
$ENV{CRS_HOME}="$ENV{ORA_CRS_HOME}";
$ENV{CV_HOME}="$ENV{CRS_HOME}";
$ENV{CV_JDKHOME}="$ENV{CRS_HOME}/jdk15";
$ENV{OCR_ROOT}="$ENV{CRS_HOME}/has_work/data.ocr";
$ENV{OCR_LOC}="$ENV{CRS_HOME}/has_work/ocr.loc";
$ENV{OCR_DEVELOPER_ENV}='TRUE';
$ENV{ORA_ENVIRON_OPTS}='true';

my $libs = "$ENV{CRS_HOME}/lib:$ENV{CRS_HOME}/has/lib:$ENV{CRS_HOME}/opsm/lib";

$ENV{LD_LIBRARY_PATH}="$libs:$ENV{LD_LIBRARY_PATH}" if $ENV{LD_LIBRARY_PATH};
$ENV{LD_LIBRARY_PATH}="$libs" unless $ENV{LD_LIBRARY_PATH};

  $ENV{PATH}="$ENV{CRS_HOME}/bin:$ENV{CRS_HOME}/has/bin:$ENV{PATH}" if $ENV{PATH};
  $ENV{PATH}="$ENV{CRS_HOME}/bin:$ENV{CRS_HOME}/has/bin" unless $ENV{PATH};

  # capture and store the env to be used for regressions
  my $envref;

  if ( $ENV{NDE_PRODUCT} and $ENV{NDE_PRODUCT} =~ /emdbgc/i )
  {
   $ENV{EMDROOT}="$ENV{ADE_VIEW_ROOT}_ag/oracle";
   # set path of libskgxn library if olsnodes/lsnodes is picked from the current directory
   $ENV{LD_LIBRARY_PATH}="$ENV{LD_LIBRARY_PATH}:$ENV{EMDROOT}/lib" if $ENV{LD_LIBRARY_PATH};
   $ENV{LD_LIBRARY_PATH}="$ENV{EMDROOT}/lib" unless $ENV{LD_LIBRARY_PATH};
  }
  elsif ( $ENV{NDE_PRODUCT} and $ENV{NDE_PRODUCT} =~ /emdbsa/i )
  {
   $ENV{EMDROOT}="$ENV{ADE_VIEW_ROOT}/oracle";
   # set path of libskgxn library if olsnodes/lsnodes is picked from the current directory
   $ENV{LD_LIBRARY_PATH}="$ENV{LD_LIBRARY_PATH}:$ENV{EMDROOT}/lib" if $ENV{LD_LIBRARY_PATH};
   $ENV{LD_LIBRARY_PATH}="$ENV{EMDROOT}/lib" unless $ENV{LD_LIBRARY_PATH};
  }

  $ENV{EMDROOT}="$ENV{ADE_VIEW_ROOT}/oracle" if $ENV{NDE_PRODUCT} =~ /emagent/i;
  $ENV{EM_TARGET_TYPE}='UNKNOWN';

  my $has_run_mode = $ENV{HAS_TEST_MODE} if $ENV{HAS_TEST_MODE};
  $envref = has::Common::hasGetEnv();

  for my $k ( keys %{$envref} )
  {
    $ENV{$k}=$envref->{$k};
  }

  # restore HAS_TEST_MODE back to regression if running in regression mode
  $ENV{HAS_TEST_MODE}='REGRESSION' if $has_run_mode and $has_run_mode =~ /regression/i;

# TBD : handle em_error, em_warn and stdout stderr issues
#--------------------------------------------------------------
# Begin Test Code - will be deleted
#--------------------------------------------------------------

# Test function to test all calls 

  my %rsh;
  my $ref;
  my $crsHome;
  my $dmpStrg;
  my $val;
  my $nodes;
  
  print "****************  Cluster Discover\n";
  $ref = has::Common::hasDiscoverCluster();
  $dmpStrg = Dumper($ref);
  print "$dmpStrg\n";

  print "****************  Node Name\n";
  $val = has::Common::hasGetNodeName($ENV{CRS_HOME});
  print "nodename = $val\n" if $val;

  print "****************  Cluster Name\n";
  $val = has::Common::hasGetClusterName($ENV{CRS_HOME});
  print "Cluster Name = $val\n" if $val;

  print "****************  Cluster Version \n";
  $val = has::Common::hasGetClusterVersion($ENV{CRS_HOME});
  print "Cluster Version = $val\n" if $val;

  print "****************  Host Name\n";
  $val = has::Common::hasGetLocalHostName();
  print "Host Name = $val\n" if $val;

  print "****************  Get OCR Type\n";
  $val = has::Common::hasGetOcrType($ENV{CRS_HOME});
  print "OCR Type = $val\n" if $val;

  print "****************  Check for emcrsp\n";
  $val = has::Common::hasCheckForEmcrsp($ENV{CRS_HOME});
  print "Check for emcrsp = $val\n" if $val;

  print "****************  Node List Pre 11g\n";
  $ref = has::Common::hasGetClusterNodeListPre11g($ENV{CRS_HOME});
  $dmpStrg = Dumper($ref);
  print "$dmpStrg\n";

  print "****************  Node List hasGetClusterNodes\n";
  $ref = has::Common::hasGetClusterNodes($ENV{CRS_HOME});
  $dmpStrg = Dumper($ref);
  print "$dmpStrg\n";

  print "****************  Cluster Config hasGetClusterConfig\n";
  $ref = has::Common::hasGetClusterConfig($ENV{CRS_HOME});
  $dmpStrg = Dumper($ref);
  print "$dmpStrg\n";

  print "****************  Cluster hasGetClusterStatus\n";
  $ref = has::Common::hasGetClusterStatus($nodes,$ENV{CRS_HOME});
  # skip printing the verbose text
  delete $ref->{status}{o} if $ref and $ref->{status} and $ref->{status}{o};
  $dmpStrg = Dumper($ref);
  print " Buffer returned  = \n $dmpStrg\n";

  print "**************** hasGetSQLResults execute an sql and get results \n";
  my $sql = 'select sysdate dt, ROWNUM rn from dual';
  my %cred = ( 'username'=>'dbsnmp', 
               'password'=>'dbsnmp', 
               'address' =>'(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=stbdq17)(Port=15042))(CONNECT_DATA=(SID=s1718)))',
               'role'    =>'any',
               'sql'     => [( $sql )] );
  my %fld;
  $fld{$sql} = { dt => 1, rn => 2};
  my $array_ref = has::Common::hasGetSQLResults(\%cred);
  print Dumper $array_ref;
  $array_ref = has::Common::hasGetSQLResults(\%cred,\%fld);
  print Dumper $array_ref;

  print "****************   warnings and erros for has_test_library_calls\n";
  # print error/warnings as em_warnings to stdout
  has::Common::has_printerrors()  or die "ERROR:Failed to print processing errors/warnings \n";


  exit 0;
