#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/hasGetAdrProps.pl /st_emgc_pt-12.1.0.4pg/2 2012/02/09 16:34:55 fagonzal Exp $
#
# hasGetAdrProps.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      hasGetAdrProps.pl - Retrieves ADR Home and ADR Base for HAS target
#
#    DESCRIPTION
#      Given the Oracle Home of the target, derives the ADR home & base.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fagonzal    09/21/11 - Creation
#
require "emd_common.pl";

use strict;
use File::Spec;
use Sys::Hostname;

my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
EMAGENT_PERL_DEBUG("hasGetAdrProps: oracleHome=$oracleHome");
$ENV{ORACLE_HOME} = $oracleHome;

my $hostname = Sys::Hostname->hostname();

# Default location of ADR base
my $adrBase = File::Spec->catdir($oracleHome, "log");

# If orabase utility exists, run it to determine ADR base location
my $oraBase = File::Spec->catdir($oracleHome, "bin", "orabase");
EMAGENT_PERL_DEBUG("hasGetAdrProps: oraBase=$oraBase");
if (-x $oraBase) {
  $adrBase = `$oraBase`;
  # Remove any newlines
  chomp($adrBase);
}

my $adrHome = File::Spec->catdir($adrBase, "diag", "crs", $hostname, "crs");

EMAGENT_PERL_DEBUG("hasGetAdrProps: adrBase=$adrBase");
EMAGENT_PERL_DEBUG("hasGetAdrProps: adrHome=$adrHome");

print "em_result=$adrBase|$adrHome\n";

