# $Header: emdb/sysman/admin/scripts/listenerload.pl /st_emgc_pt-12.1.0.4pg/2 2012/02/01 05:28:04 prjaiswa Exp $
#
# listenerload.pl
#
# Copyright (c) 2001, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      listenerload.pl
#
#    DESCRIPTION
#      retrieve listener load stats in the following format.
#      em_result=<number established connections>|<number refused connections>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    prjaiswa    01/11/12 - dyn prop fix
#    prjaiswa    01/11/12 - scan check fix :use machine check instead of port
#    prjaiswa    04/08/10 - moving scan check to listenerUtil
#    prjaiswa    09/15/09 - lrg 4156608
#    prjaiswa    08/21/09 - bug 8686293 -check for scan listener
#    mappusam    05/20/09 - bug-7284268 Fix
#    prjaiswa    05/29/08 - password listener enh
#    prjaiswa    05/12/08 - XbranchMerge prjaiswa_bug-6438597 from main
#    mkiran      09/08/07 - 6217209: Strip timestamp info from em_error
#    dkapoor     12/18/03 - return em_error on error
#    dkapoor     10/30/03 - don't parse listener first
#    dkapoor     04/23/03 - use generic method to get result
#    dkapoor     04/21/03 - parse listener for pswd
#    dkapoor     07/19/02 - remove connect data
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    xxu         10/12/01 - set_lib_path (bug 2044793)
#    aaitghez    07/06/01 - die when error.
#    aaitghez    07/06/01 - bad merge fix.
#    aaitghez    07/02/01 - error_parse check.
#    aaitghez    06/29/01 - no trace.
#    aaitghez    06/28/01 - setting address.
#    aaitghez    07/02/01 - instance variable naming convention
#    aaitghez    06/19/01 - removing debug calls.
#    aaitghez    06/01/01 - adding debug and making use of common utilities.
#    njagathe    05/29/01 - Set ORACLE_HOME instead of LSNR_ORACLE_HOME
#    aaitghez    05/18/01 - perl version of ListenerLoad.tcl.
#    aaitghez    05/18/01 - Creation
#

use strict;

require "semd_common.pl";
require "db/net/listenerUtil.pl";

$ENV{ORACLE_HOME} = $ENV{LSNR_ORACLE_HOME};
$ENV{TNS_ADMIN}   = $ENV{LSNR_ORA_DIR};

my $machine = $ENV{LSNR_MACHINE};
my $port    = $ENV{LSNR_PORT};
my $key     = $ENV{LSNR_KEY};
my $name    = $ENV{LSNR_NAME};
my $pswd    = $ENV{LSNR_PASSWORD};

my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $executable   = $ENV{LSNR_ORACLE_HOME} . "/bin/lsnrctl";
my $lsnrType     = $ENV{LSNR_TARGET_SUBTYPE};
my $lsnrVersion  = $ENV{LSNR_TARGET_VERSION};

EMD_PERL_DEBUG(" $name :: ####### listenerload.pl called ###########");
EMD_PERL_DEBUG(" $name :: LSNR_KEY is $key");
EMD_PERL_INFO(" $name :: listener subtype is $lsnrType");
EMD_PERL_INFO(" $name :: listener version is $lsnrVersion");

# Check for listener type
# retry only if type info was unavailable at agent start up
if ( $lsnrType eq "UNKNOWN" )
{
 $lsnrType = getListenerType($ENV{LSNR_ORACLE_HOME} , $name ,$machine ,$lsnrVersion);
 EMD_PERL_INFO(" $name : retry listener type check : lsnrType =$lsnrType");
}

# check for IPC listener
my $address = "";
if ( $key eq "" )
{
 EMD_PERL_DEBUG(" $name :: TCP listener");
 $address = "(ADDRESS=(PROTOCOL=TCP)(HOST=$machine)(PORT=$port))";
}
else
{
 EMD_PERL_DEBUG(" $name :: IPC listener");
 $address = "(ADDRESS=(PROTOCOL=IPC)(KEY=$key))";
}

EMD_PERL_DEBUG(" $name :: Adress to ping is $address");

my $command = "";
if ( $lsnrType eq "SCAN" )
{
 $command = "services $name";
}
else
{
 $command = "services $address";
}

my $r;
eval {
 $r = getResultNew( $executable, $command, $listenerFile, $name, $pswd );
};
if ($@)
{
 print STDERR "em_error=could not execute lsnrctl for $ENV{LSNR_NAME}\n";
 exit(-1);
}

#if (!($r = `$cmd services "$address"`)) {
#    print "em_error=could not execute lsnrctl for $ENV{LSNR_NAME}\n";
#    exit;
#}

my $established = 0;
my $refused     = 0;
my @res1;
my @res2;
my @error_parse;

#check for errors:
@error_parse = split( m/TNS-/, $r );
if ( scalar(@error_parse) > 1 )
{
 $r =~ s/^\s*|\s*&//g;
 $r =~ s/\n/ /g;

 #6217209: Strip timestamp info from em_error
 #to prevent multiple uploads of errors to OMS
 #for consecutive failures of this metric.
 my $val1;
 my @rP = split( m/Production/, $r );
 if ( $rP[1] eq "" )
 {
  @rP = split( m/Beta/, $r );
  $val1 = $rP[0] . "Beta ";
 }
 else
 {
  $val1 = $rP[0] . "Production ";
 }
 my @rC = split( m/Copyright/, $rP[1] );
 my $val2 = "Copyright" . $rC[1];
 $r = $val1 . $val2;

 print STDERR "em_error=$r\n";
 exit(-1);
}

#loop through the results
my @res = split( m/established/, $r );
for ( my $i = 1 ; $i < ( scalar @res ) ; $i++ )
{
 @res1 = split( m/:/,  $res[$i] );
 @res2 = split( m/\s/, $res1[1] );
 $established += $res2[0];
 @res2 = split( m/\s\n/, $res1[2] );
 $refused += $res2[0];
}

EMD_PERL_DEBUG("$name :::: em_result=$established|$refused\n");
print "em_result=$established|$refused\n";

