#!/usr/local/bin/perl
#
# $Header: emdb/sysman/admin/scripts/lsnrCmdStatus.pl /st_emgc_pt-12.1.0.4pg/2 2012/02/01 05:28:04 prjaiswa Exp $
#
# lsnrCmdStatus.pl
#
# Copyright (c) 2004, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      lsnrCmdStatus.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    prjaiswa    01/11/12 - dyn prop fix
#    prjaiswa    01/11/12 - scan check fix :use machine check instead of port
#    hpalitan    07/20/11 - Bug #12764760
#    mappusam    09/17/10 - bug-9934831 fix
#    prjaiswa    04/08/10 - moving scan check to listenerUtil
#    prjaiswa    09/15/09 - lrg 4156608
#    prjaiswa    08/21/09 - bug 8686293 - adding check for scan listeners
#    prjaiswa    05/29/08 - listener password enh
#    prjaiswa    05/12/08 - XbranchMerge prjaiswa_bug-6438597 from main
#    dsukhwal    06/30/05 - support flood control for all policies
#    dkjain      06/27/05 - Adding check for oms ver
#    dsukhwal    05/02/05 - connect to complete listener address
#    dsukhwal    01/07/05 - Fix lsnr_default_name
#    rmadampa    11/29/04 - fix for log_status to work with non-default
#                           listeners, change to getResult to support
#                           this
#    dkjain      11/07/04 - Changing property string value to old value
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
#
#    Implementation
#    Invoke the lsnrctl with the 'show log_status' command
#    Capture the setting for the parameter and print it out
#    as em_result=<param_setting>|<Value>.
use strict;
require "semd_common.pl";
require "db/net/listenerUtil.pl";
require "db/esaUtils.pl";

$ENV{ORACLE_HOME} = $ENV{LSNR_ORACLE_HOME};
$ENV{TNS_ADMIN}   = $ENV{LSNR_ORA_DIR};
set_lib_path( $ENV{LSNR_ORACLE_HOME} );

my $machine      = $ENV{LSNR_MACHINE};
my $port         = $ENV{LSNR_PORT};
my $pswd         = $ENV{LSNR_PASSWORD};
my $key          = $ENV{LSNR_KEY};
my $name         = $ENV{LSNR_NAME};
my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $executable   = $ENV{LSNR_ORACLE_HOME} . "/bin/lsnrctl";
my $lsnrType     = $ENV{LSNR_TARGET_SUBTYPE};
my $lsnrVersion  = $ENV{LSNR_TARGET_VERSION};

EMD_PERL_DEBUG(" $name :: ####### lsnrCmdStatus.pl called ###########");
EMD_PERL_DEBUG(" $name :: LSNR_PORT is $port");
EMD_PERL_DEBUG(" $name :: LSNR_KEY is $key");
EMD_PERL_INFO(" $name :: listener subtype is $lsnrType");
EMD_PERL_INFO(" $name :: listener version is $lsnrVersion");

# check for listener type
# retry only if type info was unavailable at agent start up
if ( $lsnrType eq "UNKNOWN" )
{
 $lsnrType = getListenerType($ENV{LSNR_ORACLE_HOME} , $name ,$machine ,$lsnrVersion);
 EMD_PERL_INFO(" $name : retry listener type check : lsnrType =$lsnrType");
}

# check for IPC listener
my $address = "";
if ( $key eq "" )
{
 EMD_PERL_DEBUG(" $name :: TCP listener");
 $address = "(ADDRESS=(PROTOCOL=TCP)(HOST=$machine)(PORT=$port))";
}
else
{
 EMD_PERL_DEBUG(" $name :: IPC listener");
 $address = "(ADDRESS=(PROTOCOL=IPC)(KEY=$key))";
}

EMD_PERL_DEBUG(" $name :: Adress to ping is $address");

my $oms_ver = $ENV{OMS_VERSION};

if ( !( $oms_ver =~ "10.1" ) )
{
 lsnr_default_name();
}    #upload only for 10gR2 n onwards
lsnr_log_status();
lsnr_pwd_status();

sub lsnr_default_name
{
 my $maxRows = $ENV{'DEFNAMEMAX'};
 if ( !compareNegInf( 0, $maxRows ) )
 {
  return;
 }

 my @commands = ();
 if ( $lsnrType eq "SCAN" )
 {
  @commands = ( "set current_listener $name", "status" );
 }
 else
 {
  @commands = ( "set current_listener $address", "status" );
 }

 my $command = \@commands;
 my $result;
 eval {
  $result = getResultNew( $executable, $command, $listenerFile, $name, $pswd );
 };

 if ($@)
 {
  EMD_PERL_DEBUG("$name :::: em_error=Failed to run lsnrctl\n");
  print "em_error=Failed to run lsnrctl\n";
  exit;
 }

 my $curr_listener = " ";

## parse result
 my @info = split( /\n/, $result );
 if ( $#info < 0 )
 {
  EMD_PERL_DEBUG("$name :::: em_error=Failed to run lsnrctl, result=$result\n");
  print "em_error=Failed to run lsnrctl, result=$result\n";
  exit;
 }
 my $property = "lsnr_default_name";
 my $line;
 my $i = 0;
 foreach $line (@info)
 {
  if ( $line =~ /^*TNS-12541/i )
  {
   print "em_error=Failed to run lsnrctl, result=$result\n";
   exit;
  }

  if ( $line =~ /^(\s*)Alias(\s+)(.*)/i )
  {
   $curr_listener = $3;
   last;
  }
 }
 EMD_PERL_DEBUG("$name ::: em_result=$property=$curr_listener\n");
 print "em_result=$property=$curr_listener=NA\n";
}

sub lsnr_log_status
{
 my $maxRows = $ENV{'LOGSTATMAX'};
 if ( !compareNegInf( 0, $maxRows ) )
 {
  return;
 }

 my @command = ();
 if ( $lsnrType eq "SCAN" )
 {
  @command = ( "set current_listener $name", "show log_status" );
 }
 else
 {
  @command = ( "set current_listener $address", "show log_status" );
 }

 my $result;
 if ( isExecutionPossible( \@command ) )
 {
  eval {
   $result =
     getResultNew( $executable, \@command, $listenerFile, $name, $pswd );
  };

  if ($@)
  {
   print "em_error=Failed to run lsnrctl\n";
   exit;
  }

  my $log_status = " ";

## parse result
  my @info = split( /\n/, $result );
  if ( $#info < 0 )
  {
   print "em_error=Failed to run lsnrctl, result=$result\n";
   exit;
  }

  my $line;
  foreach $line (@info)
  {
   if ( $line =~ /^*TNS-12541/i )
   {
    print "em_error=Failed to run lsnrctl, result=$result\n";
    exit;
   }

   if ( $line =~ /^*parameter \"log_status\" set to\s+(.*)/i )
   {
    $log_status = $1;
    last;
   }
  }
  EMD_PERL_DEBUG("$name ::: em_result=loggingStatus=$log_status\n");
  print "em_result=loggingStatus=$log_status=NA\n";
 }
}

sub lsnr_pwd_status
{
 my $maxRows = $ENV{'PWDMAX'};
 if ( !compareNegInf( 0, $maxRows ) )
 {
  return;
 }

 my $command = "";
 if ( $lsnrType eq "SCAN" )
 {
  $command = "status $name";
 }
 else
 {
  $command = "status $address";
 }
 my $result;

 eval {
  $result = getResultNew( $executable, $command, $listenerFile, $name, $pswd );
 };
 if ($@)
 {
  print "em_error=Failed to run lsnrctl\n";
  exit;
 }

 my $sec_status = " ";

## parse result
 my @info = split( /\n/, $result );
 if ( $#info < 0 )
 {
  print "em_error=Failed to run lsnrctl, result=$result\n";
  exit;
 }

 my $line;
 foreach $line (@info)
 {
  if ( $line =~ /^*TNS-12541/i )
  {
   print "em_error=Failed to run lsnrctl, result=$result\n";
   exit;
  }

  if ( $line =~ /^\s*Security\s+(.*)/i )
  {
   $sec_status = $1;
   last;
  }
 }

 #
 # The 10g version of the 'lsnrctl status' produces different output
 # than it did in prior versions. We will convert the new format to
 # match the older format
 #
 if ( $sec_status =~ /^\s*ON:\s*Local/i )
 {
  $sec_status = "OFF";
 }
 else
 {
  if ( $sec_status =~ /^\s*ON:\s*Pass/i )
  {
   $sec_status = "ON";
  }
 }
 EMD_PERL_DEBUG("$name :::: em_result=listenerPwd=$sec_status\n");
 print "em_result=listenerPwd=$sec_status=NA\n";
}

