#!/usr/local/bin/perl
#
# $Header: emdb/sysman/admin/scripts/lsnr_ports_ecm.pl /st_emgc_pt-12.1.0.4pg/2 2012/02/01 05:28:05 prjaiswa Exp $
#
# lsnr_ports_ecm.pl
#
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      lsnr_ports_ecm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    prjaiswa    01/11/12 - dyn prop fix
#    prjaiswa    01/11/12 - scan check fix :use machine check instead of port
#    prjaiswa    05/24/11 - bug 12561317
#    ajdsouza    04/26/10 - added machine name
#    prjaiswa    04/01/10 - ECM port collection for listener
#    prjaiswa    04/01/10 - Creation
#
use strict;
use Socket;
require "semd_common.pl";
require has::HasCluster;
require "db/net/listenerUtil.pl";

$ENV{ORACLE_HOME} = $ENV{LSNR_ORACLE_HOME};
$ENV{TNS_ADMIN}   = $ENV{LSNR_ORA_DIR};

my $machine      = $ENV{LSNR_MACHINE};
my $port         = $ENV{LSNR_PORT};
my $key          = $ENV{LSNR_KEY};
my $pswd         = $ENV{LSNR_PASSWORD};
my $name         = $ENV{LSNR_NAME};
my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $executable   = $ENV{LSNR_ORACLE_HOME} . "/bin/lsnrctl";
my $lsnrType     = $ENV{LSNR_TARGET_SUBTYPE};
my $lsnrVersion  = $ENV{LSNR_TARGET_VERSION};

EMD_PERL_DEBUG(" ####### lsnr_ports_ecm.pl called for $name ###########");
EMD_PERL_DEBUG(" $name :: listener subtype is $lsnrType");
EMD_PERL_DEBUG(" $name :: listener version is $lsnrVersion");

# check for listener type
# retry only if type info was unavailable at agent start up
if ( $lsnrType eq "UNKNOWN" )
{
 $lsnrType = getListenerType($ENV{LSNR_ORACLE_HOME} , $name ,$machine ,$lsnrVersion);
 EMD_PERL_INFO(" $name : retry listener type check : lsnrType =$lsnrType");
}

# check for IPC listener
my $address = "";
if ( $key eq "" )
{
 $address = "(ADDRESS=(PROTOCOL=TCP)(HOST=$machine)(PORT=$port))";
}
else { $address = "(ADDRESS=(PROTOCOL=IPC)(KEY=$key))"; }

my $command = "";
if ( $lsnrType eq "SCAN" )
{
 $command = "status $name";
}
else
{
 $command = "status $address";
}

my $result;
eval {
 $result = getResultNew( $executable, $command, $listenerFile, $name, $pswd );
};

if ($@)
{
 print STDERR "em_error=Failed to run lsnrctl\n";
 exit(-1);
}

my @databases;

## parse result
my @info = split( /\n/, $result );
my $line;
foreach $line (@info)
{

 if ( $line =~ /^\s*\(DESCRIPTION=.*/i )
 {
  EMD_PERL_DEBUG(" $name :: line = $line\n");
 }
 else
 {
  next;
 }

 my $this_host;
 my $this_port;
 my $this_protocol;

 if ( $line =~ /^.*HOST=([a-zA-Z0-9.-]+)/i )
 {
  $this_host = $1;
  $this_host = gethostbyaddr( inet_aton($this_host), AF_INET );
 }
 next unless $this_host;

 if ( ( $line =~ /^.*PORT=(\d*)/i ) )
 {
  $this_port = $1;
 }
 next unless $this_port;

 if ( $line =~ /^.*PROTOCOL=(\w+)/i )
 {
  $this_protocol = $1;
 }
 next unless $this_protocol;

 my $add = 1;
 my $address;
 my @addresses;
 my $this_address = $this_host . "," . $this_port . "," . $this_protocol;
 foreach $address (@addresses)
 {
  EMD_PERL_DEBUG(" $name :: address  = $address\n");
  if ( lc($address) eq lc($this_address) )
  {
   $add = 0;
   last;
  }
 }

 if ($add)
 {
  EMD_PERL_DEBUG(
       "$name :: host=$this_host port= $this_port protocol= $this_protocol\n" );
  print "em_result=$this_host|$this_port|$this_protocol\n";
  push( @addresses, $this_address );
 }
}

