# Copyright (c) 2001, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#     lsnr_pwd_status.pl
#
#    DESCRIPTION
#     collect listener's security status
#
#    MODIFIED    (MM/DD/YY)
#     prjaiswa    05/29/08 - password listener enh
#     rmadampa    03/02/04 - fix for bug 3469156, removed OS-specific path setting
#     hmulling    01/28/04 - Support 10g new output 
#     rmadampa    09/23/03 - Added new tests for lsnr metric colln error condn 
#                            cases and related fixes in fetchlet scripts 
#     rmadampa    09/23/03 - 
#     rmadampa    09/07/03 - 
#     eujang      09/04/03 - eujang_esm_init_no_intgr 
#     rmadampa    08/04/03 - Created
#
# Summary
#    Print out alias name of the listener instance along with a description 
#    if the listener is not password protected
#
# Implementation
#    Invoke the lsnrctl with the 'status <lsnr_name>' command
#    Capture the setting for the Security parameter and print it out
#	 as em_result=listenerPwd=<lsnr_name>.

use strict;
require "semd_common.pl";
require "db/net/listenerUtil.pl";

$ENV{ORACLE_HOME} = $ENV{LSNR_ORACLE_HOME};

set_lib_path ($ENV{LSNR_ORACLE_HOME});
$ENV{TNS_ADMIN} = $ENV{LSNR_ORA_DIR};

my $machine = $ENV{LSNR_MACHINE};
my $port = $ENV{LSNR_PORT};
my $name = $ENV{LSNR_NAME};
my $pswd = $ENV{'LSNR_PASSWORD'};

my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $executable= $ENV{LSNR_ORACLE_HOME}."/bin/lsnrctl";
my $address="(ADDRESS=(PROTOCOL=TCP)(HOST=$machine)(PORT=$port))";
my $command = "status $name";

my $result ;

eval
{
 $result = getResultNew($executable,$command,$listenerFile,$name,$pswd);
};
if($@)
{
    print "em_error=Failed to run lsnrctl\n";
    exit;
}


my $sec_status = " ";

## parse result
my @info = split(/\n/, $result);
if ($#info < 0)
{
    print "em_error=Failed to run lsnrctl, result=$result\n";
    exit;
}

my $line;
foreach $line (@info)
{
    if ($line =~ /^*TNS-12541/i)
    {
        print "em_error=Failed to run lsnrctl, result=$result\n";
        exit;
    }
    
    if ($line =~ /^\s*Security\s+(.*)/i)
    {
        $sec_status = $1;
        last;
    }
}

#
# The 10g version of the 'lsnrctl status' produces different output
# than it did in prior versions. We will convert the new format to
# match the older format
#
if ($sec_status =~ /^\s*ON:\s*Local/i) 
{
    $sec_status = "OFF";
}
else 
{
    if ($sec_status =~ /^\s*ON:\s*Pass/i) 
    {
        $sec_status = "ON";
    }
}

print "em_result=listenerPwd=$sec_status\n";  
