#!/usr/local/bin/perl
#
# $Header: emdb/sysman/admin/scripts/lsnr_services_ecm.pl /st_emgc_pt-12.1.0.4pg/2 2012/02/01 05:28:05 prjaiswa Exp $
#
# lsnr_services_ecm.pl
#
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      lsnr_services_ecm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    prjaiswa    01/11/12 - dyn prop fix
#    prjaiswa    01/11/12 - scan check fix :use machine check instead of port
#    prjaiswa    05/24/11 - bug 12561317
#    ajdsouza    04/26/10 - added machine name
#    prjaiswa    04/01/10 - ECM services collection for listener
#    prjaiswa    04/01/10 - Creation
#
use strict;
require "semd_common.pl";
require has::HasCluster;
require "db/net/listenerUtil.pl";

EMD_PERL_DEBUG("###### lsnr_services_ecm.pl called ###########");

$ENV{ORACLE_HOME} = $ENV{LSNR_ORACLE_HOME};
$ENV{TNS_ADMIN}   = $ENV{LSNR_ORA_DIR};

my $machine      = $ENV{LSNR_MACHINE};
my $port         = $ENV{LSNR_PORT};
my $key          = $ENV{LSNR_KEY};
my $pswd         = $ENV{LSNR_PASSWORD};
my $name         = $ENV{LSNR_NAME};
my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $executable   = $ENV{LSNR_ORACLE_HOME} . "/bin/lsnrctl";
my $lsnrType     = $ENV{LSNR_TARGET_SUBTYPE};
my $lsnrVersion  = $ENV{LSNR_TARGET_VERSION};

EMD_PERL_DEBUG(" $name :: listener subtype is $lsnrType");
EMD_PERL_DEBUG(" $name :: listener version is $lsnrVersion");

# check for listener type
# retry only if type info was unavailable at agent start up
if ( $lsnrType eq "UNKNOWN" )
{
 $lsnrType = getListenerType($ENV{LSNR_ORACLE_HOME} , $name ,$machine ,$lsnrVersion);
 EMD_PERL_INFO(" $name : retry listener type check : lsnrType =$lsnrType");
}

# check for IPC listener
my $address = "";
if ( $key eq "" )
{
 $address = "(ADDRESS=(PROTOCOL=TCP)(HOST=$machine)(PORT=$port))";
}
else
{
 $address = "(ADDRESS=(PROTOCOL=IPC)(KEY=$key))";
}

my $command = "";
if ( $lsnrType eq "SCAN" )
{
 $command = "status $name";
}
else
{
 $command = "status $address";
}

my $result;

eval {

 $result = getResultNew( $executable, $command, $listenerFile, $name, $pswd );

};
if ($@)
{
 print STDERR "em_error=Failed to run lsnrctl\n";
 exit(-1);
}

my $find = 0;
my @databases;
my @srvcdatabases;

######## parse result ############

my @info = split( /\n/, $result );
my $line;
foreach $line (@info)
{
 if ( !$find )
 {
  if ( $line =~ /^\s*Services Summary/i )
  {
   $find = 1;
  }
 }
 else    # parse database sids/services
 {
  if (    ( $line =~ /^\s+Instance\s+\"(.*)\"/i )
       || ( $line =~ /^\s+(.*?)\s+has.*handler/i ) )
  {
   EMD_PERL_DEBUG(" $name :  sid  : $1 \n");
   my $sid = $1;
   if ( !( $sid =~ /extproc/i ) )
   {
    my $add = 1;
    my $element;
    foreach $element (@databases)
    {
     if ( lc($element) eq lc($sid) )
     {
      $add = 0;
      last;
     }
    }
    if ($add)
    {
     EMD_PERL_DEBUG(" $name result :: em_result=$sid|$machine|Y\n");
     print "em_result=$sid|$machine|Y\n";
     push( @databases, $sid );
    }
   }
  }
  elsif ( ( $line =~ /^\s+Service\s+\"(.*)\"/i ) )
  {
   EMD_PERL_DEBUG(" $name service : $1 ");
   my $service = $1;
   if ( !( $service =~ /extproc/i ) )
   {
    my $add = 1;
    my $element;
    foreach $element (@srvcdatabases)
    {
     if ( lc($element) eq lc($service) )
     {
      $add = 0;
      last;
     }
    }
    if ($add)
    {
     EMD_PERL_DEBUG(" $name result :: em_result=$service|$machine|N\n");
     print "em_result=$service|$machine|N\n";
     push( @srvcdatabases, $service );
    }
   }

  }
 }
}
