#  $Header: emdb/sysman/admin/scripts/lsnr_status.pl /st_emgc_pt-12.1.0.4pg/2 2012/02/01 05:28:04 prjaiswa Exp $
#
# Copyright (c) 2001, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#     lsnr_status.pl
#
#    DESCRIPTION
#     get listener status
#
#    MODIFIED    (MM/DD/YY)
#     prjaiswa    01/11/12 - dyn prop fix
#     prjaiswa    01/11/12 - scan check fix :use machine check instead of port
#     prjaiswa    05/24/11 - bug 12561317
#     prjaiswa    04/08/10 - moving scan check to listenerUtil
#     prjaiswa    09/15/09 - lrg 4156608
#     prjaiswa    08/21/09 - bug 8686293 adding scan listener check
#     prjaiswa    05/26/08 - password listener support
#     prjaiswa    05/12/08 - XbranchMerge prjaiswa_bug-6438597 from main
#     dkapoor     01/13/04 - initialize array
#     dkapoor     12/18/03 - use exit -1 on error
#     dkapoor     10/27/03 - fix bug#3219703
#     rasundar    09/04/03 - remove hard coded PATH variable
#     dkapoor     10/04/03 - Fix for bug 3109068
#     dkapoor     05/29/03 - fix 2981271
#     dkapoor     04/23/03 - provide password for status
#     xxu         06/25/02 - remove /usr/local/bin/perl
#     dkapoor     05/08/02 - fix 2359251
#     ancheng     12/20/01 - version number
#     xxu         10/12/01 - set_lib_path (bug 2044793)
#     aaitghez    07/02/01 - set ORACLE_HOME.
#     aaitghez    06/28/01 - oracle_home to lsnr_oracle_home
#     aaitghez    07/02/01 - isntance variable naming convention.
#     njagathe    05/29/01 - Set ORACLE_HOME instead of LSNR_ORACLE_HOME
#     ancheng     04/17/01 - add list of database sids
#     ancheng     04/09/01 - Creation

use strict;
require "semd_common.pl";
require has::HasCluster;
require "db/net/listenerUtil.pl";

$ENV{ORACLE_HOME} = $ENV{LSNR_ORACLE_HOME};
$ENV{TNS_ADMIN} = $ENV{LSNR_ORA_DIR};

my $name = $ENV{LSNR_NAME};
my $machine = $ENV{LSNR_MACHINE};
my $port = $ENV{LSNR_PORT};
my $key = $ENV{'LSNR_KEY'};
my $pswd = $ENV{'LSNR_PASSWORD'};
my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $executable= $ENV{LSNR_ORACLE_HOME}."/bin/lsnrctl";
my $lsnrType = $ENV{LSNR_TARGET_SUBTYPE};
my $lsnrVersion = $ENV{LSNR_TARGET_VERSION};

EMD_PERL_DEBUG(" $name : ####### lsnr_status.pl called ########### versiononly= $ARGV[0]");
EMD_PERL_DEBUG(" $name :: LSNR_PORT is $port");
EMD_PERL_DEBUG(" $name :: LSNR_KEY is $key");
EMD_PERL_INFO(" $name :: listener subtype is $lsnrType");
EMD_PERL_INFO(" $name :: listener version is $lsnrVersion");


if ($ARGV[0] eq "versiononly")
{
  my $lsnrctl_version = getLsnrctlVersion($ENV{ORACLE_HOME});
  if ($lsnrctl_version == 0)
  {
     EMD_PERL_ERROR(" $name : UNABLE TO GET LISTENER VERSION FOR ORACLE HOME = $ENV{ORACLE_HOME}");
     exit(-1);
  }
  else
  {
     EMD_PERL_INFO(" $name : lsnrctl version for ORACLE HOME = $ENV{ORACLE_HOME} is  [$lsnrctl_version]");
     print "em_result=$lsnrctl_version\n";
     exit(0);

  }

}

# check for  listener type
# retry only if type info was unavailable at agent start up
if($lsnrType eq "UNKNOWN")
{
  $lsnrType = getListenerType($ENV{LSNR_ORACLE_HOME} , $name ,$machine ,$lsnrVersion);
  EMD_PERL_INFO(" $name : retry listener type check : lsnrType =$lsnrType");
}
# type check end #


# check for IPC listener
my $address="";
if ($key eq "")
{
  EMD_PERL_DEBUG(" $name :: TCP listener");
  $address="(ADDRESS=(PROTOCOL=TCP)(HOST=$machine)(PORT=$port))";
}
else
{
  EMD_PERL_DEBUG(" $name :: IPC listener");
  $address="(ADDRESS=(PROTOCOL=IPC)(KEY=$key))";
}

EMD_PERL_DEBUG(" $name :: Adress to ping is $address");

my $command ="";
if ($lsnrType eq "SCAN" )
{
  $command = "status $name";
}
else
{
  $command = "status $address";
}
my $result ;

eval
{
  $result = getResultNew($executable,$command,$listenerFile,$name,$pswd);
};
if($@)
{
  print STDERR "em_error=Failed to run lsnrctl\n";
  exit (-1);
}

my $alias = " ";
my $version = " ";
my $version_number = " ";
my $start_date = " ";
my $trace_level = " ";
my $security = " ";
my $snmp = " ";
my $find = 0;
my @databases ;

## parse result
my @info = split(/\n/, $result);
my $line;
foreach $line (@info)
{
  if (!$find)
  {
    if ($line =~ /^\s*Alias\s+(.*)/i)
    {
      $alias = $1;
    }
    elsif ($line =~ /^\s*Version\s+(.*)/i)
    {
      $version = $1;
      if($version =~ /Version\s+(.*?)\s+/i)
      {
        $version_number = $1;
      }
    }
    elsif ($line =~ /^\s*Start Date\s+(.*)/i)
    {
      $start_date = $1;
    }
    elsif ($line =~ /^\s*Trace Level\s+(.*)/i)
    {
      $trace_level = $1;
    }
    elsif ($line =~ /^\s*Security\s+(.*)/i)
    {
      $security = $1;
    }
    elsif ($line =~ /^\s*SNMP\s+(.*)/i)
    {
      $snmp = $1;
    }
    elsif ($line =~ /^\s*Services Summary/i)
    {
      $find = 1;
    }
  }
  else # parse database sids
  {
    if ( ($line =~ /^\s+Instance\s+\"(.*)\"/i ) || ($line =~ /^\s+(.*?)\s+has.*handler/i) )
    {
      my $sid = $1;
      if (!($sid =~ /extproc/i) )
      {
        my $add = 1;
        my $element;
        foreach $element (@databases)
        {
          if (lc($element) eq lc($sid) )
          {
            $add = 0;
            last;
          }
        }
        if ($add)
        {
          push(@databases, $sid);
        }
      }
    }
  }
}

# construct sid list
my $list;
if (scalar(@databases) >= 1)
{
  $list = $databases[0];
  my $i;
  for ($i = 1; defined($databases[$i]); $i++)
  {
    $list = $list . "," . $databases[$i];
  }
}
else
{
  $list = " ";
}
EMD_PERL_DEBUG(" $name :: THE RESULT is em_result=$address|$alias|$version_number|$start_date|$trace_level|$security|$snmp|$list");
print "em_result=$address|$alias|$version_number|$start_date|$trace_level|$security|$snmp|$list\n";

