# $Header: emdb/sysman/admin/scripts/lsnrresp.pl /st_emgc_pt-12.1.0.4pg/2 2012/02/01 05:28:04 prjaiswa Exp $
#
# lsnrresp.pl
#
# Copyright (c) 2001, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      lsnrresp.pl
#
#    DESCRIPTION
#      Returns the status of an oracle listener.  If there is an tnsping
#      failure the return is "em_result= |0" otherwise
#      "em_result=<num millisecs>|1"
#
#    NOTES
#
#
#    MODIFIED   (MM/DD/YY)
#    prjaiswa    01/10/12 - dynamic prop fix
#    prjaiswa    01/06/12 - is scan fix for machine ip
#    prjaiswa    05/24/11 - bug 12561317
#    prjaiswa    04/08/10 - moving scan check to listenerUtil
#    prjaiswa    09/15/09 - lrg 4156608
#    prjaiswa    08/21/09 - 8686293 - Scan listener check added
#    prjaiswa    10/17/08 - bug 7492002
#    prjaiswa    08/12/08 - bug 5068847
#    prjaiswa    07/30/08 - bug 4963567
#    prjaiswa    05/29/08 - password listener enh
#    prjaiswa    05/12/08 - XbranchMerge prjaiswa_bug-6438597 from main
#    vivsharm    07/06/05 - for 4433810
#    dkapoor     12/18/03 - return em_result with status down on error
#    dkapoor     10/31/03 - fixbug#2823971
#    dkapoor     10/07/02 - use generic perl instead of tail
#    dkapoor     07/18/02 - fix 2296998
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    xxu         10/12/01 - set_lib_path (bug 2044793)
#    njagathe    10/04/01 - Return down if unable to tnsping listener
#    aaitghez    07/06/01 - die when error.
#    aaitghez    07/02/01 - error TNS check.
#    aaitghez    07/02/01 - set ORACLE_HOME
#    aaitghez    07/02/01 - instance variables naming convention
#    aaitghez    06/22/01 - oracle home naming.
#    aaitghez    06/19/01 - removing debug calls.
#    aaitghez    06/01/01 - adding debug and making common.
#    aaitghez    05/29/01 - making NLS changes.
#    aholser     05/17/01 - fix compilation error
#    aaitghez    05/16/01 - fixing syntax error.
#    aaitghez    05/14/01 - replacement for lsnrresp.tcl
#    aaitghez    05/14/01 - Creation
#

use strict;
require "semd_common.pl";
require "db/net/listenerUtil.pl";

$ENV{ORACLE_HOME} = $ENV{LSNR_ORACLE_HOME};
$ENV{TNS_ADMIN}   = $ENV{LSNR_ORA_DIR};

my $port         = $ENV{LSNR_PORT};
my $name         = $ENV{LSNR_NAME};
my $key          = $ENV{LSNR_KEY};
my $OSNAME       = get_osType();
my $IsWin32      = ( $OSNAME eq 'WIN' );
my $pswd         = $ENV{LSNR_PASSWORD};
my $machine      = $ENV{LSNR_MACHINE};
my $listenerFile = $ENV{LSNR_ORA_DIR} . "/listener.ora";
my $executable   = $ENV{LSNR_ORACLE_HOME} . "/bin/lsnrctl";
my $lsnrType     = $ENV{LSNR_TARGET_SUBTYPE};
my $lsnrVersion  = $ENV{LSNR_TARGET_VERSION};

EMD_PERL_DEBUG(" $name :: LSNR_PORT is $port");
EMD_PERL_DEBUG(" $name :: LSNR_KEY is $key");
EMD_PERL_DEBUG(" $name :: platform is $OSNAME");
EMD_PERL_INFO(" $name :: listener subtype is $lsnrType");
EMD_PERL_INFO(" $name :: listener version is $lsnrVersion");

# check for listener type

# retry only if type info was unavailable at agent start up
if ( $lsnrType eq "UNKNOWN" )
{
 $lsnrType = getListenerType($ENV{LSNR_ORACLE_HOME} , $name ,$machine ,$lsnrVersion);
 EMD_PERL_INFO(" $name : retry listener type check : lsnrType =$lsnrType");
}

my $address = "";

# check for IPC listener
if ( $key eq "" )
{
 EMD_PERL_DEBUG(" $name :: TCP listener");
 $address = "(ADDRESS=(PROTOCOL=TCP)(HOST=$machine)(PORT=$port))";
}
else
{
 EMD_PERL_DEBUG(" $name :: IPC listener");
 $address = "(ADDRESS=(PROTOCOL=IPC)(KEY=$key))";
}

my $r;

#Checking for tnsping executable if it exists
if ($IsWin32)
{
 if ( !-x "$ENV{LSNR_ORACLE_HOME}/bin/tnsping.exe" )
 {
  print "em_result=|0|tnsping not found in $ENV{LSNR_ORACLE_HOME}/bin\n";
  exit;
 }

}
else
{
 if ( !-x "$ENV{LSNR_ORACLE_HOME}/bin/tnsping" )
 {
  print "em_result=|0|tnsping not found in $ENV{LSNR_ORACLE_HOME}/bin\n";
  exit;
 }

}

#bug 12561317
my %bkup_path = unset_lib_path_env();
set_lib_path( $ENV{LSNR_ORACLE_HOME} );

if ( !( $r = `$ENV{LSNR_ORACLE_HOME}/bin/tnsping \"$address\"` ) )
{

 EMD_PERL_DEBUG("$name :: em_result=|0|Failed to tnsping $machine\n");
 print "em_result=|0|Failed to tnsping $machine\n";
 revert_original_lib_path_env(%bkup_path);
 exit;
}

#get the last line from the output
my @lines = split /^/m, $r;
$r = $lines[$#lines];

my @error_parse;
my $responseTime;

#check for errors:
@error_parse = split( m/TNS/, $r );

# bug 5068847
if ( ( scalar @error_parse ) > 1 )
{

 if ( !( $r = `$ENV{LSNR_ORACLE_HOME}/bin/tnsping \"$address\"` ) )
 {

  EMD_PERL_DEBUG("$name :: em_result=|0|Failed to tnsping $machine\n");
  print "em_result=|0|Failed to tnsping $machine\n";
  revert_original_lib_path_env(%bkup_path);
  exit;
 }
 else
 {

  #get the last line from the output
  @lines = split /^/m, $r;
  $r = $lines[$#lines];

  #check for errors:
  @error_parse = split( m/TNS/, $r );
 }
}
revert_original_lib_path_env(%bkup_path);

# end bug 5068847
if ( ( scalar @error_parse ) > 1 )
{

 # we got some sort of error
 # note that we parse around TNS because a TNS error
 # will hold this string
 #
 # We assume that the error indicates the listener is down
 $r =~ s/^\s*|\s*&//g;
 $r =~ s/\n/ /g;
 EMD_PERL_DEBUG("$name :: em_result=|0|$r\n");
 print "em_result=|0|$r\n";
 exit;
}
else
{

 # we seem to have a good result
 # lets get the milliseconds
 # the output from a good result will look like this:
 # OK (20 msec)
 # we want the number
 $_ = $r;
 /[0-9]+/;
 $responseTime = $&;
}

#Some Oracle Net process is running at the port validate that its this listener

my $command = "";
if ( $lsnrType eq "SCAN" )
{
 $command = "status $name";
}
else
{
 $command = "status $address";
}

my $result;

eval {
 $result = getResultNew( $executable, $command, $listenerFile, $name, $pswd );
};
if ($@)
{
 EMD_PERL_DEBUG("$name :: em_result=|0|Failed to run lsnrctl\n");
 print "em_result=|0|Failed to run lsnrctl\n";
 exit;
}

my $errorMsg = getErrorIfAny($result);

if ( defined $errorMsg )
{
 @error_parse = split( m/TNS/, $result );
 $result =~ s/^\s*|\s*&//g;
 $result =~ s/\n/ /g;
 EMD_PERL_DEBUG("$name ::: em_result=|0|$result\n");
 print "em_result=|0|$result\n";
 exit;
}

## parse result
my @info = split( /\n/, $result );
if ( $#info < 0 )
{
 EMD_PERL_DEBUG("$name :: em_result=|0|Failed to run lsnrctl\n");
 print "em_result=|0|Failed to run lsnrctl\n";
 exit;
}

if ( isThisListenerRunning( $result, $ENV{LSNR_ORA_DIR}, $name ) )
{
 EMD_PERL_DEBUG("$name :: em_result=$responseTime|1|\n");
 print "em_result=$responseTime|1|\n";
 exit;
}

#print "em_result=|0|listener \"$name\" is not running using \"$listenerFile\" file.\n";

if ( isAnyListenerRunning( $result, $machine, $port, $name ) )
{
 my $currListenerFile = getCurrentListenerOraFile( $result, $name );

 if ( !( $currListenerFile eq "" ) )
 {
  EMD_PERL_DEBUG(
"$name :: em_result=|0|Although a Listener with name \"$name\", is running on this host at port: \"$port\", it was not started using this target\'s \"LISTENER.ORA\" file. CORRECTIVE ACTION: To monitor this \"EM  Listener Target\" with its present configuration, you must stop the currently running listener process, and start it again using the Listener Parameter file: $listenerFile . Alternatively, you can update this target\'s \"LISTENER.ORA Location\" parameter with the location of the currently running Listener, which was started using: $currListenerFile\n"
  );
  print
"em_result=|0|Although a Listener with name \"$name\", is running on this host at port: \"$port\", it was not started using this target\'s \"LISTENER.ORA\" file. CORRECTIVE ACTION: To monitor this \"EM  Listener Target\" with its present configuration, you must stop the currently running listener process, and start it again using the Listener Parameter file: $listenerFile . Alternatively, you can update this target\'s \"LISTENER.ORA Location\" parameter with the location of the currently running Listener, which was started using: $currListenerFile\n";
  exit;
 }
 else
 {
  EMD_PERL_DEBUG(
"$name ::: em_result=|0|A listener process with name \"$name\" is currently running on this host at port:  \"$port\", but it was started without using any Listener Parameter File. CORRECTIVE ACTION: An \"EM  Listener Target\" cannot be configured without specifying a valid \"Listener Parameter File\" location. To monitor this \"EM  Listener Target\" with its present configuration, you must stop the currently running listener , and create an entry for it in the parameter file: $listenerFile . After this is done, you must start the listener again using this updated listener parameter file\n"
  );
  print
"em_result=|0|A listener process with name \"$name\" is currently running on this host at port:  \"$port\", but it was started without using any Listener Parameter File. CORRECTIVE ACTION: An \"EM  Listener Target\" cannot be configured without specifying a valid \"Listener Parameter File\" location. To monitor this \"EM  Listener Target\" with its present configuration, you must stop the currently running listener , and create an entry for it in the parameter file: $listenerFile . After this is done, you must start the listener again using this updated listener parameter file\n";
  exit;
 }
}

EMD_PERL_DEBUG(
"$name ::: lsnrresp :::em_result=|0| The listener \"$name\" is not running using the Listener parameter file: \"$listenerFile\" on Host: \"$machine\" at Port: \"$port\".\n"
);
print
"em_result=|0| The listener \"$name\" is not running using the Listener parameter file: \"$listenerFile\" on Host: \"$machine\" at Port: \"$port\".\n";

