#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/ocmdbinst.pl /st_emdbgc_10.2.0.1.0/3 2009/12/17 09:08:10 glavash Exp $
#
# ocmdbinst.pl
# 
# Copyright (c) 2008, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ocmdbinst.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#      Tests via DBI for the prescence of OCM instrumentation
#      Tests for OCM instrumented in database home
#      Creates marker file for current database with ocm_present status
#      Marker file is agent/state directory
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    glavash     12/11/09 - remove smtp
#    glavash     11/04/09 - bug 8860398 remove raising of error
#    glavash     10/03/08 - add NeedToInstrument column
#    glavash     09/17/08 - script for ocm inst metric
#    glavash     09/17/08 - Creation
#
use strict;
use Oraperl;
use DBI;

require "emd_common.pl";
require "semd_common.pl";

my $ocm_install_sql = "SELECT NVL( "
         ." (SELECT 1 FROM dba_objects "
         ."WHERE owner = 'ORACLE_OCM' "
           ." AND object_name = 'MGMT_DB_LL_METRICS'"
           ." AND object_type = 'PACKAGE BODY') "
         .",0) from DUAL";

my $ocm_install_curs;
my $ocm_instrumented="";
my $ocm_configured=0;

my @fetch_row;

sub isWinOS
{
        my $isWin = 0;
        if($^O =~ /MSWin/i)
        {
                $isWin = 1;
        }
        return $isWin;
}



my        $slash="/";

        if ( isWinOS ) {
                $slash="\\";
        }

#--------------------------------
# Get connection to the database
#--------------------------------
my %stdinArgs = get_stdinvars();

my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
my $username = $stdinArgs{"EM_TARGET_USERNAME"};
my $role = $ENV{EM_TARGET_ROLE};
my $mode = 0;
my $targetGuid = $ENV{EM_TARGET_GUID};
my $oracle_sid = $ENV{EM_TARGET_ORACLE_SID};
my $oracle_home = $ENV{EM_TARGET_ORACLE_HOME};
my $state_root = $ENV{EMSTATE};

if($role =~ /SYSDBA/i)
{
  $mode = 2;
}
elsif($role =~ /SYSOPER/i)
{
  $mode = 4;
}
my $address = $ENV{EM_TARGET_ADDRESS};

my    $lda= DBI->connect('dbi:Oracle:', "$username@".$address , "$password", {ora_session_mode => $mode, RaiseError => 0, PrintError => 0})
         or die (filterOraError("Could not connect to $username/$address: $DBI::errstr\n", $DBI::err));


    register_metric_call($lda);

my $ocm_install_curs = $lda->prepare($ocm_install_sql)
    or die (filterOraError("em_error=prepare($ocm_install_sql): $DBI::errstr\n", $DBI::err));

    $ocm_install_curs->execute()
    or die (filterOraError("em_error=ocm_install_curs->execute(): $DBI::errstr\n", $DBI::err));

   @fetch_row = $ocm_install_curs->fetchrow_array();

   $ocm_instrumented = $fetch_row[0];

#command in case we need to make a status call

my $cmd = $oracle_home  . $slash . "ccr" . $slash . "bin" . $slash . "emCCR status";

my $ocm_file = $oracle_home . $slash . "ccr" . $slash . "bin" . $slash . "emCCR";

  #verify ocm installation in OH of target
   if ( ! -e $ocm_file)
   {
     $ocm_configured = 0;
   }
   else
   {
    $ocm_configured = 1;
   }
my $need_to_instrument = 0;

  # we return need to instrument = 1 if ocm is configured and 
  # and ocm is not instrumented in the database

  if ($ocm_configured == 1 && $ocm_instrumented == 0)
  {
    $need_to_instrument = 1;
  }

my $FH;
my $state_file = $state_root.$slash."sysman".$slash."emd".$slash."state".$slash.$oracle_sid.".DB_ocm";

if (open(FH,"+> $state_file"))
{
    print FH "ocm_instrumented=$ocm_instrumented\n";
    close(FH);
}
else
{
  die ("em_error=couldn't open $state_file");
}

print "em_result=$ocm_instrumented|$ocm_configured|$need_to_instrument\n";

