#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/osm_instance_assoc.pl /st_emgc_pt-12.1.0.4pg/1 2012/09/19 04:07:11 rrarajag Exp $
#
# osm_instance_assoc.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      osm_instance_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rrarajag    08/27/12 - Creation
# 
use ecmAssoc; 

my $oracleHome =  shift(@ARGV);
$oracleHome = $1 if($oracleHome=~/(.*)\/$/);
my $host_name = shift(@ARGV);
my $cmd = $oracleHome.'/bin/olsnodes -l';
my ($err,$output) = getCmdOutput($cmd, $oracleHome);
$cmd = $oracleHome.'/bin/srvctl status asm -S 1 -n '.$output;
($err,$output) = getCmdOutput($cmd,$oracleHome);
if ($output =~ /inst_name\s*=\s*\{(.*?)\}.*?node_name\s*=\s*\{(.*?)\}/i)
{
     $cmd = $oracleHome.'/bin/cemutlo -n';
     ($err,$output) = getCmdOutput($cmd, $oracleHome);
     print ("em_result=".$ecmAssoc::MEMBER_OF."|+ASM_". $output."|osm_cluster|".$host_name);
}
else
{
     print "Not a Cluster ASM\n";
}
sub getCmdOutput
{

    my $oldOH;
    my ($cmd, $envOracleHome) = @_;
    $oldOH = $ENV{ORACLE_HOME};
    if ($envOracleHome ne "")
    {
        $ENV{ORACLE_HOME} = $envOracleHome;
    }
    else
    {
        delete $ENV{ORACLE_HOME};
    }

    my $err = "";
    my $output = "";

    if (open(CMDOUTPUT, "$cmd 2>&1 |"))
    {
        my @outputs = <CMDOUTPUT>;
        $output = join "", @outputs;
        $output =~ s/\n//;
        if (!close(CMDOUTPUT))
        {
            # close error
            if ($output ne "")
            {
               $err = "\"${cmd}\" returned: \"" . $output . "\"";
               $output = "";
            }
            else
            {
               $err = "bad \"$cmd\": $! $?";
            }
        }
    }
    else
    {
        # open error
        $err = "cannot execute \"$cmd\": $!";
    }
    if ($oldOH eq "")
    {
        delete $ENV{ORACLE_HOME};
    }
    else
    {
        $ENV{ORACLE_HOME} = $oldOH;
    }
    ($err, $output);
}
 

