#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/osm_instance_config.pl /st_emgc_pt-12.1.0.4pg/1 2012/09/19 04:07:11 rrarajag Exp $
#
# osm_instance_config.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      osm_instance_config.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rrarajag    08/28/12 - Creation
# 
my $oracleHome   = shift(@ARGV);
my $instance_name = shift(@ARGV);
my $host_name = shift(@ARGV);
my $cmd = $oracleHome.'/bin/sqlplus -V';
my ($err,$output) = getCmdOutput($cmd, $oracleHome);
$output =~ s/SQL\*Plus://;
$output =~ s/^\s+//;$output =~ s/\s+$//;
print "$instance_name|$output|$host_name";    
sub getCmdOutput
{

    my $oldOH;
    my ($cmd, $envOracleHome) = @_;
    $oldOH = $ENV{ORACLE_HOME};
    if ($envOracleHome ne "")
    {
        $ENV{ORACLE_HOME} = $envOracleHome;
    }
    else
    {
        delete $ENV{ORACLE_HOME};
    }

    my $err = "";
    my $output = "";

    if (open(CMDOUTPUT, "$cmd 2>&1 |"))
    {
        my @outputs = <CMDOUTPUT>;
        $output = join "", @outputs;
        $output =~ s/\n//;
        if (!close(CMDOUTPUT))
        {
            # close error
            if ($output ne "")
            {
               $err = "\"${cmd}\" returned: \"" . $output . "\"";
               $output = "";
            }
            else
            {
               $err = "bad \"$cmd\": $! $?";
            }
        }
    }
    else
    {
        # open error
        $err = "cannot execute \"$cmd\": $!";
    }
    if ($oldOH eq "")
    {
        delete $ENV{ORACLE_HOME};
    }
    else
    {
        $ENV{ORACLE_HOME} = $oldOH;
    }
    ($err, $output);
}

