#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/purgetracefile.pl /st_emdbgc_10.2.0.1.0/1 2008/08/04 07:07:37 anosriva Exp $
#
# purgetracefile.pl
# 
# Copyright (c) 2006, 2008, Oracle. All rights reserved.
#
#    NAME
#      purgetracefile.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#     This script will purge the trace files in given pattern
#     whose last modified date is less than given age. 
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    anosriva    07/28/08 - 
#    prapatil    07/08/08 - 
#    ganessub    11/13/06 - Bug 5622272 fix.
#    ganessub    07/05/06 - 
#    armaity     06/25/06 - 
#    ganessub    04/13/06 - Creation.
# 
use strict;
use Time::Local;

require "archivepurge_util.pl";

# Command Line Arguments
my $argnum = @ARGV;

my $trcfiles       = shift(@ARGV);
my $archiveAge = shift(@ARGV);   # number of days older need to be archived
# End Arguments
# Check if timezone exist if not set to UTC as it is required by DateManip module.
my $timez = $ENV{"TZ"};
print "Host Time Zone is : $timez\n";

if ( $timez eq '') {
   print "Warning:Local Timezone is not set on this host, hence UTC is assumed as a timezone.";
   print "        Set TZ environment variable if you want correct timezone.";
   &Date_Init("TZ=UTC");
}

my $file;

#get files based on the pattern
my @files = glob($trcfiles);
my $pcnt = 0;
foreach $file (@files) {
    if (-M $file >= $archiveAge)
    {
           $pcnt = $pcnt + 1;
           print "\n Purging ".$file.".";
           unlink $file;
  
    }
} #end of for

if ($pcnt > 0)
{
   print "Purging of Trace files have been successfully completed.";
}
else
{
   print "No files matched the purge criteria! Hence nothing purged!";
}
