#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/rac/clsInterconn.pl /st_emgc_pt-12.1.0.4pg/1 2012/03/09 05:43:28 ajdsouza Exp $
#
# clsInterconn.pl
# 
# Copyright (c) 2004, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      clsInterconn.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajdsouza    02/28/12 - added env HAS_T_WORK for 12c clusters
#    ajdsouza    02/28/12 - add support for asm and private/asm interconnect types
#    ajdsouza    09/02/10 - added env $ENV{ORA_CSS_VARS}='true'
#    ajdsouza    09/08/09 - Bug# 7510817
#    ajdsouza    09/08/09 - set ORA_CRS_HOME if EM_CRS_TEST_CRS_HOME is set
#    ajdsouza    08/25/09 - added EM_CRS_TEST_CRS_HOME env
#    ajdsouza    08/25/09 - switched from siha::Common to has::Common
#    ajdsouza    12/07/09 - Bug Fix 7686990, added back ORACLE_HOME from Bug Fix# 6723959
#    ajdsouza    09/08/08 - 
#    rsamaved    08/11/08 - work around extra text in parsing
#    ajdsouza    08/09/06 - fix bug 5378241,5184611,5732015
#    xuliu       04/05/05 - using qualified hostname 
#    xuliu       10/07/04 - xuliu_mov_rac_f
#    xuliu       07/08/04 - xuliu_rac_interconn
#    xuliu       07/01/04 - Creation
# 
use strict;
use warnings;
use File::Spec::Functions;
use File::Basename;
use File::Path;
use Data::Dumper;
use locale;
use has::Common;
require "emd_common.pl";

my $oldOH;

BEGIN
{

 use POSIX qw(locale_h);

 my $clocale='C';

 for ( qw ( LC_ALL LC_COLLATE LC_CTYPE LC_TIME LC_NUMERIC LC_MESSAGES LC_MONETARY LANG LANGUAGE ) )
 {
   $ENV{$_}=$clocale;
 }

 setlocale(LC_ALL,$clocale) or warn "WARN:Failed to set locale to $clocale \n ";

 # save ORACLE_HOME and restore it back in END
 $oldOH = $ENV{ORACLE_HOME} if $ENV{ORACLE_HOME};

 # temporarly setting environment only in dev view env
 # this code is not avtive in production
 # !! DO NOT CHANGE THE CLUSTER NAME HERE WHEN YOU
 # CHECK IN AS THIS WILL BREAK REGRESSION
 #
 # IF YOU ARE CREATING A HAS VIEW CREATE IT 
 # WITH VIEW NAME <sa view_name>t
 # e.g. if sa view is sa3114 the has view should be sa3114t
 # the clustername is the has view should be newdb_cluster
 if ( $ENV{ADE_VIEW_ROOT} and not $ENV{HAS_USE_SHIPHOME} )
 {

  if ( $ENV{EM_CRS_TEST_CRS_HOME}  )
  {
    $ENV{ORA_CRS_HOME} =  $ENV{EM_CRS_TEST_CRS_HOME};
  }
  else
  {
    my $advrt;
   $advrt =  $ENV{ADE_VIEW_ROOT};
   $advrt  =~ s/_ag$//;
   $advrt  = $advrt."t";
   $ENV{ORA_CRS_HOME}="$advrt/oracle";
  }

  if ( $ENV{EM_CRS_TEST_CLUSTER_NAME}  )
  {
    $ENV{CSS_CLUSTERNAME}=$ENV{EM_CRS_TEST_CLUSTER_NAME};
  }
  else
  {
    $ENV{CSS_CLUSTERNAME}='newdb_cluster';
  }

  $ENV{CRS_HOME}="$ENV{ORA_CRS_HOME}";
  $ENV{CV_HOME}="$ENV{CRS_HOME}";
  $ENV{T_HAS_WORK}="$ENV{CRS_HOME}/has_work";
  $ENV{OCR_ROOT}="$ENV{CRS_HOME}/has_work/data.ocr";
  $ENV{OCR_LOC}="$ENV{CRS_HOME}/has_work/ocr.loc";
  $ENV{OLR_LOC}="$ENV{CRS_HOME}/has_work/olr.loc";
  $ENV{OCR_DEVELOPER_ENV}='TRUE';
  $ENV{HAS_DEVELOPMENT_ENVIRONMENT}='TRUE';
  $ENV{CV_JDKHOME}="$ENV{CRS_HOME}/jdk15";
  $ENV{ORA_ENVIRON_OPTS}='true';
  $ENV{ORA_CSS_VARS}='true';

  my $libs = "$ENV{CRS_HOME}/lib:$ENV{CRS_HOME}/has/lib:$ENV{CRS_HOME}/opsm/lib";

  $ENV{LD_LIBRARY_PATH}="$libs:$ENV{LD_LIBRARY_PATH}" if $ENV{LD_LIBRARY_PATH};
  $ENV{LD_LIBRARY_PATH}="$libs" unless $ENV{LD_LIBRARY_PATH};

  $ENV{PATH}="$ENV{CRS_HOME}/bin:$ENV{CRS_HOME}/has/bin:$ENV{PATH}" if $ENV{PATH};
  $ENV{PATH}="$ENV{CRS_HOME}/bin:$ENV{CRS_HOME}/has/bin" unless $ENV{PATH};

 }

 # enable autoflush as POSIX:_exit does not flush before exit
 $|=1;

}

my %crsidx;

my $crsHome = $ENV{EM_CRS_HOME};
my $o;

$crsHome = $ENV{CRS_HOME} unless $crsHome;

has::Common::print_warn_message("clsInterconn.pl:Ignore cluster interconnect metric: no CRS_HOME is found in the cluster\n")
 and exit 0 unless $crsHome and $crsHome !~ /#CRS_HOME#/;


my $tmppath = catfile($crsHome,'bin');
$ENV{PATH}="$tmppath:$ENV{PATH}";
my %command_args = (exit_failure_list => [()]);

# bug 6723959 
$oldOH = $ENV{ORACLE_HOME} if $ENV{ORACLE_HOME};
$ENV{ORACLE_HOME} = $crsHome if $crsHome;
$o = has::Common::runsystemcommand('oifcfg getif','',\%command_args);

has::Common::exit_fail
 ("clsInterconn.pl:Failed executing oifcfg getif")
  if $command_args{command_return_status};

$o =~ s/^\s+|\s+$// if $o;
chomp($o) if $o;

has::Common::exit_fail('clsInterconn.pl:Failed to get any results from oifcfg getif')
 unless $o;

my @lines = split /\n/, $o;

for my $ln (@lines) 
{
    # $ln is in format of "if_name  subnet  scope  type"
    # e.g. <xxxxx:> eth0  10.10.10.0  global  cluster_interconnect

    $ln =~ s/^\s+|\s+$//g;

    next unless $ln;

    next if $ln =~ /PRIF\-/;

    # remove the Only in GPNp prefied to the interface name
    $ln =~ s/Only in GPnP//ig;
    $ln =~ s/^\s+|\s+$//g;
    $ln =~ s/^://;
    $ln =~ s/^\s+|\s+$//g;

    my @attrs = split /  /, $ln;

    has::Common::print_warn_message("clsInterconn.pl:Unknown format of the output from oifcfg getif: $ln")
      and next unless scalar(@attrs) >= 2;

    has::Common::print_warn_message("clsInterconn.pl:Unknown format of the output from oifcfg getif: $ln")
      and next if scalar(@attrs) >= 6;

    if ($attrs[2] !~ /global/i)
    {
        ($attrs[2]) = gethostbyname($attrs[2]); # fully qualified host name
    }

    $attrs[3] =~ s/^\s+|\s+$// if $attrs[3];

   
    # interfacet type public is public
    #                 cluster_interconnect is private
    #                 asm is asm
    #                 cluster_interconnect,asm is private
    #            eles ''
    if ( not $attrs[3] )
    {
       $attrs[3] = '';
    }
    elsif ( $attrs[3] =~ /cluster_interconnect/i and $attrs[3] =~ /asm/i )
    {
        $attrs[3] = 'NO';
    }
    elsif ( $attrs[3] =~ /cluster_interconnect/i )
    {
        $attrs[3] = 'NO';
    }
    elsif ( $attrs[3] =~ /asm/i)
    {
        $attrs[3] = 'ASM';
    }
    elsif ( $attrs[3] =~ /public/i)
    {
        $attrs[3] = 'YES';
    }
    else
    {
        $attrs[3] = '';
    }

    EMD_PERL_DEBUG("clsInterconn.pl:$attrs[0]|$attrs[2]|$attrs[1]||$attrs[3]|");

    # make sure no duplicate keys
    next if $crsidx{"$attrs[0]_$attrs[2]"};

    $crsidx{"$attrs[0]_$attrs[2]"} = 1;

    has::Common::print_warn_message("clsInterconn.pl: Failed to get interface name from $ln")
     unless $attrs[0];

    has::Common::print_warn_message("clsInterconn.pl: Failed to get node name from $ln")
     unless $attrs[2];

    has::Common::print_warn_message("clsInterconn.pl: Failed to get subnet from $ln")
     unless $attrs[1];

    has::Common::print_warn_message("clsInterconn.pl: Failed to get if interface type is public/private from $ln")
     unless $attrs[3];

    # output in format of if_name|node|subnet|ip|public
    print "em_result=$attrs[0]|$attrs[2]|$attrs[1]||$attrs[3]\n";
}

exit 0;


END
{

  $ENV{ORACLE_HOME} = $oldOH if $oldOH;

  has::Common::save_systemcmdoutput() or
   warn "clsInterconn.pl:Failed to save the test results from clsInterconn.pl\n";

}
