#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/rac/clusterconfig.pl /st_emdbgc_10.2.0.1.0/3 2008/08/27 18:36:50 rsamaved Exp $
#
# clusterconfig.pl
# 
# Copyright (c) 2002, 2008, Oracle. All rights reserved.
#
#    NAME
#      clusterconfig.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      Script that calls cemutlo or cemutls to get cluster
#      version and os info as the dynamic properties of a
#      cluster target.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rsamaved    08/11/08 - 
#    gapadman    07/31/08 - 
#    ajdsouza    01/30/07 - fix bug 5732015,573211
#    xuliu       10/21/05 - bug 4667678 
#    xuliu       11/18/04 - clusterName
#    xuliu       10/07/04 - xuliu_mov_rac_f
#    xuliu       09/13/04 - active crs version 
#    xuliu       06/28/04 - active crs version, crs software ver, etc 
#    xuliu       11/05/03 - EMDROOT for 92 cluster 
#    xuliu       06/30/03 - use CRS_HOME to locate cemutl
#    xuliu       01/20/03 - log
#    xuliu       11/20/02 - uname to get OS inf
#    xuliu       11/15/02 - xuliu_nov_06
#    xuliu       11/12/02 - Creation
# 
use strict;
use warnings;
use siha::Common;
use File::Spec::Functions;
use File::Basename;
use File::Path;
require "emd_common.pl";
require "semd_common.pl";

my $rootDir = $ENV{EM_CRS_HOME} if $ENV{EM_CRS_HOME};
$rootDir = $ENV{CRS_HOME} if $ENV{CRS_HOME} and not $rootDir;

my $isVendorCW = 1;
my $eonsPort=0;
my $scanName='NA';
my $scanPort=0;
my $version;
my $patch;
my $errMsg;
my $vendor;
my $clsName;
my $o;
my $oldOH;
my $CRSVersion;

if ( $rootDir and $rootDir !~ /#CRS_HOME#/ )
{

    #There is a CRS home in this cluster
    $clsName = siha::Common::getClusterName($ENV{EMDROOT}, $rootDir);

    # bug 4667678
    $oldOH = $ENV{ORACLE_HOME};
    $ENV{ORACLE_HOME} = $rootDir;

    my $tmppath = catfile($rootDir,'bin');
    $ENV{PATH}="$tmppath:$ENV{PATH}";

    my %cemutls_command_args = (exit_failure_list => [()]);
    my $vo = siha::Common::runsystemcommand('cemutls -w 2>&1','',%cemutls_command_args);
    chomp($vo) if $vo;
    $vo =~ s/\n/ /g if $vo;
    $vo =~ s/^\s+|\s+$// if $vo;

    # No vendor clusterware in use if cemutls fails
    $isVendorCW = 0 if $cemutls_command_args{command_return_status};

    # use cemutlo to get info on oracle clusterware
    my %command_args = (exit_failure_list => [()]);
    $o = siha::Common::runsystemcommand('cemutlo -w 2>&1','',%command_args);

    siha::Common::warn_message
     ("clusterconfig.pl:Failed executing command cemutlo -w")
      if $command_args{command_return_status};

    chomp($o) if $o;
    $o =~ s/\n/ /g if $o;
    $o =~ s/^\s+|\s+$// if $o;

    siha::Common::warn_message('clusterconfig.pl:Failed to get any results from cemutlo -w')
     unless $o;

    siha::Common::warn_message("clusterconfig.pl:Unknown format of the output from cemutlo -w : $o")
     if $o and $o !~ /(.*)\:(.*)\:(.*)/;

    # use the output from cemutls if output from cemutlo does not match
    $o = $vo
     if $vo and not $o and $o  !~ /(.*)\:(.*)\:(.*)/;

    ($version,$patch,$vendor) = ($o =~ /(.*)\:(.*)\:(.*)/)
      if $o and $o =~ /(.*)\:(.*)\:(.*)/;

    $version = "$version.$patch" if $version and $patch;

    #Active CRS Version
    %command_args = (exit_failure_list => [()]); 
    $o = siha::Common::runsystemcommand(
          'crsctl query crs activeversion 2>&1','',%command_args);

    siha::Common::warn_message
     ("clusterconfig.pl:Failed executing command crsctl query crs activeversion")
      if $command_args{command_return_status};

    chomp($o) if $o;
    $o =~ s/\n/ /g if $o;
    $o =~ s/^\s+|\s+$// if $o;


    siha::Common::warn_message('clusterconfig.pl:Failed to get any results from crsctl query crs activeversion')
     unless $o;

    siha::Common::warn_message("clusterconfig.pl:Unknown format of the output from crsctl query crs activeversion : $o")
     if $o and $o !~ /\[([\d|\.]+)\]/;

   ($CRSVersion) = ( $o =~ /\[([\d|\.]+)\]/ ) if $o and $o =~ /\[([\d|\.]+)\]/;

    # 10.1 crsctl doesn't return the version. 
    $CRSVersion = '10.1' 
     if not $CRSVersion and $version and $version =~ /^1.1$/;

    # restore ORACLE_HOME
    $ENV{ORACLE_HOME} = $oldOH;
}
else
{
    #No CRS is known to the cluster
    $rootDir = $ENV{EMDROOT};

    $clsName = siha::Common::getClusterName($rootDir);

    my $tmppath = catfile($rootDir,'bin');
    $ENV{PATH}="$tmppath:$ENV{PATH}";
    my %command_args = (exit_failure_list => [()]);

    $o = siha::Common::runsystemcommand('cemutls -w 2>&1','',%command_args);

    siha::Common::warn_message
     ("clusterconfig.pl:Failed executing command cemutls -w ")
      if $command_args{command_return_status};

    chomp($o) if $o;
    $o =~ s/\n/ /g if $o;
    $o =~ s/^\s+|\s+$// if $o;

    siha::Common::warn_message('clusterconfig.pl:Failed to get any results from cemutls -w') 
     unless $o;

    siha::Common::warn_message("clusterconfig.pl:Unknown format of the output from cemutls -w : $o")
     unless $o and $o =~ /(.*)\:(.*)\:(.*)/;

    ($version,$patch,$vendor) = ($o =~ /(.*)\:(.*)\:(.*)/) 
      if $o and $o =~ /(.*)\:(.*)\:(.*)/;

    $version = "$version.$patch" if $version and $patch;

}

$version='' unless $version;
$vendor='' unless $vendor;
$CRSVersion='' unless $CRSVersion;
$clsName = '' unless $clsName;
$eonsPort=0 unless $eonsPort;
$scanName='' unless $scanName;
$scanPort=0 unless $scanPort;

print "em_result=", $version, "|", $vendor, "|", $isVendorCW, "|", $CRSVersion, "|", $clsName, "|", $eonsPort, "|", $scanName, "|", $scanPort, "\n";

exit 0;


END
{

  $ENV{ORACLE_HOME} = $oldOH if $oldOH;

  siha::Common::save_systemcmdoutput or
   warn "clusterconfig.pl:Failed to save the test results from clusterconfig.pl\n";

}
