#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/rac/collectSrvPerf.pl /st_emgc_pt-12.1.0.4pg/1 2012/02/09 22:41:00 mappusam Exp $
#
# collectSrvPerf.pl
# 
# Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      collectSrvPerf.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    mappusam    01/26/12 - bug-13415931 fix
#    sadattaw    07/08/11 - fix lrg 5700950
#    sadattaw    06/02/11 - fixed issue, services with down status not picked
#                           up after optimization
#    sadattaw    03/28/11 - optimize logic to improve performance
#    gallison    12/04/08 - Fix up services on standby 
#    sadattaw    09/05/08 - oow fixes
#    sadattaw    06/19/07 - put inst cpu & core into hashtable
#    sadattaw    05/28/07 - fix numcores .
#    sadattaw    03/15/07 - fix available CPU computation
#    rsamaved    02/16/07 - fix min resp calculation
#    rsamaved    01/30/07 - adding method to get instance level elapsed time
#                           and cpu time values
#    rsamaved    01/26/07 - 
#    sadattaw    01/25/07 - service performance collection methods
#    sadattaw    01/25/07 - Creation
# 

use strict;
use DBI qw(:sql_types);
use Cwd;

require "db/dbstate.pl";
require "db/dg/dgutil.pl";


sub collect_service_metric
{
    my ($usr_name, $pwd, $dbName, $addr, $role ) = @_;

my $mode = 0;

if($role =~ /SYSDBA/i)
{
    $mode = 2;
}
elsif($role =~ /SYSOPER/i)
{
    $mode = 4;
}


# --------------------------------------------------------------------
# +++ Establish Target DB Connection
# --------------------------------------------------------------------

my $lda = DBI->connect('dbi:Oracle:', "$usr_name@".$addr, "$pwd",
    {ora_session_mode => $mode, PrintError => 0, RaiseError => 0, AutoCommit => 0})

    or die "em_error=Could not connect to $usr_name/$addr: $DBI::errstr\n";

#print "DB connection successful :  $address \n";
EMD_PERL_DEBUG( "DB connection successful:  $addr \n");

my $database_role = getDBRole($lda);

# do not collect any service info if mounted since views are not accessible...
my $database_status = getDBStatus($lda);
if ($database_status !~ /OPEN/i)
{
  EMD_PERL_DEBUG( "Skipping services.. RAC DB is $database_status\n");
  print "em_result=1||\n";
  $lda->disconnect();
  exit 0;
}
my $instcpus = {};
#my $instcores = {};
my $instnames = {};

  get_service_metric($lda, $dbName, $instcpus, $instnames, $database_role);

$lda->disconnect();

}

sub getDBStatus
{
  my ( $connection ) = @_;
  my $sql = "select status from v\$instance";
  my $dbcur = $connection->prepare($sql);
  $dbcur->execute;

  my @row = $dbcur->fetchrow_array();
  my $status = $row[0];
  return ("${status}");
}


# query all services in the database from all_services table
# query service metric history data for all active services
# query instances on which each active service is running
# from service metric data compute min / max / avg response time for each service
# join together all services information with instance details to figure out service status and
#    running instances list
sub get_service_metric
{
    my ( $connection, $dbname, $instcpu, $instnm, $dbrole) = @_;

my $met_tbl = 'gv$servicemetric_history';
my $actserv_tbl = 'gv$active_services';
my $inst_tbl = 'gv$instance';
my $param_tbl = 'gv$osstat';
my $srv_tbl = 'all_services';

my @all_services = ();
#gv$services table does not exclude deleted services so use all_servies to get service list from db
my $sql = qq{ SELECT DISTINCT service_id, name FROM $srv_tbl };
my $sth = $connection->prepare( $sql );
$sth->execute();

my( $srv_id, $srv_name);
$sth->bind_columns( undef, \$srv_id, \$srv_name);

my $srvctr = 0;
while( $sth->fetch() ) {
#  print "Service :  $srv_id, $srv_name\n";
  EMD_PERL_DEBUG( "Service :  $srv_id, $srv_name\n");

  push(@all_services, $srv_name);

}

$sth->finish();



#  print "get_service_metric :  $srv_name\n";
#  EMD_PERL_DEBUG( "get_service_metric :  $dbname, role $dbrole\n");

    #calculate average response time and throughput values across all instances for a given service
    # hence query gv$ tables

    my $met_sql = qq{ SELECT distinct ast.name, mt.inst_id,
                             TO_CHAR(CAST(mt.begin_time AS TIMESTAMP) AT TIME ZONE 'GMT', 'YYYY-MM-DD HH24:MI:SS TZD') begintime,
                             TO_CHAR(CAST(mt.end_time AS TIMESTAMP) AT TIME ZONE 'GMT', 'YYYY-MM-DD HH24:MI:SS TZD') endtime,
                             mt.intsize_csec,
                             mt.group_id, mt.cpupercall, mt.dbtimepercall, mt.callspersec, mt.dbtimepersec
                      FROM $met_tbl mt , $actserv_tbl ast
                      WHERE  end_time >= SYSDATE - 5/(60*24) AND
                             group_id = 6 AND
                             mt.service_name = ast.name AND
                             mt.inst_id = ast.inst_id
                      ORDER BY ast.name, mt.inst_id asc, endtime DESC
		  };

    my $met_sth = $connection->prepare( $met_sql );
    if (!$met_sth)
    {
  	EMD_PERL_DEBUG( "em_error=prepare query failed for metric query, returning \n");
        print "em_error=prepare query failed for metric query, returning \n";
	return;
    }

    $met_sth->execute();
    my( $sv_name, $instid, $beginTime, $endTime, $interval, $grpid, $cpupercall, $dbpercall, $callspersec, $dbtimepersec);
    $met_sth->bind_columns( undef, \$sv_name, \$instid, \$beginTime, \$endTime, \$interval, \$grpid, \$cpupercall, \$dbpercall, \$callspersec, \$dbtimepersec );

#    print "\n -- getServiceMetric:: Service metrics records \n";
#    print "instid | service name | begin time | end time | interval | groupid | cpupercall | dbpercall | calls/sec | dbtime/sec \n";
#    EMD_PERL_DEBUG( "\n -- getServiceMetric:: Service metrics records \n");
##    EMD_PERL_DEBUG( "instid | service name | begin time | end time | interval | groupid | cpupercall | dbpercall | calls/sec | dbtime/sec \n");

    my $cpu_sql = qq{ SELECT value
                        FROM $param_tbl
                        WHERE inst_id = ? and stat_name='NUM_CPUS'
                    };
    my $cpu_core_sql = qq{ SELECT value
                        FROM $param_tbl
                        WHERE inst_id = ? and stat_name='NUM_CPU_CORES'
                    };

    my $inst_sql = qq{ SELECT instance_name
                    FROM $inst_tbl  
                    WHERE inst_id = ?
                };
    my $inst_sth = $connection->prepare( $inst_sql );

    my $timedif = 0.0;


    my $cpu_sth = $connection->prepare( $cpu_sql );
    my $cpu_core_sth = $connection->prepare( $cpu_core_sql );


# Query Service performance information from gv$service metric history for all services for last 5 minutes
# and build hash table of array of records for each service
    my %srv_perf_rec_hash = ();
    my $ctr = 0;
    while( $met_sth->fetch() ) 
    {
#print "$instid, $sv_name, $beginTime, $endTime, $interval, $grpid, $cpupercall, $dbpercall, $callspersec, $dbtimepersec \n";
        $timedif = $interval /100;  #interval is in 100th of sec

	my @srv_rec_list;
	if (defined %srv_perf_rec_hash)
	{
	    # if service records array not defined for this service, create new array and add record
            if (!defined @{%srv_perf_rec_hash->{$sv_name} })
            {
		@srv_rec_list = ();
	        push @srv_rec_list, { service=> $sv_name, instid => $instid, beginTime=> $beginTime, endTime=> $endTime, timedif => $timedif, cpupercall => $cpupercall, dbpercall => $dbpercall, callspersec => $callspersec, dbtimepersec => $dbtimepersec };
	    }
	    # if service records array exists  for this service, add a new record
	    else
	    {
	       @srv_rec_list = @ {%srv_perf_rec_hash->{$sv_name} };
	       push @srv_rec_list, { service=> $sv_name, instid => $instid, beginTime=> $beginTime, endTime=> $endTime, timedif => $timedif, cpupercall => $cpupercall, dbpercall => $dbpercall, callspersec => $callspersec, dbtimepersec => $dbtimepersec };
	    }
	}
	#if service records hash is not defined, added new array and added rec to array and put the array into hash 
	else
	{
	    push @srv_rec_list, { service=> $sv_name, instid => $instid, beginTime=> $beginTime, endTime=> $endTime, timedif => $timedif, cpupercall => $cpupercall, dbpercall => $dbpercall, callspersec => $callspersec, dbtimepersec => $dbtimepersec };

	}
	# put the service records array for the service into hash table
	%srv_perf_rec_hash->{$sv_name} = [ @srv_rec_list ];
    }
    $met_sth->finish();



    # Query running instance information for all services from gv$active_services to build running instance list and 
    # service status build hash table of r
#        print " \n Active services rec : ----------------> \n";
    my $inst_name = "";
    my %srv_status_rec_hash = ();
    my $stat_sql = qq{ SELECT s.name, s.inst_id, i.instance_name
                    FROM $actserv_tbl s, $inst_tbl i 
                    WHERE s.inst_id = i.inst_id
		    ORDER BY s.name
                };

    my $stat_sth = $connection->prepare( $stat_sql );
    $stat_sth->execute();
    my( $stat_sv_name, $stat_instid, $stat_instnm);
    $stat_sth->bind_columns( undef, \$stat_sv_name, \$stat_instid, \$stat_instnm );
    while( $stat_sth->fetch() ) 
    {
#        print "---- : $stat_instid, $stat_sv_name, $stat_instnm \n";
#        EMD_PERL_DEBUG( "$stat_instid, $stat_sv_name, $stat_instnm \n");

	my $srv_running_inst_list;
        if (defined %srv_status_rec_hash)
        {
	    $inst_name = $instnm->{$stat_instid};
            if (!defined $inst_name)
            {
                $instnm->{$stat_instid} = $stat_instnm;
	    }

            # if service status records not defined for this service, create new record
            if (!defined %srv_status_rec_hash->{$stat_sv_name})
            {
		$srv_running_inst_list = $srv_running_inst_list.$stat_instnm;
            }
            # if service status array exists  for this service, append instance to existing list 
            else
            {
		$srv_running_inst_list = %srv_status_rec_hash->{$stat_sv_name};
		$srv_running_inst_list = $srv_running_inst_list.",";
		$srv_running_inst_list = $srv_running_inst_list.$stat_instnm;
            }
        }
        #if service records hash is not defined, added new rec to into hash 
        else
        {
	    $srv_running_inst_list = $srv_running_inst_list.$stat_instnm;
        }
        # put the service records array for the service into hash table
        %srv_status_rec_hash->{$stat_sv_name} = $srv_running_inst_list;
    }

#    foreach $stat_instid ( keys % {$instnm} )
#    {
#print "\n inst id, inst name  ----------> $stat_instid, $instnm->{$stat_instid} \n";
#    }

#    foreach $stat_sv_name ( keys %srv_status_rec_hash )
#    {
#	my $running_instlist = %srv_status_rec_hash->{$stat_sv_name};
#print "\n stat_sv_name , running inst list  ----------> $stat_sv_name, $running_instlist \n";
#    }

# following while loop needs to be over the record hash we generate above
    my $srv_name;
    my $srvrec;
    my @serviceRecList;
#    foreach $srv_name ( keys %srv_perf_rec_hash )
#    {

     foreach $srv_name (@all_services)
     {
#print "\n service----------> $srv_name\n";

    	my $minresp;
    	my $maxresp;
    	my $mininst = 1;
    	my $maxinst = 1;    ##  need some value if all the resp times are 0
    	my $cpuload = 0.0;
    	my $totalcpu = 0.0;
    	my $availcpu = 0.0;
    	my $avgResponse = 0.0;
    	my $totalcalls = 0.0;
    	my $service_status = '';
    	my $running_instlist = '';
    	my $lastinst = 0;
    	my $totalcpuInst = 0.0;
    	my $availinstcpuInst = 0.0;
    	my $avgResponseInst = 0.0;
    	my $totalcallsInst = 0.0;
    	my $beginTimeInst = "";
    	my $endTimeInst = "";
    	my $instentries = 0;
        $inst_name = "";

    	my $inst_cpu =0;
#    	my $inst_cpu_cores =0;

        if (defined %srv_perf_rec_hash->{$srv_name} )
        { # if service record exists in perf hash

	@serviceRecList = @{ %srv_perf_rec_hash->{$srv_name} };

        if (defined @serviceRecList)
        {

    	  foreach $srvrec ( @serviceRecList )
    	  {    

	$sv_name = $srvrec->{service};
	$instid = $srvrec->{instid};
	$beginTime = $srvrec->{beginTime};
	$endTime = $srvrec->{endTime};
	$timedif = $srvrec->{timedif};
	$cpupercall = $srvrec->{cpupercall};
	$dbpercall = $srvrec->{dbpercall};
	$callspersec = $srvrec->{callspersec};
	$dbtimepersec = $srvrec->{dbtimepersec};


#print "$instid, $sv_name, $beginTime, $endTime, $timedif, $grpid, $cpupercall, $dbpercall, $callspersec, $dbtimepersec \n";
#EMD_PERL_DEBUG( "$instid, $sv_name, $beginTime, $endTime, $timedif, $grpid, $cpupercall, $dbpercall, $callspersec, $dbtimepersec \n");
   
        my $totalcallsPerInterval = $callspersec*$timedif;
        if ($totalcallsPerInterval == 0)
        {
	   $totalcallsPerInterval = 1;
        }

	if ($instid != $lastinst)
	{
            if ($lastinst != 0)
            {
    		if ($totalcallsInst != 0.0)
    		{
#print "$instid :: total dbtimeInst: $avgResponseInst, total cpu inst :  $totalcpuInst, total callsInst: $totalcallsInst \n";
		    $totalcpuInst = $totalcpuInst / $totalcallsInst;
		    $avgResponseInst = $avgResponseInst / $totalcallsInst;
    		}
              print "inst_result=$dbname|$srv_name|$lastinst|$inst_name|$beginTimeInst|$endTimeInst|$totalcpuInst|$avgResponseInst\n";
              EMD_PERL_DEBUG("inst_result=$dbname|$srv_name|$lastinst|$inst_name|$beginTimeInst|$endTimeInst|$totalcpuInst|$avgResponseInst\n");
            }

	    $inst_cpu = $instcpu->{$instid};
	    if (!defined $inst_cpu)
	    {
               $cpu_sth->execute($instid);
               $cpu_sth->bind_columns( undef, \$inst_cpu );
               $cpu_sth->fetch();
	       $instcpu->{$instid} = $inst_cpu;
#           print "instance $instid, cpu count : $inst_cpu\n";
           EMD_PERL_DEBUG( "instance $instid, cpu count : $inst_cpu \n");
	    }
	    if ($inst_cpu == 0)
	    {
	       $inst_cpu = 1;
	    }
$cpu_sth->finish();
#As per cecilia comment available cpu should only multiply the interval size by  inst_cpu so removing inst_cpu_cores  
#           $inst_cpu_cores = $instcore->{$instid};
#	    if (!defined $inst_cpu_cores)
#	    {
#               $cpu_core_sth->execute($instid);
#               $cpu_core_sth->bind_columns( undef, \$inst_cpu_cores );
#               $cpu_core_sth->fetch();
#	       $instcore->{$instid} = $inst_cpu_cores;
#           print "instance $instid, cpu core count: $inst_cpu_cores \n";
#               EMD_PERL_DEBUG( "instance $instid, cpu core count: $inst_cpu_cores \n");
#	    }
#	    if ($inst_cpu_cores == 0)
#	    {
#	       $inst_cpu_cores = 1;
#	    }
#        $cpu_core_sth->finish();

	    # fetch instance name from instid
	    $inst_name = $instnm->{$instid};

 	    $lastinst = $instid;
            $totalcpuInst = 0.0;
            $availinstcpuInst = 0.0;
            $avgResponseInst = 0.0;
            $totalcallsInst = 0.0;
            $beginTimeInst = $beginTime;
            $instentries = 0;
        }

 	$totalcpuInst += ($cpupercall / 1000) * $totalcallsPerInterval;
 	$availinstcpuInst += $timedif* 1000 * $inst_cpu ;   # get in to milliseconds	

	$avgResponseInst += ($dbpercall/1000) * $totalcallsPerInterval;	
	$totalcallsInst += $totalcallsPerInterval;
        $endTimeInst = $endTime;

 	$totalcpu += ($cpupercall / 1000) * $totalcallsPerInterval;
 	$availcpu += $timedif* 1000 * $inst_cpu ;   # get in to milliseconds	

##	$avgResponse += $dbpercall;	
###	$availcpu += $dbpercall * $callspersec * $timedif * $inst_cpu;	

	$avgResponse += ($dbpercall/1000) * $totalcallsPerInterval;	
	$totalcalls += $totalcallsPerInterval;

 	if (! defined $minresp or ($dbpercall < $minresp))
	{
	   $minresp = $dbpercall;
	   $mininst = $instid;
	}
 	if ( ! defined $maxresp or ($dbpercall > $maxresp))
	{
	   $maxresp = $dbpercall;
	   $maxinst = $instid;
	}

      } # foreach service rec
    } #if service rec list 
    } # if service record exists in perf hash 

    if ($availcpu  != 0)
    {
        $cpuload = ($totalcpu/$availcpu) *100;
    }

    # print the last instance data
    if ($totalcallsInst != 0.0)
    {
#print "$instid :: total dbtimeInst: $avgResponseInst, total cpu inst :  $totalcpuInst, total callsInst: $totalcallsInst \n";
	$totalcpuInst = $totalcpuInst / $totalcallsInst;
	$avgResponseInst = $avgResponseInst / $totalcallsInst;
    }
    print "inst_result=$dbname|$srv_name|$lastinst|$inst_name|$beginTimeInst|$endTimeInst|$totalcpuInst|$avgResponseInst\n";
    EMD_PERL_DEBUG("inst_result=$dbname|$srv_name|$lastinst|$inst_name|$beginTimeInst|$endTimeInst|$totalcpuInst|$avgResponseInst\n");
   
#    if ($met_sth->rows != 0)
#    {
#        $avgResponse = $avgResponse / ($met_sth->rows);
#    }

#    print "total cputime: $totalcpu, avail cputime: $availcpu , cpuload % $cpuload\n";
    EMD_PERL_DEBUG("total cputime: $totalcpu, avail cputime: $availcpu, cpuload % $cpuload\n");

    if ($totalcalls != 0.0)
    {
        $avgResponse = $avgResponse / $totalcalls;
    }
#    print "total dbtime: $avgResponse, total calls: $totalcalls \n";
    EMD_PERL_DEBUG("total dbtime: $avgResponse, total calls: $totalcalls\n");

    my $mininst_name = '';
    my $maxinst_name = '';
    if (! defined $minresp)
    {
	$minresp = 0.0;
    }
    else
    {
	$mininst_name = $instnm->{$mininst};
        if (!defined $mininst_name)
	{
	   $mininst_name = '';
	}
    }
    if (! defined $maxresp)
    {
	$maxresp = 0.0;
    }
    else
    {
	$maxinst_name = $instnm->{$maxinst};
        if (!defined $maxinst_name)
	{
	    $maxinst_name = '';
	}
    }

    $minresp = $minresp/1000;
    $maxresp = $maxresp/1000;

     $running_instlist = "";
     if (defined %srv_status_rec_hash->{$srv_name})
     {
	$running_instlist = %srv_status_rec_hash->{$srv_name};
	$service_status = "Up";
     }
     else
     {
	$service_status = "Down";
     }


    if ($srv_name eq 'seeddata' or $srv_name eq 'seeddataXDB')
    {
        $service_status = "";
    }
    $stat_sth->finish();

# ignore service if down and standby role. 
   if ($service_status eq "Down" && $dbrole !~ /PRIMARY/i)
   {
      EMD_PERL_DEBUG( "Ignoring $service_status service $srv_name for $dbrole.\n");
   }
   else
   {
    print "em_result=$dbname|$srv_name|$minresp|$mininst_name|$maxresp|$maxinst_name|$avgResponse|$cpuload|$service_status|$running_instlist\n";
    EMD_PERL_DEBUG( "em_result=$dbname|$srv_name|$minresp|$mininst_name|$maxresp|$maxinst_name|$avgResponse|$cpuload|$service_status|$running_instlist\n");
   }

}

}

