#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/rac/dbIntrconnType.pl /st_emdbgc_10.2.0.1.0/3 2009/08/31 19:29:02 shasingh Exp $
#
# dbIntrconnType.pl
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      dbIntrconnType.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajdsouza    08/25/09 - switched from siha::Common to has::Common
#    rsamaved    08/11/08 - 
#    gapadman    07/31/08 - 
#    ajdsouza    01/30/07 - bug fix 5732015 
#    xuliu       07/07/05 - 4472067: get all info from cluster_interconnects 
#    xuliu       04/14/05 - xuliu_bug-4283639
#    xuliu       04/05/05 - Creation
# 

use strict;
use warnings;

use DBI;

require "emd_common.pl";
require "semd_common.pl";
use has::Common;

my %stdinArgs = has::Common::get_stdinvars();
my $username = $stdinArgs{"EM_TARGET_USERNAME"};
my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
my $address = $ENV{EM_TARGET_ADDRESS};
my $role = $ENV{EM_TARGET_ROLE};
my $mode = 0;
my $tgtName = $ENV{EM_TARGET_NAME};

###### DEBUG ####
#my $username = "sys";
#my $password = "oracle";
#$role="SYSDBA";
#$address = "(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=stacg40)(PORT=1521))(CONNECT_DATA=(SID=db102)))";
##################

if($role =~ /SYSDBA/i)
{
  $mode = 2;
}
elsif($role =~ /SYSOPER/i)
{
  $mode = 4;
}

EMD_PERL_DEBUG("Start collection of interconnect type for target $tgtName ...");

my $lda = DBI->connect('dbi:Oracle:', "$username@".$address, "$password", 
    {ora_session_mode => $mode, PrintError => 0, RaiseError => 0})
    or has::Common::exit_fail("dbIntrconnType.pl:Could not connect to $username/$address: $DBI::errstr\n");

my $clsIntrconSql = "SELECT name, is_public FROM v\$cluster_interconnects order by name";
my $ro_cur = $lda->prepare($clsIntrconSql)
    or disconnect_N_die($lda, "prepare($clsIntrconSql): $DBI::errstr\n");

$ro_cur->execute()
    or disconnect_N_die($lda, "ro_cur->execute(): $DBI::errstr\n");

my @arow;
my @intrconns;

EMD_PERL_DEBUG("v\$cluster_interconnects has the following:");
while (@arow = $ro_cur->fetchrow_array())
{
    EMD_PERL_DEBUG(join(",", @arow));
    my @a = @arow;
    push(@intrconns, \@a);
}

$ro_cur->finish;

$lda->disconnect;


if ( @intrconns )
{
    
    my ($eth, $is_public);
    my $pre_eth = "";
    
    for (my $i=0; $i<@intrconns; $i++)
    {
       my $r = $intrconns[$i];
              
       $eth = (defined($r->[0]))? $r->[0] : "";
       $is_public = (defined($r->[1]))? $r->[1] : "";
       
       $eth = "Unknown" if ($eth eq "");
       if ($is_public eq "YES")
       {
            $is_public = "Public";
       }elsif ($is_public eq "NO")
       {
            $is_public = "Private";
       }
       else
       {
            $is_public = "Unknown";
       }     
       
       if ($eth ne $pre_eth)
       {
           $pre_eth = $eth;
           EMD_PERL_DEBUG("Output: em_result=$eth|$is_public");
           print "em_result=$eth|$is_public\n";
       }
       else
       {
           EMD_PERL_DEBUG("$eth already processed, skip ($eth, $is_public)");
       }     
    }      
}           

sub disconnect_N_die
{
   my ($con, $msg) = @_;
   $con->disconnect;
   has::Common::exit_fail("dbIntrconnType.pl:$msg");
}

exit 0;
