#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/rac/rac_dyna_props.pl /st_emdbgc_10.2.0.1.0/2 2008/10/23 18:17:12 rsamaved Exp $
#
# rac_dyna_props.pl
# 
# Copyright (c) 2008, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      rac_dyna_props.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    shasingh    08/20/08 - changed dyna prop to return individual serverl pool
#                           size
#    shasingh    06/12/08 - use server group resource name
#    rsamaved    05/08/08 - 
#    shasingh    05/02/08 - Calculate db dynamic prop
#    shasingh    05/02/08 - Creation
# 

use strict;
require "semd_common.pl";

my $LOG_CATEGORY = "DATABASE_TYPE_DYNA_PROP: ";

# save ORACLE_HOME and restore it back in END
my $oldOH = $ENV{ORACLE_HOME} if $ENV{ORACLE_HOME};
unset_lib_path_env();

my %stdinArgs = get_stdinvars();
my $dbname = $stdinArgs{EM_TARGET_DBNAME} if $stdinArgs{EM_TARGET_DBNAME};
my $oraclehome = $stdinArgs{EM_TARGET_ORACLE_HOME} if $stdinArgs{EM_TARGET_ORACLE_HOME};

my ($dbtype, $srvgrps, $srvgrpsizes) = ("","",""); 
($dbtype, $srvgrps,$srvgrpsizes) = getDBTypeNSrvGrpInfo($oraclehome,$dbname) 
                                             if  defined($oraclehome) and defined($dbname) ;

print "em_result=$dbtype:$srvgrps:$srvgrpsizes\n"; 
exit 0;

END
{
  $ENV{ORACLE_HOME} = $oldOH if $oldOH;
}

# Evaluate the database type, comma server group resource names and max of server groups pool size
sub getDBTypeNSrvGrpInfo 
{
 my ($oh, $db_name ) = @_;
 
 my $cmd = "$oh/bin/srvctl config database -d $db_name -S 1";
 my ( $err, $output ) = executeCommand( $cmd, $oh );
 EMD_PERL_DEBUG("$LOG_CATEGORY getDBTypeNSrvGrpInfo-> $cmd returned (err=$err, output=$output)");
 
 my ($type,$srvgrplist)  = ("","");
 
 if($err eq "")
 {
  my @lns = split /\n/, $output;
  for my $ln (@lns)
  {
   if ($ln =~ /res_name\s*=\s*\{.*?\.$db_name\..*?\}.*?srvpool\s*=\s*\{(.*?)\}.*?db_type\s*=\s*\{(.*?)\}/i)
   {
    ($srvgrplist,$type) = ($1,$2);
    EMD_PERL_DEBUG("$LOG_CATEGORY getDBTypeNSrvGrpInfo-> Database Type: $type, Server Group List : $srvgrplist ");
    last;
   }
  }
 }
  
 my ($srvpools,$srvpoolsizes)=("",0);
 my @srvgrpresarray = ();
 my @srvgrpsizearray =();
 
 my @srvgrpnames = split /\,/, $srvgrplist;
 foreach my $srvname (@srvgrpnames)
 {
 	my ($resname,$poolsize) = getSrvGrpInfo($oh,$srvname);
 	push(@srvgrpresarray,$resname);
 	push(@srvgrpsizearray,$poolsize);
    
 	
 }
 
 $srvpools = join (",", @srvgrpresarray);
 $srvpoolsizes = join (",", @srvgrpsizearray);  
   
 ($type,$srvpools,$srvpoolsizes);
}

#Evaluate the server group resource name and it's max size for given server group
sub getSrvGrpInfo
{
 my ($oh, $srvgrpname) = @_;
  
 my $cmd = "$oh/bin/srvctl config srvpool -g $srvgrpname -S 1";
 my ( $err, $output ) = executeCommand( $cmd, $oh);
 EMD_PERL_DEBUG("$LOG_CATEGORY getSrvGrpInfo-> $cmd returned (err=$err, output=$output)");
 
 my ($srvgrpresname,$srvgrpmaxsize)= ("",0);
 if($err eq "")
 {
  my @lns = split /\n/, $output;
  for my $ln (@lns)
  {
   if ($ln =~ /res_name\s*=\s*\{(.*?\.$srvgrpname.*?)\}.*?max\s*=\s*\{(.*?)\}/i)
   {
    ($srvgrpresname,$srvgrpmaxsize) = ($1,$2);
    EMD_PERL_DEBUG("$LOG_CATEGORY getSrvGrpInfo-> Server Group Res Name : $srvgrpresname,  Server pool max Size: $srvgrpmaxsize ");
    last;
   }
  }
 }
 
 ($srvgrpresname,$srvgrpmaxsize);
 
}

# execute the supplied command
sub executeCommand
{
 my ( $cmd, $oh ) = @_;
 $ENV{ORACLE_HOME} = $oh;
 my $err    = "";
 my $output = "";
 if ( open( CMDOUTPUT, "$cmd 2>&1 |" )) 
 {
  my @outputs = <CMDOUTPUT>;
  $output = join "", @outputs;
  if ( !close(CMDOUTPUT) ) 
  {
   # close error
   if ( $output ne "" ) 
   {
    $err    = "\"${cmd}\" returned: \"" . $output . "\"";
    $output = "";
   }
   else
   {
    $err = "bad \"$cmd\": $! $?";
   }
  }
 }
 else
 {
  # open error
  $err = "cannot execute \"$cmd\": $!";
 }

 EMD_PERL_ERROR("executeCommand: $cmd: $err") if ( $err ne "" );
 ( $err, $output );
}

# unset the *LD_* env variable for proper function of srvctl
sub unset_lib_path_env 
{
 delete $ENV{LD_LIBRARY_PATH};
 delete $ENV{SHLIB_PATH};
 delete $ENV{LIBPATH};
 delete $ENV{DYLD_LIBRARY_PATH};
}
