#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/rac/servicePerf.pl /main/7 2010/07/18 00:53:22 prapatil Exp $
#
# servicePerf.pl
# 
# Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      servicePerf.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#    Collect service performance metric, collected every 5 min for rac and single instance dbs
#    get list of services from gv$services table, for each service query gv$servicemetric_history table
#    use cpupercall and dbtimepercall to calculate throughput and average response time
#    For rac databases values will be calculated on the composite target
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sadattaw    08/04/08 - 
#    nachen      06/19/08 - XbranchMerge nachen_bug-7144603 from st_emdbsa_11.1
#    nachen      06/06/08 - fix internal references security issue
#    sadattaw    01/23/07 - calculating cpuload % instead of throughput
#    sadattaw    01/23/07 - calculating cpuload % instead of throughput
#    sadattaw    01/23/07 - calculating cpuload % instead of throughput
#    sadattaw    01/10/07 - add min, max and % cpu load
#    sadattaw    11/16/06 - implement review comments
#    sadattaw    10/11/06 - script to collect service performance metric for
#                           rac and single instance db
#    sadattaw    10/11/06 - Creation
# 

use strict;
use DBI qw(:sql_types);
use Cwd;

require "db/dbstate.pl";
require "rac/collectSrvPerf.pl";


# For TESTING: comment out stdin args
my %stdinArgs = get_stdinvars();
my $username = $stdinArgs{"EM_TARGET_USERNAME"};
my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
my $databaseName = $stdinArgs{"EM_TARGET_DBNAME"};
my $address = $ENV{EM_TARGET_ADDRESS};
my $usr_role = $ENV{EM_TARGET_ROLE};

collect_service_metric($username, $password, $databaseName, $address, $usr_role);

