#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/runSQLScript.pl /main/1 2011/06/24 10:04:34 anirkulk Exp $
#
# runSQLScript.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      runSQLScript.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    anirkulk    06/10/11 - perl script to run sql command against ASM target
#    anirkulk    06/10/11 - Creation
# 

use strict;
use JobUtil;
use JobDiagUtil;

# constant for the delimiter for property name and value
use constant DELIMITER    => "=";

# constant for the end of stream for the input properties stream
use constant EOS          => "__EM_JOB_INPUT_STREAM_END__";

# constant for the sql username
use constant SQL_USER     => "__EM_JOB_SQL_USER__";

# constant for the sql password
use constant SQL_PASSWORD => "__EM_JOB_SQL_PASSWORD__";

# constant for the sql dbrole
use constant SQL_DBROLE   => "__EM_JOB_SQL_DBROLE__";


# initialize global variables
my $nolog  = '/nolog';

my $username = "";
my $password = "";
my $dbrole = "";

my $connectString = "";

my $oracleHome = "$ARGV[0]";
my $oracleSid  = "$ARGV[1]";

shift;
shift;


# setup the environment required by SQL*Plus to execute
sub setupEnv
{
    $ENV{ORACLE_HOME}       = $oracleHome;
    $ENV{ORACLE_SID}        = $oracleSid;

    $ENV{LD_LIBRARY_PATH}    = "$ENV{ORACLE_HOME}/lib";
    $ENV{LD_LIBRARY_PATH_64} = "$ENV{ORACLE_HOME}/lib";
    $ENV{SHLIB_PATH}         = "$ENV{ORACLE_HOME}/lib";
    $ENV{LIBPATH}            = "$ENV{ORACLE_HOME}/lib";
    $ENV{PATH}               = "$ENV{ORACLE_HOME}/bin";

    $ENV{ORA_NLS} = "";
    $ENV{ORA_NLS32} = "";
    $ENV{ORA_NLS33} = "";

    JobDiagUtil::logFine("ORACLE_HOME : ".$ENV{ORACLE_HOME});
    JobDiagUtil::logFine("ORACLE_SID  : ".$ENV{ORACLE_SID});
    JobDiagUtil::logFine("LD_LIBRARY_PATH : ".$ENV{LD_LIBRARY_PATH});
    JobDiagUtil::logFine("LD_LIBRARY_PATH_64 : ".$ENV{LD_LIBRARY_PATH_64});
    JobDiagUtil::logFine("SHLIB_PATH : ".$ENV{SHLIB_PATH});
    JobDiagUtil::logFine("LIBPATH : ".$ENV{LIBPATH});
    JobDiagUtil::logFine("PATH : ".$ENV{PATH});
}

# get the parameters from the input stream
sub getParams
{
    # get the parameters from STDIN
    my %paramsMap  = JobUtil::getInputStreamParamsMap(DELIMITER, EOS);

    # separate out
    $username      = $paramsMap{+SQL_USER};
    $password      = $paramsMap{+SQL_PASSWORD};
    $dbrole        = $paramsMap{+SQL_DBROLE};

    # diagnostic logging of the username and the role
    JobDiagUtil::logFine("Username : $username : DBRole : $dbrole");

    # get the connect string
    $connectString = JobUtil::formSQLPlusConnectString($username, $password, $dbrole);
}

# execute SQL*Plus from the command line and spool the connection string and rest of the input stream to it
sub executeSQLPlus
{
    my $command = "$ENV{ORACLE_HOME}/bin/sqlplus @ARGV $nolog";
    JobDiagUtil::logInfo("Opening piped command : $command");

    # open piped command
    my $PIPED_CMD = 0;
    open PIPED_CMD, " | $command" or die("Unable to launch $command : $! \n");
    
    # write prescript
    print PIPED_CMD "WHENEVER SQLERROR EXIT SQLCODE;\n";
    print PIPED_CMD $connectString."\n";
    print PIPED_CMD "WHENEVER SQLERROR CONTINUE;\n";

    # write what ever is coming in the STDIN to this pipe
    while (<STDIN>)
    {
        print PIPED_CMD $_;
    }

    # close the pipe
    if (! close PIPED_CMD)
    {
        my $syscode = $? & 0xFFFF;
        if ( $syscode )
        {
            # The signal or core dump is in the low byte
            # program code is in the high byte
            my $sig = 0xFF & $syscode;
            my $ret = $syscode >> 8;
        
            if ( $sig )
            {
                # if there's a signal, return a negative number
                print "\nSignal from SQLPLUS: $sig\n";
                exit (- $sig);
            }
            else
            {
                # return the positive error code from sqlplus
                print "\nError from SQLPLUS: $ret\n";
                exit $ret;
            }
        }
    }
}

# logic flow for this script
sub main
{
    # setup the executing environment of the script and SQL*Plus
    setupEnv;
    
    # get the parameters from the Input Stream
    getParams;

    # execute SQL*Plus with the remaining Input Stream
    executeSQLPlus;
}

# While writing to a pipe, trap SIGPIPE. Otherwise, if a pipe is opened to a
# command that does not exist, the open() may succeed as it only reflects the
# fork()'s success, but the output would fail. Perl cannot know whether the
# command worked because that command is actually running in a separate process
# whose exec() might have failed. Therefore, while readers of bogus commands
# return just a quick end of file, writers to bogus command will trigger a
# signal.

$SIG{PIPE} = 'IGNORE';

# call the main sub routine
main;

# return success
exit 0;
