#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/txt/textIndexLogViewer.pl /st_emdbgc_10.2.0.1.0/1 2008/10/15 00:33:20 prjaiswa Exp $
#
# textIndexLogViewer.pl
# 
# Copyright (c) 2008, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      textIndexLogViewer.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    prjaiswa    10/13/08 - Creation
# 
use strict;
use Time::Local;
use HTTP::Date;

require "alertlog_util.pl";

# Command Line Arguments
my $argnum = @ARGV;

my $logFile = shift(@ARGV);
my $sizeToView = shift(@ARGV); # The last <sizeToView> bytes to view

my $stime;      # start time filter
my $etime;      # end time filter

if ($argnum > 2)
{
    $stime=shift(@ARGV);
    $etime=shift(@ARGV);
}
# End Arguments


if(!open(FH, "$logFile"))  
{
    print "$logFile does not exist.\n";
    exit 0;
}


seek(FH,0,2);  # go directly to EOF

my $fileSize = tell(FH);
my $startPoint = $fileSize - $sizeToView;

if($startPoint < 0)
{
    $startPoint = 0; 
}

if(!seek(FH, $startPoint, 0))  
{
    print "Could not read $logFile\n";
    exit 0;
}

my $bufferSize = 1000; # size of read buffer in bytes
my $record;

if ( (!defined($stime) &&  !defined($etime)) || ($stime eq '0' && $etime eq '0'))
{
    while(<FH>)
    {
        #read(FH, $record, $bufferSize) || die "can't read $logFile: $!";
        if(!read(FH, $record, $bufferSize))  
        {
            print "Error occured while reading $logFile\n";
            exit 0;
        }    
        print $record;
    }
}
else
{
    my $secs;
    my $found=0;

    # start time
    my $stimesec;
    if ($stime eq '0')
    {
        $stimesec = 0;
    }
    else
    {
        my @startlist=split(':', $stime);
        $stimesec = timelocal(@startlist);
    }        
    
    # end time
    my $etimesec;
    if ($etime eq '0')
    {
        $etimesec = 0;
    }
    else
    {
        my @endlist=split(':', $etime);
        $etimesec = timelocal(@endlist);
    }    

    while(<FH>)
    {
        $record = $_;    
        
        if ($found == 0 ||  $etimesec != 0)
        {
            $secs = str2time($record);   
    
            if (defined $secs)
            {
                if ($secs >= $stimesec && ($secs <= $etimesec || $etimesec == 0))
                {        
                    $found = 1;
                }
                elsif ($secs > $etimesec && $etimesec != 0)
                {
                    last;
                }        
            }                  
        }           
    
        if ($found == 1)
        {         
            print "$record";
        }  
    }     
}

close FH;  
