from java.io import *
from java.lang import String
import os;
import sys;

weblogichostname = sys.argv[1]
weblogicportnumber = sys.argv[2]
username = sys.argv[3]
#password = sys.argv[4]
machinename = sys.argv[4]
oraclehome = sys.argv[5]
wlhome = sys.argv[6]
modulehome = sys.argv[7]
ServerName = sys.argv[8]
ListenAddress = sys.argv[9]
ListenPort = int(sys.argv[10])
SSLListenPort = int(sys.argv[11])
connectiontype=sys.argv[12]
ExistingOMSServerName=sys.argv[13]
EMGC_DOMAIN_HOME=sys.argv[14]
JAMMANAGER_LOCATION=sys.argv[15]
JAMMANAGER_DUMMY_LOCATION=sys.argv[16]
IS_NEW_SERVER=sys.argv[17]
isWindows=int(sys.argv[18])
IS_DEPLOYED_APP=sys.argv[19]
applicationName = 'jammanager'+ServerName;

input = BufferedReader(InputStreamReader(System.in))
password = input.readLine().strip()

print "\n\nDeployment Summary: \n" "WEBLOGICHOSTNAME",weblogichostname,"\n WEBLOGICPORTNUMBER:",weblogicportnumber," \n USERNAME:",username," \n MACHINENAME:", machinename,"\n ORACLEHOME:", oraclehome,"\n WLHOME:", wlhome,"\n MODULEHOME:",modulehome,"\n SERVERNAME",ServerName,"\n LISTENADDRESS",ListenAddress,"\n LISTENPORT",ListenPort,"\n SSL LISTENPORT",SSLListenPort, "\n Existing OMS server name", ExistingOMSServerName, "\n Existing EMGC DOMAIN Home path", EMGC_DOMAIN_HOME


if(connectiontype=="http"):
	try:
		connect(username,password ,'t3://'+weblogichostname+':'+weblogicportnumber)
	except:
		print "connection refused"
		sys.exit(1)
else:
	try:
		connect(username,password ,'t3s://'+weblogichostname+':'+weblogicportnumber)
	except:
		print "connection refused"
		sys.exit(1)
#Check for New Server
try: 
	cd('/Servers/' + ServerName)
	cd('../..')
	print 'checking for new server'
	if IS_NEW_SERVER == "true":
		print '===> Server \"' +ServerName+'\" already exists'
		print '===> Weblogic Domain is inconsistent state . createServer command may fail. Please refresh the Weblogic Domain and rerun the job in case of failure'
		pass
except:
	pass

#Check for Deployed App
try:
	print '\n\nChecking for Deployed App'
	cd('AppDeployments')
	domainRuntime()
	cd("AppRuntimeStateRuntime/AppRuntimeStateRuntime")
	intendedState = cmo.getIntendedState(applicationName)
	if intendedState :
		print 'Intended state for application  is '  + intendedState
		if IS_DEPLOYED_APP =="false":
			print '===>'+applicationName + ' is already deployed\n'
			print '===> Weblogic Domain may be inconsistent state .Please refresh the Weblogic Domain and rerun the job in case of failure\n\n\n'
except:
	pass

#Check for Edit Session
cfgManager = getConfigManager()
try:
	if cfgManager.getCurrentEditor() is None:
                ### No session
		pass
	else:
		cfgManager.getChanges()
		print '===> Currently there is a Session'
		if cfgManager.isEditor() == "true":
                        ### You are making changes!!!
			print '===> Looks like you started that session'
			print '===> You can check the console for any pending changes'
			print '===> Try rerunning job after you release or commit the pending changes'
		else:
                        ### Someone else is making changes
			userWithSession = cfgManager.getCurrentEditor().replace(' ', '')
			print '===> User \"' +userWithSession+'\" is making the changes'
			print '===> Wait until \"' +userWithSession+'\" complete the current session'
		pass
	pass
except Exception:
        ### Other Errors
	print '===> Error, see log for more info'
	exit()

if(IS_DEPLOYED_APP=="false"):
	#Deploy dummy jammanager on OMS box
	print "\n\nDeploying Jammanager Dummy on ",ExistingOMSServerName , "\n This will make jammanager entry to system-jazn-data.xml\n"
	try:
		deploy('jammanager_dummy',JAMMANAGER_DUMMY_LOCATION, targets=ExistingOMSServerName, timeout=600000,upload='true')
	except Exception:
		print Exception, "\n"
		undo("true","y")
		disconnect()
		exit()

	print "\n\nUndeploying Jammanager Dummy from ",ExistingOMSServerName, "\n"
	stopApplication('jammanager_dummy')
	undeploy('jammanager_dummy', targets=ExistingOMSServerName)

try:
	edit()
	startEdit()

	if(IS_NEW_SERVER=="true"):
		print "\n\nCreating new Managed Server\n"
		cmo.createServer(ServerName)
		print "\n\nCreated Server.\n"
		print("\n\nNow setting up properties\n");
		cd('/Servers/'+ServerName)
		cmo.setMachine(getMBean('/Machines/' + machinename))
		cmo.setListenAddress(ListenAddress)
		cmo.setListenPort(ListenPort)
		cmo.setKeyStores('DemoIdentityAndDemoTrust')
		cd('/Servers/' + ServerName + '/SSL/' + ServerName)
		cmo.setListenPort(SSLListenPort)
		cmo.setEnabled(true)
		cmo.setTwoWaySSLEnabled(false)
		cmo.setHostnameVerificationIgnored(true)

	cd('/Servers/' + ServerName + '/Log/' + ServerName)
	cmo.setNumberOfFilesLimited(true)
	cmo.setFileCount(10)
	cmo.setLogFileSeverity('Warning')

	cd('/Servers/' + ServerName + '/ServerStart/' + ServerName)
	cmo.setArguments(' -DORACLE_HOME=' + oraclehome + ' -Docm.repeater.home=' + oraclehome  + ' -Ddomain.home=' + EMGC_DOMAIN_HOME)

	if(isWindows == 1):
                cmo.setClassPath(wlhome + '/server/lib/weblogic_sp.jar;' + wlhome + '/server/lib/weblogic.jar;' + modulehome + '/com.bea.core.apache.log4j_1.2.13.jar;' + oraclehome + '/sysman/jlib/emCORE.jar;' + oraclehome + '/sysman/jlib/emagentSDK.jar;' + oraclehome + '/sysman/jlib/log4j-core.jar;' + oraclehome + '/sysman/jlib/emcoreAgent.jar;' + oraclehome + '/sysman/jlib/emCoreSDK.jar;' + oraclehome + '/sysman/jlib/emCoreSDKImpl.jar')
	else:
                cmo.setClassPath(wlhome + '/server/lib/weblogic_sp.jar:' + wlhome + '/server/lib/weblogic.jar:' + modulehome + '/com.bea.core.apache.log4j_1.2.13.jar:' + oraclehome + '/sysman/jlib/emCORE.jar:' + oraclehome + '/sysman/jlib/emagentSDK.jar:' + oraclehome + '/sysman/jlib/log4j-core.jar:' + oraclehome + '/sysman/jlib/emcoreAgent.jar:' + oraclehome + '/sysman/jlib/emCoreSDK.jar:' + oraclehome + '/sysman/jlib/emCoreSDKImpl.jar')

	save()
        activate()

	#Starting the server
	print "\n\nStarting Server \n"
	start(ServerName, "Server")
	print "\nStarted Server Successfully\n"

	edit()
	startEdit()
	#Setting the data source
	cd('/SystemResources/sysman-opss-ds')
	targets = get('Targets')
	print "Targets ",targets,"\n"

	seq=[ObjectName('com.bea:Name='+ServerName+',Type=Server')]
	newtarget=array(seq,ObjectName)

	newtargets=array(targets+newtarget,ObjectName)
	print "new Targets ",newtargets,"\n"
	set('Targets',newtargets)

	#start(ServerName, "Server")
	save()
        activate()

	#Deployment
	cd('/Servers/'+ServerName)
	if(IS_DEPLOYED_APP=="true"):
		print "\n\nRedeploying Jammanager on ",ServerName, "\n"
		redeploy('jammanager'+ServerName, timeout=300000)

	if(IS_DEPLOYED_APP=="false"):
		print "Deploying Jammanager on ",ServerName, "\n"
		deploy('jammanager'+ServerName,JAMMANAGER_LOCATION, targets=ServerName,  timeout=300000, upload='true')

	disconnect()
	exit()
except Exception:
	print Exception, "\nError deploying jam manager\n"
	stopEdit("y")
	disconnect()
	raise
	exit()

